<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class VatTaxController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$crud = new \App\Library\Crud;
		$info = $crud->Getvalue('ProductTax');
		return view('vat.index', compact('info'));
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$request->validate([
			'tax_rate' => 'required|unique:product_taxes',
			'start_date' => 'required',
			'end_date' => 'required',

		]);
		$crud = new \App\Library\Crud;
		$crud->InsertValue('ProductTax', $request->all());
		$info = $crud->Getvalue('ProductTax');
		return view('vat.table', compact('info'));
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('ProductTax', ['id', $id]);
		return view('vat.edit', compact('info'));
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$request->validate([
			'tax_rate' => 'required|unique:product_taxes,id,' . $request->id,
			'start_date' => 'required',
			'end_date' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'ProductTax', ['id', $request->id]);
		return redirect('vat')->with('message', 'Updated Successfully');
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$crud = new \App\Library\Crud;
		$crud->DeleteValueWhereSingle('ProductTax', ['id', $id]);
		return redirect('vat')->with('message', 'Deleted Successfully');
	}
}
