<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class TransectionTermsController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$crud = new \App\Library\Crud;
		$info = $crud->Getvalue('TransactionTerm');
		return view('transaction-terms.index', compact('info'));
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$crud = new \App\Library\Crud;
		if ($request->action == 'modal') {
			$crud_result = $crud->InsertValue('TransactionTerm', $request->all(), true);
			return $crud_result;
		} else {
			$request->validate([
				'name' => 'required|unique:transaction_terms',
			]);
			$crud = new \App\Library\Crud;
			$crud->InsertValue('TransactionTerm', $request->all());
			$info = $crud->Getvalue('TransactionTerm');
			return view('transaction-terms.table', compact('info'));
		}
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('TransactionTerm', ['id', $id]);
		return view('transaction-terms.edit', compact('info'));

	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$request->validate([
			'name' => 'required|unique:transaction_terms,name,' . $request->id,
		]);

		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'TransactionTerm', ['id', $request->id]);
		return redirect('transaction-terms')->with('message', 'Updated Successfully');
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$crud = new \App\Library\Crud;
		$crud->DeleteValueWhereSingle('TransactionTerm', ['id', $id]);
		return redirect('transaction-terms')->with('message', 'Deleted Successfully');
	}
}
