<?php

namespace App\Http\Controllers;

use App\AdvancePaidAccount;
use App\AdvanceReceiveAccount;
use App\BankAccounts;
use App\CapitalAccount;
use App\CashBook;
use App\CustomerAccounts;
use App\ExpenseAccount;
use App\MobileBankAccounts;
use App\SalesOrder;
use App\SupplierAccount;
use Auth;
use DateTime;
use DateTimezone;
use DB;
use Illuminate\Http\Request;
use Session;
use Carbon\Carbon;

class TransectionController extends Controller {



	public function transectionPrintView($id,$print_view=""){
		$info = DB::table("cash_bank_mobilebank_view")
		->select('cash_bank_mobilebank_view.*','users.name')
		->leftJoin('users','users.id','cash_bank_mobilebank_view.created_by')
		->where('cash_bank_mobilebank_view._transection_unique_id',$id)->first();
		// print_r($info);
		// die();
		return view('transection.receipt_voucher',compact('info','print_view'));
	}
	public function transectionPrintPrint($id,$print_view="print_view"){
		$info = DB::table("cash_bank_mobilebank_view")
		->select('cash_bank_mobilebank_view.*','users.name')
		->leftJoin('users','users.id','cash_bank_mobilebank_view.created_by')
		->where('cash_bank_mobilebank_view._transection_unique_id',$id)->first();
		// print_r($info);
		// die();
		return view('transection.receipt_voucher',compact('info','print_view'));
	}

	
	//receive transection list
	public function receiveTransectionList(Request $request){
		
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}
			$start_strtotime = strtotime("$start_date 00:00:00");
			$end_strtotime = strtotime("$end_date 23:59:59");
			$start_time = date('Y-m-d H:i:s', $start_strtotime);
			$end_time = date('Y-m-d H:i:s', $end_strtotime);


			$info = DB::select(" SELECT cash_bank_mobilebank_view.*, users.name as name FROM cash_bank_mobilebank_view left join users on users.id=cash_bank_mobilebank_view.created_by  WHERE (transection_date BETWEEN '".$start_time."' AND '".$end_time."') ORDER BY transection_date  DESC ");

			//return $info;

			return view('transection.receive_transection_list',compact('info','request'));

	}
	//receive transection list
	public function paymentTransectionList(Request $request){
		
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}
			$start_strtotime = strtotime("$start_date 00:00:00");
			$end_strtotime = strtotime("$end_date 23:59:59");
			$start_time = date('Y-m-d H:i:s', $start_strtotime);
			$end_time = date('Y-m-d H:i:s', $end_strtotime);


			$info = DB::select(" SELECT cash_bank_mobilebank_payment_view.*, users.name as name FROM cash_bank_mobilebank_payment_view left join users on users.id=cash_bank_mobilebank_payment_view.created_by  WHERE (transection_date BETWEEN '".$start_time."' AND '".$end_time."') ORDER BY transection_date  DESC ");

			//return $info;

			return view('transection.payment_transection_list',compact('info','request'));

	}

	public function paymentPrintView($id,$print_view=""){
		$info = DB::table("cash_bank_mobilebank_payment_view")
		->select('cash_bank_mobilebank_payment_view.*','users.name')
		->leftJoin('users','users.id','cash_bank_mobilebank_payment_view.created_by')
		->where('cash_bank_mobilebank_payment_view._transection_unique_id',$id)->first();
		// print_r($info);
		// die();
		return view('transection.payment_voucher',compact('info','print_view'));
	}
	public function paymentPrintPrint($id,$print_view="print_view"){
		$info = DB::table("cash_bank_mobilebank_payment_view")
		->select('cash_bank_mobilebank_payment_view.*','users.name')
		->leftJoin('users','users.id','cash_bank_mobilebank_payment_view.created_by')
		->where('cash_bank_mobilebank_payment_view._transection_unique_id',$id)->first();
		// print_r($info);
		// die();
		return view('transection.payment_voucher',compact('info','print_view'));
	}

	public static  function getAccountName($id, $ref_no,$_table_name,$phone='',$address=''){
		if($ref_no !=''){
			if($ref_no == "capital"){
			$_table_name = "owner_profiles";
			}elseif($ref_no == "cash"){
				return "Cash Book";
			}elseif($ref_no == "opening"){
				return "Opening";
			}elseif($ref_no == "customer"){
				$_table_name = "customer_profiles";
			}elseif($ref_no == "supplier"){
				$_table_name = "supplier_profiles";
			}elseif($ref_no == "bank"){
				$_table_name = "bank_account_profiles";
			}elseif($ref_no == "mobile"){
				$_table_name = "mobile_bank_accounts_profiles";
			}elseif($ref_no == "expense"){
				$_table_name = "expense_profiles";
			}elseif($ref_no == "employee"){
				$_table_name = "employee_profiles";
			}elseif($ref_no == "vendor"){
				$_table_name = "vendor_profiles";
			}elseif($ref_no=="capital"){
				$_table_name = "owner_profiles";
			}
			if($phone !=""){
				if($_table_name=="bank_account_profiles" || $_table_name=="mobile_bank_accounts_profiles"){
				 $name = DB::table($_table_name)->select('phone as phone')->where('id',$id)->first();
				}else{
					 $name = DB::table($_table_name)->select('phone as phone')->where('id',$id)->first();
				}

				return $name->phone ?? '';
			}elseif($address !=""){
				if($_table_name=="bank_account_profiles" || $_table_name=="mobile_bank_accounts_profiles"){
				 $name = DB::table($_table_name)->select('address as address')->where('id',$id)->first();
				}else{
					 $name = DB::table($_table_name)->select('address as address')->where('id',$id)->first();
				}

				return $name->address ?? '';
			}else{
				if($_table_name=="bank_account_profiles" || $_table_name=="mobile_bank_accounts_profiles"){
				 $name = DB::table($_table_name)->select('bank_name as name')->where('id',$id)->first();
				}else{
					 $name = DB::table($_table_name)->select('name as name')->where('id',$id)->first();
				}

				return $name->name ?? '';
			}
			
		}else{
			if($phone !=""){
				if($_table_name =="cash_books"){
						$name = DB::table("cash_profiles")->select('phone as phone')->where('id',$id)->first();
						}elseif($_table_name =="mobile_bank_accounts"){
							$name = DB::table("mobile_bank_accounts_profiles")->select('phone as phone')->where('id',$id)->first();
						}elseif($_table_name =="bank_accounts"){
							$name = DB::table("bank_account_profiles")->select('phone as phone')->where('id',$id)->first();
						}
						return $name->phone ?? '';

			}elseif($address !=""){
					if($_table_name =="cash_books"){
						$name = DB::table("cash_profiles")->select('address as address')->where('id',$id)->first();
						}elseif($_table_name =="mobile_bank_accounts"){
							$name = DB::table("mobile_bank_accounts_profiles")->select('address as address')->where('id',$id)->first();
						}elseif($_table_name =="bank_accounts"){
							$name = DB::table("bank_account_profiles")->select('address as address')->where('id',$id)->first();
						}
						return $name->address ?? '';
			}else{
				if($_table_name =="cash_books"){
				$name = DB::table("cash_profiles")->select('name as name')->where('id',$id)->first();
				}elseif($_table_name =="mobile_bank_accounts"){
					$name = DB::table("mobile_bank_accounts_profiles")->select(DB::raw("CONCAT(bank_name,' ',bank_account) AS name"))->where('id',$id)->first();
				}elseif($_table_name =="bank_accounts"){
					$name = DB::table("bank_account_profiles")->select(DB::raw("CONCAT(bank_name,' ',bank_account) AS name"))->where('id',$id)->first();
				}
				return $name->name ?? '';
			}
			
		}
		
		
	}


	//AMOUNT RECEIVE TO BANK / CASH / MOBILE BANK ACCOUNTS
	public function amountReceived(Request $request) {
		DB::beginTransaction();
		try {
			//dump($request->all());die();
			$request->validate([
				'receive_from_account' => 'required',
				'amount' => 'required',
				'note' => 'required',

			]);
			$request->amount = floatval($request->amount);
			$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
			$date = $dt->format('Y-m-d H:i:s');

			//FUND TRANSFER TO CASH ACCOUNT
			if ($request->receive_account_type == 'cash') {
				$quuery = "SELECT SUM((IFNULL(debit,0)-IFNULL(credit,0))) as balance FROM cash_books ";
				$checkBalance = DB::select($quuery);
				$netBalance = $checkBalance[0]->balance;
				if ($netBalance >= $request->amount) {
					$CashBook = new CashBook();
					if ($request->has('stored_bank_account')) {
						$CashBook->account_no = $request->stored_bank_account;
						
					}
					if ($request->has('stored_mobiile_account')) {
						$CashBook->account_no = $request->stored_mobiile_account;
						
					}
					if ($request->has('stored_cash_account')) {
						$CashBook->account_no = $request->stored_cash_account;
						
					}
					$CashBook->own_account_no = $request->receive_from_account;
					$CashBook->transection_date = $date;
					$CashBook->credit = $request->amount;
					$CashBook->description = $request->note;
					$CashBook->created_by = Auth::user()->id;
					$CashBook->status = 1;
					$CashBook->save();
					Session::flash('message', 'Fund Transfer from Cash Books  . transfered Amount ' . number_format($request->amount, 2) . '');
				} else {
					Session::flash('errormessage', 'Balance is not sufficient . Net Cash Balance is TK.' . number_format($netBalance, 2) . '');
					return redirect('transection-receive');
				}

			}
			
			//FUND RECEIVED FROM  BANK ACCOUNT
			if ($request->receive_account_type == 'bank') {
				/*$quuery = "SELECT SUM((IFNULL(debit,0)-IFNULL(credit,0))) as balance FROM bank_accounts WHERE account_no=" . $request->receive_from_account . "";
					$checkBalance = DB::select($quuery);
					$netBalance = $checkBalance[0]->balance;
				*/


				$BankAccounts = new BankAccounts();
				$BankAccounts->own_account_no = $request->receive_from_account;
				$BankAccounts->description = $request->note;
				$BankAccounts->transection_date = $date;
				$BankAccounts->credit = $request->amount;
				$BankAccounts->created_by = Auth::user()->id;
				$BankAccounts->status = 1;
				if ($request->has('stored_bank_account')) {
					$BankAccounts->account_no = $request->stored_bank_account;
					
				}
				if ($request->has('stored_mobiile_account')) {
					$BankAccounts->account_no = $request->stored_mobiile_account;
					
				}
				if ($request->has('stored_cash_account')) {
					$BankAccounts->account_no = $request->stored_cash_account;
					
				}
				$BankAccounts->save();
				Session::flash('message', 'Fund Transfer from ' . $request->receive_from_account . 'Bank Account . transfered Amount ' . number_format($request->amount, 2) . '');
				/*} else {
					Session::flash('errormessage', 'Balance is not sufficient . This ' . $request->receive_from_account . ' Account Balance is TK.' . number_format($netBalance, 2) . '');
					return redirect('transection-receive');
				}*/

			}
			//FUND RECEIVED FROM  MOBILE BANK  ACCOUNT
			if ($request->receive_account_type == 'mobile_bank') {
				$quuery = "SELECT SUM((IFNULL(debit,0)-IFNULL(credit,0))) as balance FROM mobile_bank_accounts WHERE account_no=" . $request->receive_from_account . "";
				$checkBalance = DB::select($quuery);
				$netBalance = $checkBalance[0]->balance;
				if ($netBalance >= $request->amount) {
					$MobileBankAccounts = new MobileBankAccounts();
					$MobileBankAccounts->own_account_no = $request->receive_from_account;
					$MobileBankAccounts->description = $request->note;
					$MobileBankAccounts->transection_date = $date;
					$MobileBankAccounts->credit = $request->amount;
					$MobileBankAccounts->created_by = Auth::user()->id;
					$MobileBankAccounts->status = 1;
					if ($request->has('stored_bank_account')) {
					$MobileBankAccounts->account_no = $request->stored_bank_account;
					
					}
					if ($request->has('stored_mobiile_account')) {
						$MobileBankAccounts->account_no = $request->stored_mobiile_account;
						
					}
					if ($request->has('stored_cash_account')) {
						$MobileBankAccounts->account_no = $request->stored_cash_account;
						
					}
					$MobileBankAccounts->save();
					Session::flash('message', 'Fund Transfer from ' . $request->receive_from_account . 'MobileBank Account . transfered Amount ' . number_format($request->amount, 2) . '');
				} else {
					Session::flash('errormessage', 'Balance is not sufficient . This Account Balance is TK.' . number_format($netBalance, 2) . '');
					return redirect('transection-receive');
				}

			}
			if ($request->receive_account_type == 'account_receivable') {
				$checkDueAmount = SalesOrder::select('id', 'due_amount', 'customer_Id', 'receive_amount_from_custome')
					->where('due_amount', '>', 0)
					->where('customer_Id', $request->receive_from_account)
					->orderBy('id', 'ASC')->get();
				if (!empty($checkDueAmount)) {
					$receiveAccount = $request->amount;
					foreach ($checkDueAmount as $dueAmount) {
						if ($receiveAccount >= $dueAmount->due_amount) {
							$receive_amount_from_custome = $dueAmount->receive_amount_from_custome ?? 0;
							$full_amount = $receive_amount_from_custome + $dueAmount->due_amount ?? 0;
							$due_amount = $dueAmount->due_amount - $dueAmount->due_amount ?? 0;
							DB::table('sales_orders')
								->where('id', $dueAmount->id)
								->update(['receive_amount_from_custome' => $full_amount, 'due_amount' => $due_amount]);
							$receiveAccount -= $dueAmount->due_amount;
						} elseif ($receiveAccount != 0 && $receiveAccount < $dueAmount->due_amount) {
							$receive_amount_from_custome = $dueAmount->receive_amount_from_custome ?? 0;
							$full_amount = $receive_amount_from_custome + $receiveAccount ?? 0;
							$due_amount = $dueAmount->due_amount - $receiveAccount ?? 0;
							DB::table('sales_orders')
								->where('id', $dueAmount->id)
								->update(['receive_amount_from_custome' => $full_amount, 'due_amount' => $due_amount]);
							$receiveAccount -= $receiveAccount;
						}

					}

				} else {
					//die('No due amount');
				}

				//DATA INSERT INTO CUSTOMER ACCOUNTS TABLE
				$CustomerAccounts = new CustomerAccounts();
				$CustomerAccounts->account_no = $request->receive_from_account;
				$CustomerAccounts->transection_no = null;
				$CustomerAccounts->transection_date = $date;
				$CustomerAccounts->credit = $request->amount;
				$CustomerAccounts->description = $request->note;
				$CustomerAccounts->status = 1;
				$CustomerAccounts->created_by = Auth::user()->id;
				$CustomerAccounts->save();

			}

			//FUND RECEIVED FROM SUPPLIER
			if ($request->receive_account_type == 'account_payable') {
				$SupplierAccount = new SupplierAccount();
				$SupplierAccount->account_no = $request->receive_from_account;
				$SupplierAccount->description = $request->note;
				$SupplierAccount->transection_date = $date;
				$SupplierAccount->credit = $request->amount;
				$SupplierAccount->created_by = Auth::user()->id;
				$SupplierAccount->status = 1;
				$SupplierAccount->save();

			}
			//FUND RECEIVED FROM LOAN
			if ($request->receive_account_type == 'loan_receive_account') {
				$AdvanceReceiveAccount = new AdvanceReceiveAccount();
				$AdvanceReceiveAccount->account_no = $request->receive_from_account;
				$AdvanceReceiveAccount->description = $request->note;
				$AdvanceReceiveAccount->transection_date = $date;
				$AdvanceReceiveAccount->credit = $request->amount;
				$AdvanceReceiveAccount->created_by = Auth::user()->id;
				$AdvanceReceiveAccount->status = 1;
				$AdvanceReceiveAccount->save();

			}
			//FUND RECEIVED FROM INVESTMENT
			if ($request->receive_account_type == 'investment_account') {
				$AdvancePaidAccount = new AdvancePaidAccount();
				$AdvancePaidAccount->account_no = $request->receive_from_account;
				$AdvancePaidAccount->description = $request->note;
				$AdvancePaidAccount->transection_date = $date;
				$AdvancePaidAccount->credit = $request->amount;
				$AdvancePaidAccount->created_by = Auth::user()->id;
				$AdvancePaidAccount->status = 1;
				$AdvancePaidAccount->save();

			}
			//FUND RECEIVED FROM EXPENSES
			if ($request->receive_account_type == 'expenses') {
				$ExpenseAccount = new ExpenseAccount();
				$ExpenseAccount->account_no = $request->receive_from_account;
				$ExpenseAccount->description = $request->note;
				$ExpenseAccount->transection_date = $date;
				$ExpenseAccount->credit = $request->amount;
				$ExpenseAccount->created_by = Auth::user()->id;
				$ExpenseAccount->status = 1;
				$ExpenseAccount->save();

			}
			//FUND RECEIVED FROM OWNERS
			if ($request->receive_account_type == 'capital') {
				$CapitalAccount = new CapitalAccount();
				$CapitalAccount->account_no = $request->receive_from_account;
				$CapitalAccount->description = $request->note;
				$CapitalAccount->transection_date = $date;
				$CapitalAccount->credit = $request->amount;
				$CapitalAccount->created_by = Auth::user()->id;
				$CapitalAccount->status = 1;
				$CapitalAccount->save();

			}

			//WHEN RECEIVED TO == CASH THEN RUN THIS CODE
			if ($request->store_place == 'cash') {
				$CashBook = new CashBook();
				$CashBook->own_account_no = $request->receive_from_account ?? '';
				$CashBook->account_no = $request->stored_cash_account ?? '';
				$CashBook->refeance_no = null;
				$CashBook->transection_date = $date;
				$CashBook->debit = $request->amount;
				if ($request->receive_account_type == 'account_receivable') {
					$CashBook->person_type = 'customer';
				} elseif ($request->receive_account_type == 'capital') {
					$CashBook->person_type = 'capital';
				} elseif ($request->receive_account_type == 'account_payable') {
					$CashBook->person_type = 'supplier';
				} elseif ($request->receive_account_type == 'expenses') {
					$CashBook->person_type = 'expense';
				} elseif ($request->receive_account_type == 'investment_account') {
					$CashBook->person_type = 'investment';
				} elseif ($request->receive_account_type == 'loan_receive_account') {
					$CashBook->person_type = 'loan';
				} elseif ($request->receive_account_type == 'mobile_bank') {
					$CashBook->person_type = 'mobile';
				} elseif ($request->receive_account_type == 'bank') {
					$CashBook->person_type = 'bank';
				}
				$CashBook->description = $request->note;
				$CashBook->created_by = Auth::user()->id;
				$CashBook->status = 1;
				$CashBook->save();
			}
			//WHEN RECEIVED TO == BANK THEN RUN THIS CODE
			if ($request->store_place == 'bank') {
				$request->validate([
					'stored_bank_account' => 'required',
				]);
				$BankAccounts = new BankAccounts();
				$BankAccounts->account_no = $request->stored_bank_account;
				$BankAccounts->own_account_no = $request->receive_from_account ?? '';
				$BankAccounts->transection_date = $date;
				$BankAccounts->debit = $request->amount;
				if ($request->receive_account_type == 'account_receivable') {
					$BankAccounts->ref_no = 'customer';
				} elseif ($request->receive_account_type == 'capital') {
					$BankAccounts->ref_no = 'capital';
				} elseif ($request->receive_account_type == 'account_payable') {
					$BankAccounts->ref_no = 'supplier';
				} elseif ($request->receive_account_type == 'expenses') {
					$BankAccounts->ref_no = 'expense';
				} elseif ($request->receive_account_type == 'investment_account') {
					$BankAccounts->ref_no = 'investment';
				} elseif ($request->receive_account_type == 'loan_receive_account') {
					$BankAccounts->ref_no = 'loan';
				} elseif ($request->receive_account_type == 'mobile_bank') {
					$BankAccounts->ref_no = 'mobile';
				} elseif ($request->receive_account_type == 'bank') {
					$BankAccounts->ref_no = 'bank';
				} elseif ($request->receive_account_type == 'cash') {
					$BankAccounts->ref_no = 'cash';
				}
				$BankAccounts->description = $request->note;
				$BankAccounts->created_by = Auth::user()->id;
				$BankAccounts->status = 1;
				$BankAccounts->save();
			}
			//WHEN RECEIVED TO ==MOBILE BANK THEN RUN THIS CODE
			if ($request->store_place == 'mobile_bank') {
				$request->validate([
					'stored_mobiile_account' => 'required',
				]);
				$MobileBankAccounts = new MobileBankAccounts();
				$MobileBankAccounts->account_no = $request->stored_mobiile_account;
				$MobileBankAccounts->own_account_no = $request->receive_from_account ?? '';
				$MobileBankAccounts->transection_date = $date;
				$MobileBankAccounts->debit = $request->amount;
				if ($request->receive_account_type == 'account_receivable') {
					$MobileBankAccounts->ref_no = 'customer';
				} elseif ($request->receive_account_type == 'capital') {
					$MobileBankAccounts->ref_no = 'capital';
				} elseif ($request->receive_account_type == 'account_payable') {
					$MobileBankAccounts->ref_no = 'supplier';
				} elseif ($request->receive_account_type == 'expenses') {
					$MobileBankAccounts->ref_no = 'expense';
				} elseif ($request->receive_account_type == 'investment_account') {
					$MobileBankAccounts->ref_no = 'investment';
				} elseif ($request->receive_account_type == 'loan_receive_account') {
					$MobileBankAccounts->ref_no = 'loan';
				} elseif ($request->receive_account_type == 'mobile_bank') {
					$MobileBankAccounts->ref_no = 'mobile';
				} elseif ($request->receive_account_type == 'bank') {
					$MobileBankAccounts->ref_no = 'bank';
				} elseif ($request->receive_account_type == 'cash') {
					$MobileBankAccounts->ref_no = 'cash';
				}
				$MobileBankAccounts->description = $request->note;
				$MobileBankAccounts->created_by = Auth::user()->id;
				$MobileBankAccounts->status = 1;
				$MobileBankAccounts->save();
			}
			DB::commit();
			return redirect()->back();

		} catch (Exception $e) {
			DB::rollback();
			return $e->getMessage();
		}

	}

	public function amountPaid(Request $request) {
		//dump($request->all());die();
		DB::beginTransaction();
		try {
			$request->validate([
				'paid_place' => 'required',
				'receive_from_account' => 'required',
				'amount' => 'required',
				'note' => 'required',

			]);
			$request->amount = floatval($request->amount);
			$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
			$date = $dt->format('Y-m-d H:i:s');
			//AMOUNT PAID FROM CASH BOOKS
			if ($request->paid_place == 'cash') {
				$quuery = "SELECT SUM((IFNULL(debit,0)-IFNULL(credit,0))) as balance FROM cash_books ";
				$checkBalance = DB::select($quuery);
				$netBalance = $checkBalance[0]->balance;

				if ($netBalance >= $request->amount) {
					$CashBook = new CashBook();
					$CashBook->account_no = $request->receive_from_account;
					$CashBook->refeance_no = null;
					$CashBook->transection_date = $date;
					$CashBook->credit = $request->amount;
					if ($request->receive_account_type == 'account_receivable') {
						$CashBook->person_type = 'customer';
					} elseif ($request->receive_account_type == 'capital') {
						$CashBook->person_type = 'capital';
					} elseif ($request->receive_account_type == 'account_payable') {
						$CashBook->person_type = 'supplier';
					} elseif ($request->receive_account_type == 'expenses') {
						$CashBook->person_type = 'expense';
					} elseif ($request->receive_account_type == 'investment_account') {
						$CashBook->person_type = 'investment';
					} elseif ($request->receive_account_type == 'loan_receive_account') {
						$CashBook->person_type = 'loan';
					}
					$CashBook->description = $request->note;
					$CashBook->created_by = Auth::user()->id;
					$CashBook->status = 1;
					$CashBook->save();
					Session::flash('message', 'Transection Succesfully  TK.' . number_format($request->amount, 2) . '');
				} else {
					Session::flash('errormessage', 'Balance is not sufficient . This Account Balance is TK.' . number_format($netBalance, 2) . '');
					return redirect('transection-paid');
				}

			}

			//AMOUNT PAID FROM BANK ACCOUNTS
			if ($request->paid_place == 'bank') {
				$BankAccounts = new BankAccounts();
				$BankAccounts->account_no = $request->stored_bank_account;
				$BankAccounts->transection_date = $date;
				$BankAccounts->credit = $request->amount;
				if ($request->receive_account_type == 'account_receivable') {
					$BankAccounts->ref_no = 'customer';
				} elseif ($request->receive_account_type == 'capital') {
					$BankAccounts->ref_no = 'capital';
				} elseif ($request->receive_account_type == 'account_payable') {
					$BankAccounts->ref_no = 'supplier';
				} elseif ($request->receive_account_type == 'expenses') {
					$BankAccounts->ref_no = 'expense';
				} elseif ($request->receive_account_type == 'investment_account') {
					$BankAccounts->ref_no = 'investment';
				} elseif ($request->receive_account_type == 'loan_receive_account') {
					$BankAccounts->ref_no = 'loan';
				}
				$BankAccounts->description = $request->note;
				$BankAccounts->created_by = Auth::user()->id;
				$BankAccounts->status = 1;
				$BankAccounts->save();
				Session::flash('message', 'Transection Succesfully  TK.' . number_format($request->amount, 2) . '');
			}
			//AMOUNT PAID FROM MOBILE BANK ACCOUNT
			if ($request->paid_place == 'mobile_bank') {
				$request->validate([
					'stored_mobiile_account' => 'required',
				]);
				$quuery = "SELECT SUM((IFNULL(debit,0)-IFNULL(credit,0))) as balance FROM mobile_bank_accounts WHERE account_no=" . $request->stored_mobiile_account . "";
				$checkBalance = DB::select($quuery);
				$netBalance = $checkBalance[0]->balance;
				if ($netBalance >= $request->amount) {
					$MobileBankAccounts = new MobileBankAccounts();
					$MobileBankAccounts->account_no = $request->stored_mobiile_account;
					$MobileBankAccounts->own_account_no = $request->receive_from_account;
					$MobileBankAccounts->transection_date = $date;
					$MobileBankAccounts->credit = $request->amount;
					if ($request->receive_account_type == 'account_receivable') {
						$MobileBankAccounts->ref_no = 'customer';
					} elseif ($request->receive_account_type == 'capital') {
						$MobileBankAccounts->ref_no = 'capital';
					} elseif ($request->receive_account_type == 'account_payable') {
						$MobileBankAccounts->ref_no = 'supplier';
					} elseif ($request->receive_account_type == 'expenses') {
						$MobileBankAccounts->ref_no = 'expense';
					} elseif ($request->receive_account_type == 'investment_account') {
						$MobileBankAccounts->ref_no = 'investment';
					} elseif ($request->receive_account_type == 'loan_receive_account') {
						$MobileBankAccounts->ref_no = 'loan';
					}
					$MobileBankAccounts->description = $request->note;
					$MobileBankAccounts->created_by = Auth::user()->id;
					$MobileBankAccounts->status = 1;
					$MobileBankAccounts->save();
					Session::flash('message', 'Transection Succesfully  TK.' . number_format($request->amount, 2) . '');
				} else {
					Session::flash('errormessage', 'Balance is not sufficient . This Account Balance is TK.' . number_format($netBalance, 2) . '');
					return redirect('transection-paid');
				}

			}
			if ($request->receive_account_type == 'account_receivable') {
				//DATA INSERT INTO CUSTOMER ACCOUNTS TABLE
				$CustomerAccounts = new CustomerAccounts();
				$CustomerAccounts->account_no = $request->receive_from_account;
				$CustomerAccounts->transection_no = null;
				$CustomerAccounts->account_no = $request->receive_from_account;
				$CustomerAccounts->transection_date = $date;
				$CustomerAccounts->debit = $request->amount;
				$CustomerAccounts->description = $request->note;
				$CustomerAccounts->status = 1;
				$CustomerAccounts->created_by = Auth::user()->id;
				$CustomerAccounts->save();

			}

			//FUND RECEIVED FROM SUPPLIER
			if ($request->receive_account_type == 'account_payable') {
				$query = "SELECT p.id,p.`supplier_Id`,IFNULL(p.`net_amount`,0),
						IFNULL(p.`payment_amount`,0),
						(IFNULL(p.net_amount,0)-IFNULL(p.`payment_amount`,0)) as due_amount
						 FROM `purchase_orders` as  p WHERE p.`order_type`='purchase' AND p.`supplier_Id`=" . $request->receive_from_account . "  HAVING due_amount > 0 ";
				$checkDueAmount = DB::select($query);
				if (!empty($checkDueAmount)) {
					$paidAccount = $request->amount;
					foreach ($checkDueAmount as $dueAmount) {
						if ($paidAccount >= $dueAmount->due_amount) {
							$payment_amount = $dueAmount->payment_amount ?? 0;
							$full_amount = $payment_amount + $dueAmount->due_amount ?? 0;
							$due_amount = $dueAmount->due_amount - $dueAmount->due_amount ?? 0;
							DB::table('purchase_orders')
								->where('id', $dueAmount->id)
								->update(['payment_amount' => $full_amount]);
							$paidAccount -= $dueAmount->due_amount;
						} elseif ($paidAccount != 0 && $paidAccount < $dueAmount->due_amount) {
							$payment_amount = $dueAmount->payment_amount ?? 0;
							$full_amount = $payment_amount + $paidAccount ?? 0;
							$due_amount = $dueAmount->due_amount - $paidAccount ?? 0;
							DB::table('purchase_orders')
								->where('id', $dueAmount->id)
								->update(['payment_amount' => $full_amount]);
							$paidAccount -= $paidAccount;
						}

					}

				} else {
					//die('No due amount');
				}
				$SupplierAccount = new SupplierAccount();
				$SupplierAccount->account_no = $request->receive_from_account;
				$SupplierAccount->description = $request->note;
				$SupplierAccount->transection_date = $date;
				$SupplierAccount->debit = $request->amount;
				$SupplierAccount->created_by = Auth::user()->id;
				$SupplierAccount->status = 1;
				$SupplierAccount->save();

			}
			//FUND RECEIVED FROM LOAN
			if ($request->receive_account_type == 'loan_receive_account') {
				$AdvanceReceiveAccount = new AdvanceReceiveAccount();
				$AdvanceReceiveAccount->account_no = $request->receive_from_account;
				$AdvanceReceiveAccount->description = $request->note;
				$AdvanceReceiveAccount->transection_date = $date;
				$AdvanceReceiveAccount->debit = $request->amount;
				$AdvanceReceiveAccount->created_by = Auth::user()->id;
				$AdvanceReceiveAccount->status = 1;
				$AdvanceReceiveAccount->save();

			}
			//FUND RECEIVED FROM INVESTMENT
			if ($request->receive_account_type == 'investment_account') {
				$AdvancePaidAccount = new AdvancePaidAccount();
				$AdvancePaidAccount->account_no = $request->receive_from_account;
				$AdvancePaidAccount->description = $request->note;
				$AdvancePaidAccount->transection_date = $date;
				$AdvancePaidAccount->debit = $request->amount;
				$AdvancePaidAccount->created_by = Auth::user()->id;
				$AdvancePaidAccount->status = 1;
				$AdvancePaidAccount->save();

			}
			//FUND RECEIVED FROM EXPENSES
			if ($request->receive_account_type == 'expenses') {
				$ExpenseAccount = new ExpenseAccount();
				$ExpenseAccount->account_no = $request->receive_from_account;
				$ExpenseAccount->description = $request->note;
				$ExpenseAccount->transection_date = $date;
				$ExpenseAccount->debit = $request->amount;
				$ExpenseAccount->created_by = Auth::user()->id;
				$ExpenseAccount->status = 1;
				$ExpenseAccount->save();

			}
			//FUND RECEIVED FROM OWNERS
			if ($request->receive_account_type == 'capital') {
				$CapitalAccount = new CapitalAccount();
				$CapitalAccount->account_no = $request->receive_from_account;
				$CapitalAccount->description = $request->note;
				$CapitalAccount->transection_date = $date;
				$CapitalAccount->debit = $request->amount;
				$CapitalAccount->created_by = Auth::user()->id;
				$CapitalAccount->status = 1;
				$CapitalAccount->save();

			}

			DB::commit();
			return redirect()->back();
		} catch (Exception $e) {
			DB::rollback();
			//return $e->getMessage();
			return redirect('transection-paid');

		}
	}
	public function transectionReceived() {
		$accounts = DB::table('cash_profiles')
				->orderBy('id', 'ASC')->get();
		return view('transection.receive',compact('accounts'));
	}
	public function transectionPaid() {
		$accounts = DB::table('cash_profiles')
				->orderBy('id', 'ASC')->get();
		return view('transection.paid',compact('accounts'));
	}

	public function receiveAccount(Request $request) {
		//return $request->all();
		if ($request->actype_receive == 'cash') {
			$accounts = DB::table('cash_profiles')
				->orderBy('id', 'ASC')->get();
			$accounts = view('transection.cash_account', compact('accounts'));
			return $accounts;
		} elseif ($request->actype_receive == 'bank') {
			//$request->bank_account = floatval($request->bank_account);
			if ($request->bank_account != '') {
				$banksAccounts = DB::table('bank_account_profiles')->where('bank_account', '!=', $request->bank_account)->get();
			} else {
				$banksAccounts = DB::table('bank_account_profiles')->get();
			}
			if (count($banksAccounts) > 0) {
				$responseHtml = view('transection.bank_account', compact('banksAccounts'));
			} else {
				$responseHtml = "<option value=''>No Bank Account Available</option>";
			}

		} elseif ($request->actype_receive == 'mobile_bank') {
			if ($request->mobile_bank != '') {
				$banksAccounts = DB::table('mobile_bank_accounts_profiles')->where('bank_account', '!=', $request->mobile_bank)
					->orderBy('id', 'ASC')->get();
			} else {
				$banksAccounts = DB::table('mobile_bank_accounts_profiles')
					->orderBy('id', 'ASC')->get();
			}
			if (count($banksAccounts) > 0) {
				$responseHtml = view('transection.mobile_bank_account', compact('banksAccounts'));
			} else {
				$responseHtml = "<option value=''>No Mobile Account Available</option>";
			}

		} elseif ($request->actype_receive == 'account_receivable') {
			$account_receivables = DB::table('customer_profiles')->where('id', '!=', 0)->get();
			if (count($account_receivables) > 0) {
				$responseHtml = view('transection.account_receiveable', compact('account_receivables'));
			} else {
				$responseHtml = "<option value=''>No Customer Account Available</option>";
			}

		} elseif ($request->actype_receive == 'account_payable') {
			$account_payables = DB::table('supplier_profiles')->where('id', '!=', 0)->get();
			if (count($account_payables) > 0) {
				$responseHtml = view('transection.account_payable', compact('account_payables'));
			} else {
				$responseHtml = "<option value=''>No Supplier Account Available</option>";
			}

		} elseif ($request->actype_receive == 'loan_receive_account') {
			$loan_receive_account = DB::table('advance_received_person_profiles')->get();
			if (count($loan_receive_account) > 0) {
				$responseHtml = view('transection.loan', compact('loan_receive_account'));
			} else {
				$responseHtml = "<option value=''>No  Account Available</option>";
			}

		} elseif ($request->actype_receive == 'investment_account') {
			$investment_account = DB::table('advance_paid_person_profiles')->get();
			if (count($investment_account) > 0) {
				$responseHtml = view('transection.investment', compact('investment_account'));
			} else {
				$responseHtml = "<option value=''>No  Account Available</option>";
			}

		} elseif ($request->actype_receive == 'expenses') {
			$expenses = DB::table('expense_profiles')->get();
			if (count($expenses) > 0) {
				$responseHtml = view('transection.expense', compact('expenses'));
			} else {
				$responseHtml = "<option value=''>No  Account Available</option>";
			}

		} elseif ($request->actype_receive == 'capital') {
			$owners = DB::table('owner_profiles')->get();
			if (count($owners) > 0) {
				$responseHtml = view('transection.owner', compact('owners'));
			} else {
				$responseHtml = "<option value=''>No  Account Available</option>";
			}

		}

		return $responseHtml;
	}

	//ajax call function for account type wise account
	public function findReferanceAccount(Request $request) {
		//return $request->all();
		if ($request->actype == 'bank') {
			$banksAccounts = DB::table('bank_account_profiles')
				->orderBy('id', 'ASC')->get();
			$bankView = view('transection.bank_account', compact('banksAccounts'));
			return $bankView;
		} elseif ($request->actype == 'mobile_bank') {
			$banksAccounts = DB::table('mobile_bank_accounts_profiles')
				->orderBy('id', 'ASC')->get();
			$bankView = view('transection.mobile_bank_account', compact('banksAccounts'));
			return $bankView;
		}elseif($request->actype =='cash'){
			$accounts = DB::table('cash_profiles')
				->orderBy('id', 'ASC')->get();
			$accounts = view('transection.cash_account', compact('accounts'));
			return $accounts;
		}


	}


}
