<?php

namespace App\Http\Controllers;
//use App\CashBook;
use App\SupplierProfile;
use Carbon\Carbon;
use App\AccountLevelTwo;
use App\AccountDetail;
use DB;
use Illuminate\Http\Request;

class SupplierProfileController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index(Request $request) {

		$account_heads = AccountLevelTwo::where('status',1)
					->where('id',40)
					->orderBy('code','ASC')->get();

		$limit = $request->limit ?? 20;
		$ad_name = $request->ad_name ?? '';
		$phone = $request->phone ?? '';
		$ad_address = $request->ad_address ?? '';
		$ad_al2_id = $request->ad_al2_id ?? '';
		if($request->has('limit')){
			if($request->limit == "All"){
				$limit = "All";
				
			}
		}
		
		$info = AccountDetail::where('status',1)->where('ad_al2_id',40);
		if($ad_name !="" ){
			$info = $info->where('ad_name', 'LIKE', "%{$ad_name}%");
		}
		if($phone !="" ){
			$info = $info->where('phone', 'LIKE', "%{$phone}%");
		}
		if($ad_address !="" ){
			$info = $info->where('ad_address', 'LIKE', "%{$ad_address}%");
		}
		if($ad_al2_id !="" ){
			$info = $info->where('ad_al2_id', $ad_al2_id);
		}
		if($limit !='' && $limit !="All"){
			$info = $info->take($limit);
		}
		$info = $info->with(['account_sub_category'])->orderBy('name','asc')->get();
		//return $request;
		return view('account-details.index',compact('info','account_heads','request'));
		// $library = new \App\Library\Library;
		// if ($library->check_user_access('supplier_view')) {
		// 	$crud = new \App\Library\Crud;
		// 	$supplier_category = $crud->Getvalue('SupplierCategory');
		// 	$TransactionTerm = $crud->Getvalue('TransactionTerm');
		// 	$info = SupplierProfile::with('SupplierCategory')->with('TransactionTerm')->with('SupplierAccount')->orderBy('id', 'DESC')->get();
		// 	return view('supplier.index', compact('info', 'supplier_category', 'TransactionTerm'));
		// } else {
		// 	return "Sorry you don't have access to this action";
		// }

	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_view')) {
			$request->validate([
				'name' => 'required',
				'phone' => 'required',
				'transection_term_id' => 'required',
				'category_id' => 'required',
			]);
			$date = Carbon::today();
			/*Data insert to Supplier Profile table*/
			$crud = new \App\Library\Crud;
			$crud_result = $crud->InsertValue('SupplierProfile', $request->all());
			if ($crud_result) {
				$library = new \App\Library\Library;
				$collection = $library->add_element($request->all(), ['account_no' => $crud_result, 'transection_no' => 'opening', 'transection_date' => $date]);
				$crud->InsertValue('SupplierAccount', $collection);
				/*if ($request->debit != 0) {
					$CashBook = new CashBook();
					$CashBook->account_no = $request->account_no;
					$CashBook->credit = $request->debit;
					$CashBook->save();
				*/

				if ($request->action != 'modal') {
					$info = SupplierProfile::with('SupplierCategory')->with('TransactionTerm')->orderBy('id', 'DESC')->get();
					return view('supplier.table', compact('info'));
				} else {
					return 1;
				}
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_edit')) {
			$crud = new \App\Library\Crud;
			$supplier_category = $crud->Getvalue('SupplierCategory');
			$TransactionTerm = $crud->Getvalue('TransactionTerm');
			$info = $crud->GetValueWhereSingle('SupplierProfile', ['id', $id]);
			return view('supplier.edit', compact('info', 'CustomerAccounts', 'supplier_category', 'TransactionTerm'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_edit')) {
			$request->validate([
				'name' => 'required',
				'phone' => 'required',
				'transection_term_id' => 'required',
				'category_id' => 'required',
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'SupplierProfile', ['id', $request->id]);
			return redirect('supplier')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('SupplierProfile', ['id', $id]);
			return redirect('supplier')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function SupplierHistory(Request $request) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('supplier_view')) {
			if ($request->start_date != null && $request->end_date != null && $request->add_supplier != null) {
				//dump($request->all());
				$start_strtotime = strtotime($request->start_date);
				$end_strtotime = strtotime($request->end_date);
				$start_date = date('Y-m-d', $start_strtotime);
				$end_date = date('Y-m-d', $end_strtotime);

				//$account_no = $request->account_no;
				$accountInfo = explode("<>", $request->add_supplier);
				$account_no = $accountInfo[0];

				// $dateBeforeBalance = SupplierAccount::selectRaw('account_no,transection_no,debit,credit,description,created_at')->where('account_no', $account_no)->where('created_at', '<', $start_date)->get();

				$setquery = DB::statement("SET@csum=0 ");
				$query = '
SELECT a.account_no, a.t_date, a.descriptions, a.debit, a.credit, (@csum:=@csum+a.balance) as cummulative
FROM (
    SELECT a.account_no, "' . $start_date . '" - INTERVAL 1 DAY AS t_date, "B/F" AS descriptions, Sum(a.debit) AS debit, Sum(a.credit) AS credit, Sum(IFNULL(a.credit,0)-IFNULL(a.debit,0)) AS balance
    FROM supplier_accounts a
    WHERE a.transection_date < "' . $start_date . '" AND a.account_no="' . $account_no . '"
    GROUP BY a.account_no
    UNION
    SELECT a.account_no, date(a.transection_date) As t_date, a.description, a.debit, a.credit, (IFNULL(a.credit,0)- IFNULL(a.debit,0)) AS balance
    FROM supplier_accounts a
    WHERE date(a.transection_date) >="' . $start_date . '" AND date(a.transection_date)<="' . $end_date . '" AND a.account_no="' . $account_no . '") AS a
	ORDER BY a.t_date';
				$SupplierHistory = DB::select($query);
				$crud = new \App\Library\Crud;
				$info = $crud->GetValueWhereSingle('SupplierProfile', ['id', $account_no]);

				// echo "<pre>";
				// print_r($customerHistory);
				// die();
				//return redirect('customer-history')->with($customerHistory);
				return view('supplier-report.supplier_history', compact('SupplierHistory', 'info'));
			} else {
				return view('supplier-report.supplier_history');
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function supplierAgeing() {
		$query = "SELECT a.`account_no`, p.name,p.address,p.phone, SUM(a.`debit`) as totalDebit,SUM(a.`credit`) as totalCredit ,( SUM(a.`credit`)-SUM(a.`debit`)) as balance  FROM `supplier_accounts` as a
JOIN supplier_profiles as p ON a.`account_no`=p.id GROUP BY a.account_no  HAVING  totalCredit >totalDebit
ORDER BY `a`.`account_no` ASC";
		$info = DB::select($query);
		return view('supplier-report.supplier_ageing', compact('info'));
	}
}
