<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

class SupplierCategoryController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_view')) {
			$crud = new \App\Library\Crud;
			$info = $crud->Getvalue('SupplierCategory');
			return view('supplier-category.index', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_add')) {
			$crud = new \App\Library\Crud;
			if ($request->action == 'modal') {

				$crud_result = $crud->InsertValue('SupplierCategory', $request->all(), true);
				return $crud_result;
			} else {

				$request->validate([
					'name' => 'required|unique:supplier_categories',
				]);
				$crud = new \App\Library\Crud;
				$crud->InsertValue('SupplierCategory', $request->all());
				$info = $crud->Getvalue('SupplierCategory');
				return view('supplier-category.table', compact('info'));
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_edit')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('SupplierCategory', ['id', $id]);
			return view('supplier-category.edit', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_edit')) {
			$request->validate([
				'name' => 'required|unique:supplier_categories,id,' . $request->id,
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'SupplierCategory', ['id', $request->id]);
			return redirect('supplier-category')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('supplier_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('SupplierCategory', ['id', $id]);
			return redirect('supplier-category')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}
