<?php

namespace App\Http\Controllers;
use App\StoreHouseLocation;
use Illuminate\Http\Request;

class StoreHouseLocationController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_view')) {
			$crud = new \App\Library\Crud;
			$storehouse = new \App\StoreHouseLocation();
			$info = $storehouse->GetallStoreHouseLocation();
			$employee = $crud->GetValueWhereStatus('User', ['status', '!=', 0]);
			return view('store-house-location.index', compact('info', 'employee'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_add')) {
			return view('store-house-location.create');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_add')) {
			$request->validate([
				'name' => 'required|unique:store_house_locations',
				'employee_id' => 'required',
			]);
			$crud = new \App\Library\Crud;
			$crud->InsertValue('StoreHouseLocation', $request->all());
			$storehouse = new \App\StoreHouseLocation();
			$info = $storehouse->GetallStoreHouseLocation();
			return view('store-house-location.table', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_edit')) {
			$crud = new \App\Library\Crud;
			$employee = $crud->GetValueWhereStatus('User', ['status', '!=', 0]);
			$info = $crud->GetValueWhereSingle('StoreHouseLocation', ['id', $id]);
			return view('store-house-location.edit', compact('employee', 'info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_edit')) {
			$request->validate([
				'employee_id' => 'required',
				'name' => 'required|unique:store_house_locations,name,' . $request->id,
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'StoreHouseLocation', ['id', $request->id]);
			return redirect('store-house-location')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('StoreHouseLocation', ['id', $id]);
			return redirect('store-house-location')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}