<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ShopController extends Controller {
	public function index() {

		$library = new \App\Library\Library;
		if ($library->check_user_access('shop_edit')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('Shop', ['id', '1']);
			return view('shop.index', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function update(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('shop_edit')) {

			$request->validate([
				'shop_name' => 'required',
				'shop_email' => 'required',
				'shop_phone' => 'required',
				'shop_address' => 'required',
				'invoice_layout' => 'required',

			]);
			$crud = new \App\Library\Crud;
			$fetchinfo = $crud->GetValueWhereSingle('Shop', ['id', $request->id]);
			if ($library->is_file($request)) {
				$uniqueImage = $library->unique_image($request, 'shop_logo');
				if ($fetchinfo->image != null) {
					$library->unlink_file('shop_logo', $fetchinfo->image);

				}

			} else {
				$uniqueImage = $fetchinfo->image ?? null;
			}
			$collection = $library->remove_element($request, ['image']);
			$collection = $library->add_element($collection, ['image' => $uniqueImage]);
			$crud->UpdateValeWhereSingle($collection, 'Shop', ['id', $request->id]);
			return redirect('shop')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}
