<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

class ShipperProfileController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('shipper_edit')) {
			$crud = new \App\Library\Crud;
			$info = $crud->Getvalue('ShipperProfile');
			return view('shipper-profile.index', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('shipper_add')) {
			$request->validate([
				'name' => 'required',
				'email' => 'required|unique:shipper_profiles',
				'phone' => 'required',
				'address' => 'required',

			]);
			$crud = new \App\Library\Crud;
			$crud->InsertValue('ShipperProfile', $request->all());
			$info = $crud->Getvalue('ShipperProfile');
			return view('shipper-profile.table', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('shipper_add')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('ShipperProfile', ['id', $id]);
			return view('shipper-profile.edit', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('shipper_edit')) {
			$request->validate([
				'name' => 'required',
				'email' => 'required|unique:shipper_profiles,email,' . $request->id,
				'phone' => 'required',
				'address' => 'required',
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'ShipperProfile', ['id', $request->id]);
			$info = $crud->Getvalue('ShipperProfile');
			return redirect('shipper-profile')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('shipper_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('ShipperProfile', ['id', $id]);
			return redirect('shipper-profile')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}
