<?php

namespace App\Http\Controllers;
use App\Inventory;
use App\ProductPriceList;
use App\SalesDetails;
use App\SalesOrder;
use App\SalesRetrunOrder;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Session;
use App\SettingOption;
use App\AccountLedger;

class SalesReportController extends Controller {

	//park sales invoice report
	public function preorder_invoice() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {

			$info = DB::table('sales_orders')->where('order_type', 'park_sales')->get();
			$user = DB::table('users')->get();
			$customer_profiles = DB::table('customer_profiles')->get();
			return view('sales-report.pre_order_invoice', compact('info', 'customer_profiles', 'user'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function delete_park_sales(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_delete')) {
			$updateSalesOrder = DB::table('sales_orders')->where('id', $id)
				->update(['order_type' => 'preOCan', 'pre_order_status' => 2]);
			//pre order status  2 main cancaled order

			//update product price list table
			$preOrderItems = DB::table('sales_details')->where('order_id', $id)->get();
			if (!empty($preOrderItems)) {
				foreach ($preOrderItems as $key => $value) {
					$updateProductPriceList = ProductPriceList::where('order_id', $value->lot_no)->where('product_id', $value->product_id)->where('barcode', $value->unique_barcode)->first();
					if (!empty($updateProductPriceList)) {
						$currentQty = $updateProductPriceList->qty + $value->qty;
						$updateProductPriceList->qty = $currentQty;
						$updateProductPriceList->status = 1;
						$updateProductPriceList->save();
					}

					//update inventory table
					$inventoryUpdate = \App\Inventory::where('product_id', $value->product_id)->first();
					if (!empty($inventoryUpdate)) {
						$newAllocated = $inventoryUpdate->allocated - $value->qty;
						$newAvailable = $inventoryUpdate->available + $value->qty;
						$newon_hand = $inventoryUpdate->on_order - $value->qty;
						$inventoryUpdate->allocated = $newAllocated;
						$inventoryUpdate->on_order = $newon_hand;
						$inventoryUpdate->available = $newAvailable;
						$inventoryUpdate->save();
					}

				}
			}
			Session::flash('message', 'Preorder sale has been deleted !');

			return redirect()->back();
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function park_invoice_details(Request $request, $id) {

	}

	public function SalesReturnList(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$start_strtotime = strtotime("$start_date 00:00:00");
			$end_strtotime = strtotime("$end_date 23:59:59");
			$start_time = date('Y-m-d H:i:s', $start_strtotime);
			$end_time = date('Y-m-d H:i:s', $end_strtotime);

			$info = SalesRetrunOrder::whereBetween('created_at', [$start_time, $end_time])->with('Customer')->orderBy('id', 'DESC')->get();
			return view('sales.returnInvoiceList', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function GetSalesOrderReport(Request $request) {

		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {

			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$start_strtotime = strtotime("$start_date 00:00:00");
			$end_strtotime = strtotime("$end_date 23:59:59");
			$start_time = date('Y-m-d H:i:s', $start_strtotime);
			$end_time = date('Y-m-d H:i:s', $end_strtotime);

			 $info = SalesOrder::with(['account_details'])
			->whereBetween('sales_orders.created_at', [$start_time, $end_time])->orderBy('sales_orders.created_at', 'DESC')->get();

		 	

			// $saleWithReturn = DB::table('sales_orders')
			// 	->select('sales_orders.id as order_number', 'sales_orders.payment_amount as payment_amount', 'sales_orders.receive_amount_from_custome as receive_amount_from_custome', 'sales_orders.receive_amount_from_custome as receive_amount_from_custome', 'sales_orders.due_amount as due_amount', 'sales_orders.created_at as created_at', 'customer_profiles.name as customerName', 'customer_profiles.phone as phone', 'sales_retrun_orders.return_return_amount as return_return_amount', 'sales_retrun_orders.return_amount_paid_customer as return_amount_paid_customer')
			// 	->join('customer_profiles', 'customer_profiles.id', '=', 'sales_orders.customer_Id')
			// 	->join('sales_retrun_orders', 'sales_retrun_orders.return_return_ref', '=', 'sales_orders.id')->whereBetween('sales_orders.created_at', [$start_time, $end_time])->orderBy('sales_orders.id', 'DESC')->get();
			//dump($saleWithReturn);die();
				$saleWithReturn =[];

			return view('sales.sales_invoice_report', compact('info', 'request', 'saleWithReturn'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function salesReportIndivisual(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			  $info = SalesOrder::with(['Sales','account_details'])->find($id);
			 $returnItem = [];
			 $ledger_id = $info->customer_Id;
			  $balance = DB::select(" SELECT SUM(lg_dr_amt) AS debit,SUM(lg_cr_amt) AS credit  FROM account_ledgers AS t1 WHERE lg_ad_id=$ledger_id ");

			return view('sales.sales_invoice', compact('info', 'returnItem','balance'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function salesDetails($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			$sales_order = new \App\SalesOrder();
			$info = $sales_order->GetSalesOrder($id);

			//$returnItem = DB::table('sales_retrun_orders')->where('return_return_ref', $id)->first();

			return view('sales.sales_invoice', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	//sales return invoice print view dispaly function
	public function returnInvoiceDetails($id, $ref = null) {
		if ($ref != null) {
			$returnItem = DB::table('sales_retrun_orders')->where('id', $id)->first();
			$id = $returnItem->return_return_ref;
		} else {
			$id = $id;
		}
//return $id;
		$SalesRetrunOrder = new SalesRetrunOrder();
		  $info = $SalesRetrunOrder->GetReturnSalesDetails($id);
		 $return_return_ref= $info->return_return_ref ?? '';
		$returnItem = SalesDetails::with('product')->where('order_id', $return_return_ref)->where('status', 0)->get();
		 $ledger_id = $info->return_customer_Id;
		$balance = DB::select(" SELECT SUM(lg_dr_amt) AS debit,SUM(lg_cr_amt) AS credit  FROM account_ledgers AS t1 WHERE lg_ad_id=$ledger_id ");

		return view('sales.return_invoice', compact('info', 'returnItem','balance'));

	}

	public function due_sales_invoice() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {

			$info = DB::table('sales_orders')->whereRaw(' sales_orders.gross_amount >  sales_orders.receive_amount_from_custome')->get();

			return view('sales.due_invoice', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function cashsalesReport(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$sales_order = new \App\SalesOrder();
			$info = $sales_order->GetCashSalesOrderAll($start_date, $end_date);
			return view('sales.cash_sales_report', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function CreditInvoiceReport(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$sales_order = new \App\SalesOrder();
			$info = $sales_order->GetCreditInvoiceAll($start_date, $end_date);
			return view('sales.credit_sales_invoice_report', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function Tprofit(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$sales = new \App\SalesAccounts();
			$gsales = $sales->Totalsales($start_date, $end_date);
			if (count($gsales) > 0) {
				$tsales = ($gsales[0]['Totalcredit'] - $gsales[0]['TotalDebit']);
			} else {
				$tsales = 0;
			}
			$cgs = new \App\CostofGoodsSoldAccounts();
			$gcgs = $cgs->Tcgs($start_date, $end_date);
			if (count($gsales) > 0) {
				$tcgs = ($gcgs[0]['TotalDebit'] - $gcgs[0]['Totalcredit']);
			} else {
				$tcgs = 0;
			}

			return view('report.sales_profit', compact('tsales', 'tcgs', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function CreditSalesReport(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$sales_order = new \App\SalesOrder();
			$info = $sales_order->CreditSalesReport($start_date, $end_date);
			return view('sales.credit_sales_report', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	Public function UserwiseTsales(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}
			$sales_order = new \App\SalesOrder();
			$info = $sales_order->Userwisesales($start_date, $end_date);
			return view('sales.Userwisesales', compact('info', 'request', 'start_date', 'end_date'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function UserwisedIndivisualsales(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}
			$sales_order = new \App\SalesOrder();
			$info = $sales_order->Userwisesales($start_date, $end_date);
			return view('sales.Userwisesales', compact('info', 'request', 'start_date', 'end_date'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
}
