<?php

namespace App\Http\Controllers;

use App\SalesPrices;
use DB;
use Illuminate\Http\Request;

class SalesPriceController extends Controller {
	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			$info = SalesPrices::with('ProductProfile')->get();
			return view('price.index', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function search_unset_price(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			$searchItem = $request->dataPass;
			$search_result = DB::table('product_profiles')
				->join('sales_prices', 'sales_prices.product_id', '=', 'product_profiles.id')
				->where('sales_prices.price', 0)
				->get();

			echo json_encode($search_result);
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			/*$request->validate([
					'product_id' => 'required|unique:sales_prices',
					'price' => 'required',
					'unique_price' => 'required',
				]);

				$SalesPrices = new SalesPrices();
				$SalesPrices->product_id = $request->product_id;
				$SalesPrices->price = $request->price;
				$SalesPrices->unique_price = $request->unique_price;
			*/
			DB::table('sales_prices')
				->where('product_id', $request->product_id)
				->update(['price' => $request->price, 'unique_price' => $request->unique_price]);

			if ($request->unique_price == 1) {
				DB::table('product_price_lists')
					->where('product_id', $request->product_id)
					->update(['sales_price' => $request->price]);

			}

			return redirect('sales-price');
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_edit')) {

			$info = DB::table('product_profiles')
				->join('sales_prices', 'sales_prices.product_id', '=', 'product_profiles.id')
				->where('product_profiles.id', $id)
				->first();

			/*$SalesPrices = new SalesPrices();
		$info = SalesPrices::where('product_id', $id)->first();*/
			return view('price.edit', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_edit')) {

			$request->validate([
				'product_id' => 'required',
				'price' => 'required',
				'unique_price' => 'required',
			]);

			DB::table('sales_prices')
				->where('product_id', $request->product_id)
				->update(['price' => $request->price, 'unique_price' => $request->unique_price]);
			if ($request->unique_price == 1) {
				DB::table('product_price_lists')
					->where('product_id', $request->product_id)
					->update(['sales_price' => $request->price]);

			}

			return redirect('sales-price');
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('SalesPrices', ['product_id', $id]);
			return redirect('sales-price')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}
