<?php

namespace App\Http\Controllers;
use App\CashBook;
use App\CostofGoodsSoldAccounts;
use App\CustomerAccounts;
use App\CustomerProfile;
use App\Inventory;
use App\ProductPriceList;
use App\SalesAccounts;
use App\SalesDetails;
use App\SalesDiscountAccount;
use App\SalesOrder;
use App\sales_temtable;
use App\VatAccounts;
use Auth;
use DateTime;
use DateTimezone;
use DB;
use Illuminate\Http\Request;
use Session;
use App\SettingOption;
use App\AccountVoucherMaster;
use App\AccountLedger;
use App\AccountDetail;

class SalesController extends Controller {

	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			$crud = new \App\Library\Crud;
			$CustomerAccounts = [];
			$customer_category = [];
			$payments = [];
			//return dump($customer_category);
			$pre_order_no = SalesOrder::select('order_id')->where('order_type', '=', 'preorder')->orderBy('id', 'DESC')->first();
			$customers = [];

			 $available_items = DB::select(" SELECT t1.product_id AS id, t1.name, SUM(t1.qty) AS available  FROM  product_price_lists AS t1
GROUP BY t1.product_id ORDER BY 2 ASC LIMIT 20 ");
			$products = DB::table('product_profiles')
				->join('inventories', 'inventories.product_id', '=', 'product_profiles.id')
				->select('product_profiles.id', 'product_profiles.name')
				->orderBy('allocated', 'DESC')
				->limit(20)
				->get();
			$sales_temtable = sales_temtable::where('employee_id', Auth::user()->id)->get();
			$reprint_no = SalesOrder::where('employee_id', Auth::user()->id)->where('return_ref', '=', null)->orderBy('id', 'DESC')->first();

			//dump($products);exit();
			return view('sales.index', compact('customers', 'payments', 'pre_order_no', 'sales_temtable', 'available_items', 'customer_category', 'CustomerAccounts', 'reprint_no'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	//available prodcut show in sales view page
	public function availableProduct(Request $request) {

		$available_items = DB::table('inventories')
			->join('product_profiles', 'inventories.product_id', 'product_profiles.id')
			->where('available', '>', 0)->orderBy('allocated', 'DES')->limit(20)->get();

		$serachItem = view('sales.search_item', compact('available_items'));

		return $serachItem;
	}
	//Customer search for sales
	public function customer_for_sales(Request $request) {

		$customers = DB::table('account_details')->select('id','name')->where('name', 'LIKE', "%$request->search_text%")->whereIn('ad_al2_id',[1,40])->take(10)->get();
		
		
		

		return json_encode($customers);
	}

	public function search(Request $request) {
		//return $request->all();
		$search_result = DB::table('product_price_lists')
			->join('inventories', 'inventories.product_id', '=', 'product_price_lists.product_id')
			->where('inventories.available', '>', 0)
			->where('product_price_lists.status', 1);
		if($request->has('search_text')){
			if($request->search_text !=''){
				$search_result=	$search_result->where('product_price_lists.name', 'like', '%' . $request->search_text . '%')
				->orWhere('product_price_lists.id', 'like', '%' . $request->search_text . '%');
			}
		}

		$search_result=	$search_result->groupBy('product_price_lists.product_id')
			->get();
		echo json_encode($search_result);
	}

	public function fetch_product(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			DB::beginTransaction();
			try {
				$price_info_array = array();
				$product_pricelist_id = array();
				$available_product = Inventory::where('product_id', $request->id)->first();
				if (!empty($available_product)) {
					$request->quantity = floatval($request->quantity);
					$available_product->available = floatval($available_product->available);
					if ($available_product->available >= $request->quantity) {

						$price_info = ProductPriceList::where('product_id', $request->id)->where('status', 1)->where('qty', '>', 0)->orderBy('order_id', 'ASC')->first();

						//update Inventory table when add product in sales form
						$Inventory = new Inventory();
						$previous_allocated = Inventory::where('product_id', '=', $request->id)->first();
						if (!empty($previous_allocated)) {
							//$allocate_adjustment = $previous_allocated->allocated + $request->quantity;
							$available_adjustment = $previous_allocated->available - $request->quantity;
							//$previous_allocated->allocated = $allocate_adjustment;
							$previous_allocated->available = $available_adjustment;
							$previous_allocated->save();
						} else {
							return "not found";
						}

						array_push($price_info_array, $price_info);
						$available_quantity = $price_info->qty;
						do {
							array_push($product_pricelist_id, $price_info->id);
							if ($available_quantity < $request->quantity) {
								$price_info_two = ProductPriceList::where('product_id', $request->id)->whereNotIn('id', $product_pricelist_id)->where('status', 1)->where('qty', '>', 0)->orderBy('order_id', 'ASC')->first();
								array_push($price_info_array, $price_info_two);
								array_push($product_pricelist_id, $price_info_two->id);
								$available_quantity = $available_quantity + $price_info_two->qty;
							}
						} while ($available_quantity < $request->quantity);

					} else {
						$restOfProduct = Inventory::where('product_id', $request->id)->first();
						return json_encode(['no', $restOfProduct->available]);
					}
				}
				if (count($price_info_array) > 0) {
					$quantity_per_row = 0;
					$quantity_per_row_check = 0;
					for ($i = 0; $i < count($price_info_array); $i++) {

						$quantity_per_row = $quantity_per_row + $price_info_array[$i]->qty;
						if ($quantity_per_row <= $request->quantity) {
							$applicable_quantity = $price_info_array[$i]->qty;

						} else {
							$applicable_quantity = ($request->quantity + $price_info_array[$i]->qty) - $quantity_per_row;

						}
						$id = $price_info_array[$i]->id;
						$pricelist = ProductPriceList::where('id', $id)->first();
						if (!empty($pricelist)) {
							if ($applicable_quantity == $pricelist->qty) {
								$pricelist->qty = 0;
								$pricelist->status = 0;
							} else {
								$pricelist->qty = (float) ($pricelist->qty - $applicable_quantity);
							}
							$pricelist->save();

							//product save into sales tem table
							$sales_temtable = new sales_temtable();
							$sales_temtable->order_id = $price_info_array[$i]->order_id;
							$sales_temtable->product_id = $price_info->product_id;
							$sales_temtable->barcode = $price_info_array[$i]->barcode;
							$sales_temtable->name = $price_info->name;
							$sales_temtable->qty = $applicable_quantity;
							$sales_temtable->cost_price = $price_info->cost_price;
							$sales_temtable->sales_price = $price_info_array[$i]->sales_price;
							$sales_temtable->vat_rate = $price_info_array[$i]->vat_rate;
							$sales_temtable->discount_rate = $price_info_array[$i]->discount_rate;
							$sales_temtable->employee_id = Auth::user()->id;
							$sales_temtable->save();

						}

					}
				}
				DB::commit();
				return json_encode($price_info_array);

			} catch (Exception $e) {
				DB::rollBack();
				echo 'Caught exception: ', $e->getMessage(), "\n";
			}

		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function update_inventory(Request $request) {

		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_edit')) {
			DB::beginTransaction();
			try {

				$product_id = $request->product_id;
				$quantity = floatval($request->quantity);
				$order_id = $request->order_id;
				$id = $request->id;
				$barcode = $request->barcode;

				//update Inventory table when add product in sales form
				$Inventory = new Inventory();
				$previous_allocated = Inventory::where('product_id', '=', $product_id)->first();
				if (!empty($previous_allocated)) {
					//$allocate_adjustment = $previous_allocated->allocated - $quantity;
					$previous_allocated->available = floatval($previous_allocated->available);
					$available_adjustment = $previous_allocated->available + $quantity;
					//$previous_allocated->allocated = $allocate_adjustment;
					$previous_allocated->available = $available_adjustment;
					$previous_allocated->save();
				}

				$ProductPriceList = ProductPriceList::where('product_id', $product_id)->where('id', $id)->where('order_id', '=', $order_id)->where('barcode', $barcode)->first();
				if (!empty($ProductPriceList)) {
					$applicable_quantity = $ProductPriceList->qty + $quantity;
					$ProductPriceList->qty = $applicable_quantity;
					$ProductPriceList->status = 1;
					$ProductPriceList->save();
				}

				$sales_temtable = new sales_temtable();
				$sales_temtable = sales_temtable::where('order_id', $order_id)->where('product_id', $product_id)->where('qty', $quantity)->where('barcode', $barcode)->where('employee_id', Auth::user()->id)->delete();
				DB::commit();

			} catch (Exception $e) {
				DB::rollBack();
				echo 'Caught exception: ', $e->getMessage(), "\n";
			}

		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function fetch_product_with_barcode(Request $request) {
		$price_info = ProductPriceList::where('status', 1);
		$price_info = $price_info->where('barcode', $request->barcode);
		$price_info = $price_info->where('qty', '>', 0)->orderBy('order_id', 'ASC')->first();
		//update Inventory table when add product in sales form
		if (!empty($price_info)) {
			//$Inventory = new Inventory();
			$previous_allocated = Inventory::where('product_id', '=', $price_info->product_id)->first();
			if (!empty($previous_allocated)) {
				$available_adjustment = $previous_allocated->available - $price_info->qty;
				$previous_allocated->available = $available_adjustment;
				$previous_allocated->save();
			}

			$ProductPriceList = ProductPriceList::where('barcode', $request->barcode)->first();
			if (!empty($ProductPriceList)) {
				$applicable_quantity = $ProductPriceList->qty - $ProductPriceList->qty;
				$ProductPriceList->qty = $applicable_quantity;
				$ProductPriceList->status = 0;
				$ProductPriceList->save();
				//product save into sales tem table
				$sales_temtable = new sales_temtable();
				$sales_temtable->order_id = $price_info->order_id;
				$sales_temtable->product_id = $price_info->product_id;
				$sales_temtable->barcode = $price_info->barcode;
				$sales_temtable->name = $price_info->name;
				$sales_temtable->qty = $price_info->qty;
				$sales_temtable->cost_price = $price_info->cost_price;
				$sales_temtable->sales_price = $price_info->sales_price;
				$sales_temtable->vat_rate = $price_info->vat_rate;
				$sales_temtable->discount_rate = $price_info->discount_rate;
				$sales_temtable->employee_id = Auth::user()->id;
				$sales_temtable->save();
			}
		}
		return json_encode($price_info);
	}

	public function sales_process(Request $request) {

		//return $request->all();

		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			DB::beginTransaction();
			try {
				$options = SettingOption::first();
				$receive_amount_from_custome = floatval($request->receive_amount_from_custome);
				$receive_amount_from_custome = floatval($receive_amount_from_custome);
				if ($receive_amount_from_custome == '' && $receive_amount_from_custome == null) {
					$receive_amount_from_custome = 0;
				}
				$request->all();
				if ($request->gross_total == null && $request->gross_total == '') {

					return redirect('sales');
				}
				if ($request->customer_id == null) {
					$customer = $options->s_default_customer ?? 8;
					$payment_type = 1;
				} else {
					$customer = $request->customer_id;
					$payment_type = 2;
				}
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));

				$date = $request->transection_date ??  $dt->format('Y-m-d H:i:s');
				//Sales data insert to sales Order table
				$request->net_total = floatval($request->net_total);
				if ($request->net_total < $receive_amount_from_custome) {
					$initial_received = $request->net_total;
					$initial_received = floatval($initial_received);
				} else {
					$initial_received = $receive_amount_from_custome;
					$initial_received = floatval($initial_received);
				}
				$salesAmount = $request->net_total;
				$salesAmount = floatval($salesAmount);
				$receiveAmount = $receive_amount_from_custome;
				$receiveAmount = floatval($receiveAmount);
				//$unpaidAmount = $salesAmount - $receiveAmount;
				$dueAmount = $request->due_amount ?? 0;
				$dueAmount = floatval($dueAmount);

				// if ($dueAmount > 0) {

				// 	$quuery = "SELECT SUM((IFNULL(credit,0)-IFNULL(debit,0))) as customer_balance FROM customer_accounts WHERE account_no=" . $customer . "";
				// 	$checkAmount = DB::select($quuery);

				// 	if (!empty($checkAmount)) {

				// 		$balance = $checkAmount[0]->customer_balance;
				// 		$balance = floatval($balance);
				// 		if ($balance > 0) {
				// 			if ($balance > $dueAmount) {
				// 				$receiveAmount = $receiveAmount + $dueAmount;
				// 				$dueAmount = $salesAmount - $receiveAmount;
				// 			} elseif ($balance < $dueAmount) {
				// 				$receiveAmount = $receiveAmount + $balance;
				// 				$dueAmount = $salesAmount - $receiveAmount;
				// 			}
				// 		}

				// 	}
				// }

				$crud = new \App\Library\Crud;
				$collection = $library->remove_element($request, ['order_id', 'customer_Id', 'employee_id', 'order_type', 'pre_order_status', 'gross_total', 'discount_total', 'vat_total', 'receive_amount_from_custome', 'due_amount']);
				$collection = $library->add_element($collection, ['order_id' => md5($date), 'customer_Id' => $customer, 'employee_id' => Auth::user()->id, 'order_type' => 'sales', 'pre_order_status' => 0, 'order_date' => $date, 'gross_amount' => $request->gross_total, 'gross_discount' => $request->discount_total, 'gross_vat_amount' => $request->vat_total, 'payment_amount' => $request->net_total, 'transection_type' => $payment_type, 'initial_received' => $initial_received, 'receive_amount_from_custome' => $receiveAmount, 'due_amount' => $dueAmount]);
				
				$crud_result = $crud->InsertValue('SalesOrder', $collection);
				if (!empty($crud_result)) {
					$order_id = $crud_result;
				} else {
					return 'something wrong';
				}

				//insert all information to Sales Details Table
				if ($request->product_id != null) {
					for ($i = 0; $i < count($request->product_id); $i++) {
						$SalesDetails = new SalesDetails();
						$SalesDetails->order_id = $order_id;
						$SalesDetails->product_id = $request->product_id[$i] ?? '';
						$SalesDetails->unique_barcode = $request->barcode[$i];
						$SalesDetails->qty = $request->qty[$i];
						$SalesDetails->lot_no = $request->product_lot_no[$i];
						$SalesDetails->sales_price = $request->sales_price[$i];
						$SalesDetails->vat_rate = $request->vat_rate[$i];
						$SalesDetails->discount_rate = $request->discount_rate[$i];
						$SalesDetails->line_total = $request->sales_price_line_total[$i];
						$SalesDetails->note = $request->note[$i] ?? '';
						$SalesDetails->save();
						//update Inventory table when add product in sales form
						$Inventory = new Inventory();
						$previous_allocated = Inventory::where('product_id', '=', $request->product_id[$i])->first();
						if (!empty($previous_allocated)) {
							$allocate_adjustment = $previous_allocated->allocated + $request->qty[$i];
							//$available_adjustment = $previous_allocated->available - $request->quantity;
							$previous_allocated->allocated = $allocate_adjustment;
							//$previous_allocated->available = $available_adjustment;
							$previous_allocated->save();
						} else {
							return "not found";
						}
						//empty from sales temtable after confirm sales
						$sales_temtable = new sales_temtable();
						$sales_temtable = sales_temtable::where('product_id', $request->product_id[$i])->where('employee_id', Auth::user()->id)->delete();

						//Data insert into Cost of Goods Sold Table
						$CostofGoodsSoldAccounts = new CostofGoodsSoldAccounts();
						$CostofGoodsSoldAccounts->order_id = $order_id;
						$CostofGoodsSoldAccounts->account_no = $request->product_id[$i];
						$CostofGoodsSoldAccounts->transection_date = $date;
						$CostofGoodsSoldAccounts->debit = $request->cost_price_line_total[$i];
						$CostofGoodsSoldAccounts->note = $request->notes[$i];
						$CostofGoodsSoldAccounts->created_by = Auth::user()->id;
						$CostofGoodsSoldAccounts->save();
					}
				}
				$cost_price_line_total = array_sum($request->cost_price_line_total ?? []);
				$discount_total = $request->discount_total ?? 0;
				$gross_total = $request->gross_total ?? 0;
				$vat_total = $request->vat_total ?? 0;
				//defult accounts

				if($options->s_amount_receive_ledger ==0){
					$sales_receive_ledger = $options->s_default_cash_ledger ?? 14; //amount receive account
				}else{
					$sales_receive_ledger = $options->sales_receive_ledger ?? 14;  //amount receive account
				}
				$s_sales_ledger = $options->s_sales_ledger ?? 8; //default sales accounts
				$s_inventory_ledger = $options->s_inventory_ledger ?? 6; //default inventory accounts
				$s_cost_goods_ledger = $options->s_cost_goods_ledger ?? 5; //cost of goods solds
				$s_vatpayable_ledger = $options->s_vatpayable_ledger ?? 124; //default inventory accounts
				$s_discount_ledger = $options->s_discount_ledger ?? 123; //default inventory accounts
				$s_default_vat_input_ledger = $options->s_default_vat_input_ledger ?? 123; //default inventory accounts
				//$customer 
//return $cost_price_line_total;

				//Create New Voucher 
				$voucher_number = AccountVoucherMaster::count();
		    	$voucher_number= ($voucher_number+1);
		    	if(strlen($voucher_number)==1){
		    		$voucher_number = "0".$voucher_number;
		    	}
		    	$vm_user = Auth::user()->name ?? '';
		    	$vm_no= date('Y')."-".$voucher_number;
		    	$AccountVoucherMaster = new AccountVoucherMaster();
		    	$AccountVoucherMaster->vm_no = $vm_no;
		    	$AccountVoucherMaster->vm_date =  $request->transection_date ??  date('Y-m-d H:i:s');
		    	$AccountVoucherMaster->vm_type = 'JV' ;
		    	$AccountVoucherMaster->vm_naration = $request->common_notes ?? '';
		    	$AccountVoucherMaster->vm_user = $vm_user;
		    	$AccountVoucherMaster->vm_post_flag = 1;
		    	$AccountVoucherMaster->vm_no_id = $order_id;
		    	$AccountVoucherMaster->vm_amount = $request->gross_total ?? 0;
		    	$AccountVoucherMaster->status = $request->status ?? 1;
		    	$AccountVoucherMaster->save();

		    	//Customer save with debit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
		    	$AccountLedger->lg_ad_id = $customer ?? '';
		    	$AccountLedger->lg_dr_amt =$request->gross_total ?? 0;
		    	$AccountLedger->lg_cr_amt =   0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->common_notes ?? '';
		    	$AccountLedger->save();



		    	//SalesLedger save with credit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
		    	$AccountLedger->lg_ad_id = $s_sales_ledger ?? '';
		    	$AccountLedger->lg_dr_amt = 0;
		    	$AccountLedger->lg_cr_amt = $request->gross_total ?? 0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->common_notes ?? '';
		    	$AccountLedger->save();

		    	


		    	//cost of goods sold save with debit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
		    	$AccountLedger->lg_ad_id = $s_cost_goods_ledger ?? '';
		    	$AccountLedger->lg_dr_amt = $cost_price_line_total ??  0;
		    	$AccountLedger->lg_cr_amt = 0;
		    	$AccountLedger->lg_data_flag = 2;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->common_notes ?? '';
		    	$AccountLedger->save();

		    	//Inventory account save with credit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
		    	$AccountLedger->lg_ad_id = $s_inventory_ledger;
		    	$AccountLedger->lg_dr_amt =  0;
		    	$AccountLedger->lg_cr_amt =   $cost_price_line_total ??  0;
		    	$AccountLedger->lg_data_flag = 2;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->common_notes ?? '';
		    	$AccountLedger->save();

		    	$discount_total = $request->discount_total ?? 0;

		    	if($discount_total > 0){
		    		//Discount  account save with Debit amount 
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
			    	$AccountLedger->lg_ad_id = $s_discount_ledger;
			    	$AccountLedger->lg_dr_amt = $request->discount_total ?? 0;
			    	$AccountLedger->lg_cr_amt =   0;
			    	$AccountLedger->lg_data_flag = 3;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->common_notes ?? '';
			    	$AccountLedger->save();

			    	//Customer save with credit amount 
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
			    	$AccountLedger->lg_ad_id = $customer ?? '';
			    	$AccountLedger->lg_dr_amt = 0;
			    	$AccountLedger->lg_cr_amt =  $request->discount_total ?? 0;
			    	$AccountLedger->lg_data_flag = 3;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->common_notes ?? '';
			    	$AccountLedger->save();
		    	}

		    	$vat_total = $request->vat_total ?? 0;

		    	if($vat_total > 0){
		    		//Vatpayable  account save with Debit amount 
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
			    	$AccountLedger->lg_ad_id = $s_discount_ledger;
			    	$AccountLedger->lg_dr_amt =  0;
			    	$AccountLedger->lg_cr_amt = $request->vat_total ??  0;
			    	$AccountLedger->lg_data_flag = 4;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->common_notes ?? '';
			    	$AccountLedger->save();

			    	//Vat input account for adjustment
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
			    	$AccountLedger->lg_ad_id = $s_default_vat_input_ledger ?? '';
			    	$AccountLedger->lg_dr_amt = $request->vat_total ??  0;
			    	$AccountLedger->lg_cr_amt =   0;
			    	$AccountLedger->lg_data_flag = 4;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->common_notes ?? '';
			    	$AccountLedger->save();
		    	}

		    	//Amount receive ledger
		    	$receive_amount_from_custome = $request->receive_amount_from_custome ?? 0;
		    	if($receive_amount_from_custome > 0){

		    		$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
			    	$AccountLedger->lg_ad_id = $request->s_default_cash_ledger ?? ($options->s_default_cash_ledger ?? 14);
			    	$AccountLedger->lg_dr_amt = $receive_amount_from_custome;
			    	$AccountLedger->lg_cr_amt =   0;
			    	$AccountLedger->lg_data_flag = 5;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->common_notes ?? '';
			    	$AccountLedger->save();

			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
			    	$AccountLedger->lg_ad_id = $customer;
			    	$AccountLedger->lg_dr_amt =0 ;
			    	$AccountLedger->lg_cr_amt =  $receive_amount_from_custome;
			    	$AccountLedger->lg_data_flag = 5;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->common_notes ?? '';
			    	$AccountLedger->save();
		    	}
				

				// //if receved amount  not empty then data insert onto Cash Book Accoutns table
				// if ($receive_amount_from_custome != null && $receive_amount_from_custome > 0) {
				// 	$CashBook = new CashBook();
				// 	//$CashBook->account_no = $customer;

				// 	$CashBook->account_no = $request->cash_book ?? 1;
				// 	$CashBook->own_account_no = $customer;

				// 	$CashBook->refeance_no = $order_id;
				// 	$CashBook->transection_date = $date;
				// 	if ($request->net_total == $receive_amount_from_custome) {
				// 		$CashBook->debit = $receive_amount_from_custome;
				// 	} elseif ($request->net_total > $receive_amount_from_custome) {
				// 		$CashBook->debit = $receive_amount_from_custome;
				// 	} elseif ($request->net_total < $receive_amount_from_custome) {
				// 		$CashBook->debit = $request->net_total;
				// 	}
				// 	$CashBook->description = $request->common_notes;
				// 	$CashBook->person_type = 'customer';
				// 	$CashBook->created_by = Auth::user()->id;
				// 	$CashBook->save();
				// }

				// //data insert into sales Accounts
				// if ($order_id != null) {
				// 	$SalesAccounts = new SalesAccounts();
				// 	$SalesAccounts->order_id = $order_id;
				// 	$SalesAccounts->account_no = $customer;
				// 	$SalesAccounts->transection_date = $date;
				// 	$SalesAccounts->credit = ($request->gross_total - $request->discount_total);
				// 	$SalesAccounts->note = $request->common_notes;
				// 	$SalesAccounts->created_by = Auth::user()->id;
				// 	$SalesAccounts->save();
				// }

				// //Data insert into Customers Accounts Table
				// if ($order_id != null) {
				// 	$CustomerAccounts = new CustomerAccounts();
				// 	$CustomerAccounts->account_no = $customer;
				// 	$CustomerAccounts->transection_no = $order_id;
				// 	$CustomerAccounts->transection_date = $date;
				// 	$CustomerAccounts->debit = $request->net_total;
				// 	if ($receive_amount_from_custome != null && $receive_amount_from_custome > 0) {
				// 		if ($request->net_total == $receive_amount_from_custome) {
				// 			$CustomerAccounts->credit = $receive_amount_from_custome;
				// 		} elseif ($request->net_total > $receive_amount_from_custome) {
				// 			$CustomerAccounts->credit = $receive_amount_from_custome;
				// 		} elseif ($request->net_total < $receive_amount_from_custome) {
				// 			$CustomerAccounts->credit = $request->net_total;
				// 		}
				// 	}
				// 	$CustomerAccounts->created_by = Auth::user()->id;
				// 	$CustomerAccounts->description = $request->common_notes;
				// 	$CustomerAccounts->save();
				// }

				// //if sales discount paid then data insert into Sales Discount
				// if ($request->discount_line_total != null && $request->discount_line_total > 0) {
				// 	for ($i = 0; $i < count($request->discount_line_total); $i++) {
				// 		$SalesDiscountAccount = new SalesDiscountAccount();
				// 		$SalesDiscountAccount->order_id = $order_id;
				// 		$SalesDiscountAccount->account_no = $request->product_id[$i];
				// 		$SalesDiscountAccount->transection_date = $date;
				// 		$SalesDiscountAccount->debit = $request->discount_line_total[$i];
				// 		$SalesDiscountAccount->note = $request->notes[$i];
				// 		$SalesDiscountAccount->created_by = Auth::user()->id;
				// 		$SalesDiscountAccount->save();
				// 	}
				// }

				// //if vat Amount Received from Customer then data insert into Vat Accounts Table
				// if ($request->vat_line_total != null && $request->vat_line_total > 0) {
				// 	for ($i = 0; $i < count($request->vat_line_total); $i++) {
				// 		$VatAccounts = new VatAccounts();
				// 		$VatAccounts->order_id = $order_id;
				// 		$VatAccounts->account_no = $request->product_id[$i];
				// 		$VatAccounts->transection_date = $request->date;
				// 		$VatAccounts->credit = $request->vat_line_total[$i];
				// 		$VatAccounts->note = $request->notes[$i];
				// 		$VatAccounts->created_by = Auth::user()->id;
				// 		$VatAccounts->save();
				// 	}
				// }

				DB::commit();
				return ['done' => $order_id];
			} catch (Exception $e) {
				DB::rollBack();
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	//park sales function
	public function park_sales_process(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			DB::beginTransaction();
			try {
				if ($request->customer_id == null) {
					$customer = 0;
					$payment_type = 1;
				} else {
					$customer = $request->customer_id;
					$payment_type = 2;
				}
				if ($request->net_total == 0.00) {
					return "no product";
				}
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$crud = new \App\Library\Crud;
				$collection = $library->remove_element($request, ['order_id', 'customer_Id', 'employee_id', 'order_type', 'pre_order_status', 'gross_total', 'discount_total', 'vat_total']);
				$collection = $library->add_element($collection, ['order_id' => md5($date), 'customer_Id' => $customer, 'employee_id' => Auth::user()->id, 'order_type' => 'park_sales', 'pre_order_status' => 1, 'order_date' => $date, 'gross_amount' => $request->gross_total, 'gross_discount' => $request->discount_total, 'gross_vat_amount' => $request->vat_total, 'payment_amount' => $request->net_total, 'transection_type' => $payment_type]);
				//return dump($collection);
				$crud_result = $crud->InsertValue('SalesOrder', $collection);
				if (!empty($crud_result)) {
					$order_id = $crud_result;
				} else {
					return 'something wrong';
				}
				//insert all information to Sales Details Table
				if ($request->product_id != null) {
					for ($i = 0; $i < count($request->product_id); $i++) {
						//$request->qty[$i] = floatval($request->qty[$i]);
						$SalesDetails = new SalesDetails();
						$SalesDetails->order_id = $order_id;
						$SalesDetails->product_id = $request->product_id[$i];
						$SalesDetails->unique_barcode = $request->barcode[$i];
						$SalesDetails->qty = $request->qty[$i];
						$SalesDetails->sales_price = $request->sales_price[$i];
						$SalesDetails->vat_rate = $request->vat_rate[$i];
						$SalesDetails->discount_rate = $request->discount_rate[$i];
						$SalesDetails->line_total = $request->sales_price_line_total[$i];
						$SalesDetails->lot_no = $request->product_lot_no[$i];
						$SalesDetails->note = $request->note[$i];
						$SalesDetails->save();
						//update Inventory table when add product in sales form
						$Inventory = new Inventory();
						$previous_allocated = Inventory::where('product_id', '=', $request->product_id[$i])->first();
						if (!empty($previous_allocated)) {

							$on_order_adjustment = $previous_allocated->on_order + $request->qty[$i];
							//$available_adjustment = $previous_allocated->available - $request->quantity;
							$previous_allocated->on_order = $on_order_adjustment;
							//$previous_allocated->available = $available_adjustment;
							$previous_allocated->save();
						} else {
							return "not found";
						}
						//empty from sales temtable after confirm sales
						$sales_temtable = new sales_temtable();
						$sales_temtable = sales_temtable::where('product_id', $request->product_id[$i])->where('employee_id', Auth::user()->id)->delete();
					}
				}

				//product price list table qty update maintaining FIFO of LIFO
				//we are maintain FIFO method for inventory
				//Old purchase product sales first and it we ensure using order_id in product_price_list table
				//inventory table update
				if ($request->product_lot_no != null) {
					for ($i = 0; $i < count($request->product_lot_no); $i++) {
						$ProductPriceList = new ProductPriceList();
						$previous_list = ProductPriceList::where('product_id', '=', $request->product_id[$i])->where('order_id', '=', $request->product_lot_no[$i])->first();
						if (!empty($previous_list)) {
							$list_adjustment = $previous_list->qty - $request->qty[$i];
							$previous_list->qty = $list_adjustment;
							if ($previous_list->qty == 0) {
								$previous_list->status = 0;
							}
							$previous_list->save();
						}

					}

				}
				DB::commit();
				return ['done' => $order_id];

			} catch (Exception $e) {
				DB::rollBack();
				echo 'Caught exception: ', $e->getMessage(), "\n";
			}

		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function empty_temp_table(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			DB::beginTransaction();
			try {
				$tempTableItems = sales_temtable::where('employee_id', Auth::user()->id)->get();
				if (count($tempTableItems) > 0) {
					foreach ($tempTableItems as $items) {
						if (count($items->order_id) > 0) {
							for ($i = 0; $i < count($items->order_id); $i++) {
								//product price list table update
								$ProductPriceList = ProductPriceList::where('order_id', $items->order_id)->where('product_id', $items->product_id)->where('barcode', $items->barcode)->first();
								if (!is_null($ProductPriceList)) {
									$ProductPriceList->qty = ($ProductPriceList->qty + $items->qty);
									$ProductPriceList->status = 1;
									$ProductPriceList->save();
								} else {
									return "Product not found in product price list table";
								} //End update product price list table

								//Inventory table update
								$Inventory = new Inventory();
								$Inventory = Inventory::where('product_id', '=', $items->product_id)->first();
								if (!is_null($Inventory)) {
									$adjusted_qty = $Inventory->available + $items->qty;
									$Inventory->available = $adjusted_qty;
									$Inventory->status = 1;
									$Inventory->save();

								} else {
									return "inventory not Updated";
								}
							}
						} else {
							return "Product not found ";
						}
					}

					//empty temporary sales table data
					$sales_temtable = new sales_temtable();
					$sales_temtable = sales_temtable::where('employee_id', Auth::user()->id)->delete();
					DB::commit();
					return "delete";
				} else {
					return "not delete";
				}

			} catch (Exception $e) {
				DB::rollBack();
				echo 'Caught exception: ', $e->getMessage(), "\n";
			}

		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function preorder_details(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			$id = $request->id;
			if ($id != '') {
				$sales_orders = DB::table('sales_orders')->where('id', $id)->where('order_type', '=', 'park_sales')->first();
				if (!empty($sales_orders)) {
					$sales_details = DB::table('sales_details')->where('order_id', $id)->get();
					$product_profiles = DB::table('product_profiles')->get();
					$customerInfo = DB::table('customer_profiles')->where('id', $sales_orders->customer_Id)->first();
					return view('sales.preorder-details', compact('sales_orders', 'customerInfo', 'sales_details', 'product_profiles'));
				} else {
					Session::flash('message', 'Please Check Pre Order Sales Invoice List !');
					return view('sales.preorder-details');
				}

			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function preorderSalesConfirm(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_add')) {
			$request->receive_amount_from_custome = floatval($request->receive_amount_from_custome);

			$SalesOrder = new SalesOrder();
			$SalesOrder = SalesOrder::where('id', $request->order_id)->where('order_type', 'park_sales')->first();
			if (!empty($SalesOrder)) {
				$previousReceive_amount = floatval($SalesOrder->receive_amount_from_custome);
				$currentReceivedAmount = floatval($previousReceive_amount) + floatval($request->receive_amount_from_custome);
				//update sales order table
				$SalesOrder->receive_amount_from_custome = $currentReceivedAmount;
				$SalesOrder->due_amount = $SalesOrder->payment_amount - $currentReceivedAmount;

				$request->payment_amount = floatval($request->payment_amount);
				if ($request->payment_amount < $currentReceivedAmount) {
					$returnAmount = $currentReceivedAmount - $request->payment_amount;
					$SalesOrder->return_amount = $returnAmount;
				}
				$SalesOrder->order_type = 'sales';
				$SalesOrder->pre_order_status = 0;
				$SalesOrder->employee_id = Auth::user()->id;
				$SalesOrder->save();

				//data insert into customer Accounts
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$request->receive_amount_from_custome = floatval($request->receive_amount_from_custome);
				$request->payment_amount = floatval($request->payment_amount);
				$CustomerAccounts = new CustomerAccounts();
				$CustomerAccounts->account_no = $request->customer_id;
				$CustomerAccounts->transection_no = $request->order_id;
				$CustomerAccounts->transection_date = $date;
				$CustomerAccounts->debit = $request->payment_amount;
				if ($request->receive_amount_from_custome != null && $request->receive_amount_from_custome > 0) {
					if ($request->payment_amount == $request->receive_amount_from_custome) {
						$CustomerAccounts->credit = $request->receive_amount_from_custome;
					} elseif ($request->payment_amount > $request->receive_amount_from_custome) {
						$CustomerAccounts->credit = $request->receive_amount_from_custome;
					} elseif ($request->payment_amount < $request->receive_amount_from_custome) {
						$CustomerAccounts->credit = $request->payment_amount;
					}
				}
				$CustomerAccounts->created_by = Auth::user()->id;
				$CustomerAccounts->save();

				//if sales discount paid then data insert into Sales Discount
				if ($request->discount_line_total != null && $request->discount_line_total > 0) {
					for ($i = 0; $i < count($request->discount_line_total); $i++) {
						$SalesDiscountAccount = new SalesDiscountAccount();
						$SalesDiscountAccount->order_id = $request->order_id;
						$SalesDiscountAccount->account_no = $request->product_id[$i];
						$SalesDiscountAccount->transection_date = $date;
						$SalesDiscountAccount->debit = $request->discount_line_total[$i];
						$SalesDiscountAccount->note = $request->notes[$i];
						$SalesDiscountAccount->created_by = Auth::user()->id;
						$SalesDiscountAccount->save();
					}
				}

				//if vat Amount Received from Customer then data insert into Vat Accounts Table
				if ($request->vat_line_total != null && $request->vat_line_total > 0) {
					for ($i = 0; $i < count($request->vat_line_total); $i++) {
						$VatAccounts = new VatAccounts();
						$VatAccounts->order_id = $request->order_id;
						$VatAccounts->account_no = $request->product_id[$i];
						$VatAccounts->transection_date = $date;
						$VatAccounts->credit = $request->vat_line_total[$i];
						$VatAccounts->note = $request->notes[$i];
						$VatAccounts->created_by = Auth::user()->id;
						$VatAccounts->save();
					}
				}

				//data insert into cost of goods sold
				if ($request->product_id != null) {
					for ($i = 0; $i < count($request->product_id); $i++) {
						$cost_price = DB::table('product_price_lists')->where('order_id', $request->lot_no)->where('product_id', $request->product_id[$i])->first();
						if (!empty($cost_price)) {
							$cost_price_line_total = $cost_price->cost_price * $request->qty[$i];
							$CostofGoodsSoldAccounts = new CostofGoodsSoldAccounts();
							$CostofGoodsSoldAccounts->order_id = $request->order_id;
							$CostofGoodsSoldAccounts->account_no = $request->product_id[$i];
							$CostofGoodsSoldAccounts->transection_date = $date;
							$CostofGoodsSoldAccounts->debit = $cost_price_line_total;
							$CostofGoodsSoldAccounts->note = $request->notes[$i];
							$CostofGoodsSoldAccounts->created_by = Auth::user()->id;
							$CostofGoodsSoldAccounts->save();
						}

						//update Inventory table when add product in sales form
						$Inventory = new Inventory();
						$previous_allocated = Inventory::where('product_id', '=', $request->product_id[$i])->first();
						if (!empty($previous_allocated)) {
							//$request->qty[$i] = floatval($request->qty[$i]);
							$allocate_adjustment = $previous_allocated->allocated + $request->qty[$i];
							$on_order_adjustment = $previous_allocated->on_order - $request->qty[$i];
							$previous_allocated->allocated = $allocate_adjustment;
							$previous_allocated->on_order = $on_order_adjustment;
							$previous_allocated->save();
						} else {
							return "not found";
						}

					}
				}

				//if receved amount  not empty then data insert onto Cash Book Accoutns table
				if ($request->receive_amount_from_custome != null && $request->receive_amount_from_custome > 0) {

					$CashBook = new CashBook();
					//$CashBook->account_no = $request->customer_id;
					$CashBook->account_no = $request->cash_book ?? 1;
					$CashBook->own_account_no = $request->customer_id;
					$CashBook->refeance_no = $request->order_id;
					$CashBook->transection_date = $date;
					if ($request->payment_amount == $request->receive_amount_from_custome) {
						$CashBook->debit = $request->receive_amount_from_custome;
					} elseif ($request->payment_amount > $request->receive_amount_from_custome) {
						$CashBook->debit = $request->receive_amount_from_custome;
					} elseif ($request->payment_amount < $request->receive_amount_from_custome) {
						$CashBook->debit = $request->payment_amount;
					}
					$CashBook->description = $request->common_notes;
					$CashBook->person_type = 'customer';
					$CashBook->created_by = Auth::user()->id;

					$CashBook->save();

				}
				//data insert into sales Accounts
				if ($request->order_id != null) {
					$SalesAccounts = new SalesAccounts();
					$SalesAccounts->order_id = $request->order_id;
					$SalesAccounts->account_no = $request->customer_id;
					$SalesAccounts->transection_date = $date;
					$SalesAccounts->credit = ($request->gross_total - $request->discount_total);
					$SalesAccounts->note = $request->common_notes;
					$SalesAccounts->created_by = Auth::user()->id;
					$SalesAccounts->save();

				}

			}

			Session::flash('message', 'Preorder sale confirm !');

			return redirect('sales-preorder-invoice');
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	//load Sales return page
	public function sales_return() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			return view('sales.return');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	//find out invoice number wise sales invoice details load
	public function findReturnInvoice(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			DB::beginTransaction();
			try {
				 $id = $request->searchInvoice;
				// if ($id != '') {
				// 	$returnCheck = DB::table('sales_retrun_orders')->where('return_return_ref', '=', $id)->first();
				// 	if (!empty($returnCheck)) {
				// 		Session::flash('message', 'You Can not Return Product More Then One Time !');
				// 		return redirect('sales-return');
				// 	} else {
				// 		$sales_orders = DB::table('sales_orders')->where('id', $id)->where('order_type', '=', 'sales')->first();
				// 	}
				// }
				$sales_orders = DB::table('sales_orders')->where('id', $id)->where('order_type', '=', 'sales')->first();

				if ($sales_orders != null) {
					$sales_details = DB::table('sales_details')->where('order_id', $id)->where('status',1)->get();
					$product_profiles = DB::table('product_profiles')->get();
					 $customerInfo = AccountDetail::where('id', $sales_orders->customer_Id)->first();
					$TransactionTerm = DB::table('transaction_terms')->where('id', '=', $sales_orders->transection_type)->first();
					$costPriceD = array();
					foreach ($sales_details as $value) {
						$costInfo = ProductPriceList::where('order_id', '=', $value->lot_no)->where('product_id', '=', $value->product_id)->first();
						array_push($costPriceD, $costInfo);
					}
					DB::commit();
					return view('sales.return-details', compact('sales_orders', 'customerInfo', 'sales_details', 'product_profiles', 'costPriceD', 'TransactionTerm'));
				} else {
					Session::flash('message', 'Please Search with valid Invoice Number !');
					return redirect()->back();
				}

			} catch (Exception $e) {
				DB::rollBack();
				echo 'Caught exception: ', $e->getMessage(), "\n";
			}

		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function salesReturnConfirm(Request $request) {
		//return dump($request->all());die();
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_edit')) {
			DB::beginTransaction();
			try {
				//return dump($request->all());die();
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$net_amount = floatval($request->net_amount ?? 0);
				$payment_amount = floatval($request->payment_amount ?? 0);
				$gross_amount = floatval($request->gross_amount ?? 0);
				$gross_discount = floatval($request->gross_discount ?? 0);
				$gross_vat_amount = floatval($request->gross_vat_amount ?? 0);
				$customer = $request->customer;
				// if ($payment_amount == null) {
				// 	$payment_amount = 0;
				// }
				$crud = new \App\Library\Crud;
				$collection = $library->remove_element($request, ['return_order_id', 'return_customer_Id', 'return_order_date', 'return_gross_amount', 'return_return_amount', 'return_amount_paid_customer', 'return_gross_discount', 'return_return_ref', 'return_transection_type', 'return_order_type', 'return_order_type', 'return_employee_id', 'return_gross_vat_amount', 'return_employee_id', 'return_purchase_return', 'return_note', 'status']);
				$collection = $library->add_element($collection, ['return_order_id' => md5($date), 'return_customer_Id' => $request->customer, 'return_employee_id' => Auth::user()->id, 'order_type' => 'sales_return', 'return_pre_order_status' => 2, 'return_order_date' => $date, 'return_gross_amount' => $gross_amount, 'return_gross_discount' => $gross_discount, 'return_gross_vat_amount' => $request->gross_vat_amount, 'return_return_amount' => $net_amount, 'return_amount_paid_customer' => $payment_amount, 'return_return_ref' => $request->preorder_ref, 'return_transection_type' => 1, 'return_note' => $request->note]);
				//return dump($collection);
				$crud_result = $crud->InsertValue('SalesRetrunOrder', $collection);
				$order_id = $crud_result;
				// if (!empty($crud_result)) {
				// 	$order_id = $crud_result;
				// 	$SalesOrder = new SalesOrder;
				// 	$SalesOrder = SalesOrder::where('id', '=', $request->preorder_ref)->first();
				// 	if (!empty($SalesOrder)) {
				// 		$SalesOrder->return_ref = $order_id;
				// 		$SalesOrder->return_amount = $net_amount;
				// 		// if ($payment_amount == '') {
				// 		// 	$payment_amount = 0;
				// 		// }
				// 		$SalesOrder->due_amount = ($SalesOrder->payment_amount - $SalesOrder->receive_amount_from_custome) - ($net_amount - $payment_amount);
				// 		$SalesOrder->receive_amount_from_custome = $SalesOrder->receive_amount_from_custome - $payment_amount;
				// 		$SalesOrder->save();
				// 	}

				// } else {
				// 	return 'something wrong';
				// }
				//return $crud_result;
				// $CustomerAccounts = new CustomerAccounts();
				// $CustomerAccounts->account_no = $request->customer;
				// $CustomerAccounts->transection_no = $order_id;
				// $CustomerAccounts->transection_date = $date;
				// if ($payment_amount == 0) {
				// 	$CustomerAccounts->credit = $net_amount;
				// } else {
				// 	$CustomerAccounts->credit = ($net_amount - $payment_amount);
				// }
				// $CustomerAccounts->description = $request->note;
				// $CustomerAccounts->created_by = Auth::user()->id;
				// $CustomerAccounts->save();
				//insert all information to Sales Details Table
				$cost_price_line_total = 0;
				if ($request->product_id != null) {
					for ($i = 0; $i < count($request->product_id); $i++) {
						$SalesDetails = new SalesDetails();
						$SalesDetails->order_id = $request->preorder_ref;
						$SalesDetails->product_id = $request->product_id[$i];
						$SalesDetails->unique_barcode = $request->barcode[$i];
						$SalesDetails->qty = $request->qty[$i];
						$SalesDetails->sales_price = $request->sales_price[$i];
						$SalesDetails->vat_rate = $request->vat_rate[$i];
						$SalesDetails->discount_rate = $request->discount_rate[$i];
						$SalesDetails->line_total = $request->sales_price_line_total[$i];
						$SalesDetails->return_ref = $order_id;
						$SalesDetails->lot_no = $request->product_lot_no[$i];
						$SalesDetails->status = 0;
						$SalesDetails->save();
						//update Inventory table when add product in sales form
						$Inventory = new Inventory();
						$previous_allocated = Inventory::where('product_id', '=', $request->product_id[$i])->first();
						if (!empty($previous_allocated)) {
							$on_order_adjustment = $previous_allocated->on_order - $request->qty[$i];
							$available_adjustment = $previous_allocated->available + $request->quantity;
							$sales_return_adjustment = $previous_allocated->sales_return + $request->quantity;
							$previous_allocated->on_order = $on_order_adjustment;
							$previous_allocated->available = $available_adjustment;
							$previous_allocated->sales_return = $sales_return_adjustment;
							$previous_allocated->save();
						} else {
							return "Inventory table not updated";
						}
						$CostofGoodsSoldAccounts = new CostofGoodsSoldAccounts();
						$CostofGoodsSoldAccounts->order_id = $order_id;
						$CostofGoodsSoldAccounts->account_no = $request->product_id[$i];
						$CostofGoodsSoldAccounts->transection_date = $date;
						$CostofGoodsSoldAccounts->credit = $request->cost_price_line_total[$i];
						$CostofGoodsSoldAccounts->created_by = Auth::user()->id;
						$CostofGoodsSoldAccounts->save();
						$cost_price_line_total += $request->cost_price_line_total[$i] ?? 0;
						//product price list table qty update maintaining FIFO of LIFO
						//we are maintain FIFO method for inventory
						//Old purchase product sales first and it we ensure using order_id in product_price_list table
						//inventory table update
						$ProductPriceList = new ProductPriceList();
						$previous_list = ProductPriceList::where('product_id', '=', $request->product_id[$i])->where('order_id', '=', $request->product_lot_no[$i])->first();
						if (!empty($previous_list)) {
							$list_adjustment = $previous_list->qty + $request->qty[$i];
							$previous_list->qty = $list_adjustment;
							$previous_list->status = 1;
							$previous_list->save();
						}
					}
				}

				$options = SettingOption::first(); //default settings value
				$discount_total = $request->gross_discount ?? 0;
				$gross_total = $request->gross_amount ?? 0;
				$vat_total = $request->gross_vat_amount ?? 0;
				//defult accounts

				if($options->s_amount_receive_ledger ==0){
					$sales_receive_ledger = $options->s_default_cash_ledger ?? 14; //amount receive account default Cash in hand
				}else{
					$sales_receive_ledger = $options->sales_receive_ledger ?? 14;  //amount receive account default cash in hand
				}
				$s_sales_ledger = $options->s_sales_ledger ?? 8; //default sales accounts
				$s_inventory_ledger = $options->s_inventory_ledger ?? 6; //default inventory accounts
				$s_cost_goods_ledger = $options->s_cost_goods_ledger ?? 5; //cost of goods solds
				$s_vatpayable_ledger = $options->s_vatpayable_ledger ?? 10; //default inventory accounts
				$s_discount_ledger = $options->s_discount_ledger ?? 9; //default inventory accounts
				$s_default_vat_input_ledger = $options->s_default_vat_input_ledger ?? 14; //default inventory accounts
				$s_default_sales_return = $options->s_default_sales_return ?? 15; //default inventory accounts
				//$customer 
//return $cost_price_line_total;

				//Create New Voucher 
				$voucher_number = AccountVoucherMaster::count();
		    	$voucher_number= ($voucher_number+1);
		    	if(strlen($voucher_number)==1){
		    		$voucher_number = "0".$voucher_number;
		    	}
		    	$vm_user = Auth::user()->name ?? '';
		    	$vm_no= date('Y')."-".$voucher_number;
		    	$AccountVoucherMaster = new AccountVoucherMaster();
		    	$AccountVoucherMaster->vm_no = $vm_no;
		    	$AccountVoucherMaster->vm_date =  $request->transection_date ??  date('Y-m-d H:i:s');
		    	$AccountVoucherMaster->vm_type = 'JV' ;
		    	$AccountVoucherMaster->vm_naration = $request->note ?? '';
		    	$AccountVoucherMaster->vm_user = $vm_user;
		    	$AccountVoucherMaster->vm_post_flag = 1;
		    	$AccountVoucherMaster->vm_no_id = $order_id;
		    	$AccountVoucherMaster->vm_amount = $request->gross_amount ?? 0;
		    	$AccountVoucherMaster->status = $request->status ?? 1;
		    	$AccountVoucherMaster->save();

		    	//Customer save with debit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->note ?? '';
		    	$AccountLedger->lg_ad_id = $customer ?? '';
		    	$AccountLedger->lg_dr_amt = 0;
		    	$AccountLedger->lg_cr_amt = $request->gross_amount ??  0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->note ?? '';
		    	$AccountLedger->save();



		    	//Sales Return Ledger save with credit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->note ?? '';
		    	$AccountLedger->lg_ad_id = $$s_default_sales_return ?? '';
		    	$AccountLedger->lg_dr_amt = $request->gross_amount ?? 0;
		    	$AccountLedger->lg_cr_amt =  0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->note ?? '';
		    	$AccountLedger->save();

		    	


		    	//cost of goods sold save with credit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->note ?? '';
		    	$AccountLedger->lg_ad_id = $s_cost_goods_ledger ?? '';
		    	$AccountLedger->lg_dr_amt =   0;
		    	$AccountLedger->lg_cr_amt =$cost_price_line_total ?? 0;
		    	$AccountLedger->lg_data_flag = 2;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->note ?? '';
		    	$AccountLedger->save();

		    	//Inventory account save with Debit amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->note ?? '';
		    	$AccountLedger->lg_ad_id = $s_inventory_ledger;
		    	$AccountLedger->lg_dr_amt = $cost_price_line_total ?? 0;
		    	$AccountLedger->lg_cr_amt =     0;
		    	$AccountLedger->lg_data_flag = 2;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->note ?? '';
		    	$AccountLedger->save();

		    	

		    	if($discount_total > 0){
		    		//Discount  account save with Credit amount 
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->note ?? '';
			    	$AccountLedger->lg_ad_id = $s_discount_ledger;
			    	$AccountLedger->lg_dr_amt =  0;
			    	$AccountLedger->lg_cr_amt = $discount_total ??  0;
			    	$AccountLedger->lg_data_flag = 3;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->note ?? '';
			    	$AccountLedger->save();

			    	//Customer save with debit amount 
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->note ?? '';
			    	$AccountLedger->lg_ad_id = $customer ?? '';
			    	$AccountLedger->lg_dr_amt =$discount_total ??  0;
			    	$AccountLedger->lg_cr_amt =   0;
			    	$AccountLedger->lg_data_flag = 3;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->note ?? '';
			    	$AccountLedger->save();
		    	}

		    	$vat_total = $request->vat_total ?? 0;

		    	if($vat_total > 0){
		    		//Vatpayable  account save with Debit amount 
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->note ?? '';
			    	$AccountLedger->lg_ad_id = $s_discount_ledger;
			    	$AccountLedger->lg_dr_amt = $vat_total ?? 0;
			    	$AccountLedger->lg_cr_amt =   0;
			    	$AccountLedger->lg_data_flag = 4;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->note ?? '';
			    	$AccountLedger->save();

			    	//Vat input account for adjustment
			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->note ?? '';
			    	$AccountLedger->lg_ad_id = $s_default_vat_input_ledger ?? '';
			    	$AccountLedger->lg_dr_amt =  0;
			    	$AccountLedger->lg_cr_amt =  $vat_total ??  0;
			    	$AccountLedger->lg_data_flag = 4;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->note ?? '';
			    	$AccountLedger->save();
		    	}

		    	//Amount receive ledger
		    	$receive_amount_from_custome = $request->payment_amount ?? 0;
		    	if($receive_amount_from_custome > 0){

		    		$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->note ?? '';
			    	$AccountLedger->lg_ad_id = $request->s_default_cash_ledger ?? ($options->s_default_cash_ledger ?? 2);
			    	$AccountLedger->lg_dr_amt = 0;
			    	$AccountLedger->lg_cr_amt = $receive_amount_from_custome ??  0;
			    	$AccountLedger->lg_data_flag = 5;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->note ?? '';
			    	$AccountLedger->save();

			    	$AccountLedger = new AccountLedger();
			    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
			    	$AccountLedger->lg_voucher_no = $vm_no;
			    	$AccountLedger->lg_particulars = $request->note ?? '';
			    	$AccountLedger->lg_ad_id = $customer;
			    	$AccountLedger->lg_dr_amt = $receive_amount_from_custome ?? 0 ;
			    	$AccountLedger->lg_cr_amt =  0;
			    	$AccountLedger->lg_data_flag = 5;
			    	$AccountLedger->lg_voucher_type = 'JV' ;
			    	$AccountLedger->lg_usr = $vm_user;
			    	$AccountLedger->lg_vd_sm_id =$order_id;
			    	$AccountLedger->lg_naration = $request->note ?? '';
			    	$AccountLedger->save();
		    	}

				// //if sales discount paid then data insert into Sales Discount
				// if ($request->discount_line_total != null && $request->discount_line_total > 0) {
				// 	for ($i = 0; $i < count($request->discount_line_total); $i++) {
				// 		$SalesDiscountAccount = new SalesDiscountAccount();
				// 		$SalesDiscountAccount->order_id = $order_id;
				// 		$SalesDiscountAccount->account_no = $request->product_id[$i];
				// 		$SalesDiscountAccount->transection_date = $date;
				// 		$SalesDiscountAccount->credit = $request->discount_line_total[$i];
				// 		$SalesDiscountAccount->created_by = Auth::user()->id;
				// 		$SalesDiscountAccount->save();
				// 	}
				// }
				// //if vat Amount Received from Customer then data insert into Vat Accounts Table
				// if ($request->vat_line_total != null && $request->vat_line_total > 0) {
				// 	for ($i = 0; $i < count($request->vat_line_total); $i++) {
				// 		$VatAccounts = new VatAccounts();
				// 		$VatAccounts->order_id = $order_id;
				// 		$VatAccounts->account_no = $request->product_id[$i];
				// 		$VatAccounts->transection_date = $date;
				// 		$VatAccounts->debit = $request->vat_line_total[$i];
				// 		$VatAccounts->created_by = Auth::user()->id;
				// 		$VatAccounts->save();
				// 	}
				// }
				// //if receved amount  not empty then data insert onto Cash Book Accoutns table
				// if ($payment_amount != null || $payment_amount > 0) {
				// 	$CashBook = new CashBook();
				// 	//$CashBook->account_no = $request->customer;
				// 	$CashBook->account_no = $request->cash_book ?? 1;
				// 	$CashBook->own_account_no = $request->customer;
				// 	$CashBook->refeance_no = $order_id;
				// 	$CashBook->transection_date = $date;
				// 	$CashBook->credit = $payment_amount;
				// 	$CashBook->description = $request->note;
				// 	$CashBook->person_type = 'customer';
				// 	$CashBook->created_by = Auth::user()->id;
				// 	$CashBook->save();
				// }

				// //data insert into sales Accounts
				// $SalesAccounts = new SalesAccounts();
				// $SalesAccounts->order_id = $order_id;
				// $SalesAccounts->account_no = $request->customer;
				// $SalesAccounts->transection_date = $date;
				// $SalesAccounts->debit = ($gross_amount - $gross_discount);
				// $SalesAccounts->note = $request->note;
				// $SalesAccounts->created_by = Auth::user()->id;
				// $SalesAccounts->save();
				DB::commit();
				return redirect('return-list');
			} catch (Exception $e) {
				DB::rollBack();
				echo 'Caught exception: ', $e->getMessage(), "\n";
			}

		} else {
			return "Sorry you don't have access to this action";
		}

	}

}
