<?php

namespace App\Http\Controllers;

use App\Role;
use Illuminate\Http\Request;

class Role_controller extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('role_view')) {
			$crud = new \App\Library\Crud;
			$info = $crud->Getvalue('Role');
			$module = $this->GetModule();
			return view('role.index', compact('info', 'module'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function GetModule() {
		$module =module();
		
		return $module;

	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('role_add')) {
			$give_value = array_fill_keys($request->permissions, true);
			$convert_json_value = json_encode($give_value);
			Role::create([

				'name' => $request->name,
				'slug' => str_slug($request->name),
				'permissions' => $convert_json_value,

			]);
			return back();
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('role_add')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('Role', ['id', $id]);
			$module = $module = $this->GetModule();

			return view('role.edit', compact('info', 'module'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('role_edit')) {

			$give_value = array_fill_keys($request->permissions, true);
			$convert_json_value = json_encode($give_value);
			$role = Role::where('id', $request->id)->first();
			$role->name = $request->name;
			$role->slug = str_slug($request->name);
			$role->permissions = $convert_json_value;
			$role->save();
			return redirect('role')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('role_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('Role', ['id', $id]);
			return redirect('role')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}
