<?php

namespace App\Http\Controllers;

use App\CashBook;
use App\CustomerProfile;
use App\ExpenseProfile;
use App\OwnerProfile;
use App\PurchaseOrder;
use App\SalesDetails;
use App\SalesOrder;
use App\SupplierProfile;
use App\ProductPriceList;
use Carbon\Carbon;
use DateTime;
use DateTimezone;
use DB;
use Illuminate\Http\Request;

class ReportController extends Controller {

	public function homePageReport(){
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
	    $date = $dt->format('Y-m-d');
		$monthlySalesReport = DB::select("SELECT  sum(`gross_amount`) as monthly_amount, MONTH(`created_at`) AS `Month`,  YEAR(`created_at`) AS `Year`
    FROM sales_orders AS tn
    WHERE `created_at` >  DATE_SUB(NOW(), INTERVAL 12 MONTH) and order_type='sales'
    GROUP BY Year,Month
    ORDER BY `created_at`");

	$topTenCustomer=DB::select("SELECT SUM(sales_orders.`gross_amount`) as total_amount,customer_profiles.name,sales_orders.`customer_Id` 
								FROM `sales_orders`
								INNER JOIN customer_profiles ON customer_profiles.id=sales_orders.`customer_Id`
								WHERE `order_type`='sales'
								GROUP BY sales_orders.`customer_Id`
								ORDER BY 1 DESC
								LIMIT 10");
	$topTenProductList =DB::select("SELECT SUM(sales_details.line_total) AS total_amount,sales_details.product_id,product_profiles.name
									FROM `sales_details`
									INNER JOIN product_profiles ON product_profiles.id=sales_details.product_id
									GROUP BY sales_details.product_id
									ORDER BY 1 DESC
									LIMIT 10");
	$costofsales = DB::select("SELECT  sum(`debit`)  as monthly_amount, SUM(`credit`),MONTH(`created_at`) AS `Month`,  YEAR(`created_at`) AS `Year`
    FROM costof_goods_sold_accounts AS tn
    WHERE `created_at` >  DATE_SUB(NOW(), INTERVAL 12 MONTH) 
    GROUP BY Year,Month
    ORDER BY `created_at`");
   $dueCustomers = DB::select("SELECT sales_orders.*,customer_profiles.name,customer_profiles.address,customer_profiles.phone FROM `sales_orders`
								INNER JOIN customer_profiles ON customer_profiles.id=sales_orders.customer_Id
								WHERE `due_amount`>0 order by sales_orders.order_date desc limit 100");
   $totalSales = DB::select("SELECT SUM(`payment_amount`) as total_sales FROM `sales_orders` where order_type='sales'");
   $todaySales = DB::select("SELECT SUM(`payment_amount`) as total_sales,LEFT(created_at,10),sum(receive_amount_from_custome) as receive_amount_from_custome,sum(due_amount) as due_amount FROM `sales_orders` where order_type='sales' and LEFT(created_at,10)='".$date."' ");
   

    
		return view('report.home_page',compact('monthlySalesReport','topTenCustomer','topTenProductList','costofsales','dueCustomers','totalSales','todaySales'));
	}


	public function index(Request $request) {
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$date = $dt->format('Y-m-d');
		$customer = [];
		$supplier = [];
		$owners = [];
		$expenses = [];
		//query for daily opening balance
		$query = 'SELECT "' . $date . '" - INTERVAL 1 DAY AS t_date, "B/F" AS descriptions, Sum(a.debit) AS debit, Sum(a.credit) AS credit, Sum(IFNULL(a.debit,0)-IFNULL(a.credit,0)) AS balance
    FROM cash_books a
    WHERE a.transection_date < "' . $date . '"';
		$openingBalance = DB::select($query);
		//return $openingBalance[0]->balance;
		$SalesOrder = SalesOrder::whereDate('order_date', $date)->where('due_amount', '>', 0)->with(['Customer','User'])->get();
		$Sales = SalesOrder::whereDate('order_date', $date)->with(['Customer','User'])->get();
		$PurchaseOrder = PurchaseOrder::whereDate('order_date', $date)->with('SupplierProfile')->get();

		  $todayCash = CashBook::with(['user_name'])->whereDate('transection_date', $date)->get();
		$salesItems = SalesDetails::whereDate('created_at', $date)->with(['product'])->with('entryBy')->get();
		return view('daily-report.daily-report', compact('todayCash', 'customer', 'supplier', 'owners', 'expenses', 'openingBalance', 'SalesOrder', 'PurchaseOrder', 'Sales', 'salesItems'));
	}

	//today credit Sales report
	public function todayCreditSales(Request $request) {
		$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
		$date = $dt->format('Y-m-d');
		$customer = CustomerProfile::get();
		$SalesOrder = SalesOrder::whereDate('order_date', $date)->where('due_amount', '>', 0)->with('Customer')->get();
		echo json_encode($SalesOrder);

	}

	//to day sales report
	public function today_sales(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {

			if (empty($request->all())) {
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d');
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$start_strtotime = strtotime("$start_date 00:00:00");
			$end_strtotime = strtotime("$end_date 23:59:59");
			$start_time = date('Y-m-d H:i:s', $start_strtotime);
			$end_time = date('Y-m-d H:i:s', $end_strtotime);

			$info = DB::table('sales_orders')
				->select('sales_orders.id as order_number', 'sales_orders.payment_amount as payment_amount', 'sales_orders.receive_amount_from_custome as receive_amount_from_custome', 'sales_orders.due_amount as due_amount', 'sales_orders.return_amount as return_amount', 'sales_orders.created_at as created_at', 'customer_profiles.name as customerName', 'customer_profiles.phone as phone')
				->join('customer_profiles', 'customer_profiles.id', '=', 'sales_orders.customer_Id')
				->where('sales_orders.order_type', '=', 'sales')->where('sales_orders.return_ref', '=', null)->whereDate('sales_orders.created_at', Carbon::today())->orderBy('order_number', 'DESC')->get();

			$saleWithReturn = DB::table('sales_orders')
				->select('sales_orders.id as order_number', 'sales_orders.payment_amount as payment_amount', 'sales_orders.receive_amount_from_custome as receive_amount_from_custome', 'sales_orders.due_amount as due_amount', 'sales_orders.created_at as created_at', 'customer_profiles.name as customerName', 'customer_profiles.phone as phone', 'sales_retrun_orders.return_return_amount as return_return_amount', 'sales_retrun_orders.return_amount_paid_customer as return_amount_paid_customer')
				->join('customer_profiles', 'customer_profiles.id', '=', 'sales_orders.customer_Id')
				->join('sales_retrun_orders', 'sales_retrun_orders.return_return_ref', '=', 'sales_orders.id')->whereDate('sales_orders.created_at', Carbon::today())->orderBy('sales_orders.id', 'DESC')->get();
			//dump($saleWithReturn);die();

			return view('sales.sales_invoice_report', compact('info', 'request', 'saleWithReturn'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	//income Statement   calculation function
	public function incomeStatement() {
		$salesQuery = "SELECT  SUM(credit) as totalSales, SUM(debit) as TotalReturn  FROM sales_accounts ";
		$salesInfo = DB::select($salesQuery);
		//dump($salesInfo);die();

		$salesDiscountQuery = "SELECT  SUM(debit - credit) as totalSalesDiscount  FROM sales_discount_accounts ";
		$salesDiscountInfo = DB::select($salesDiscountQuery);

		$cogsQuery = "SELECT   SUM(debit - credit ) as cogsTotal  FROM costof_goods_sold_accounts ";
		$cogsinfo = DB::select($cogsQuery);

		$expQuery = "SELECT SUM(`debit`) as totalExp,SUM(`credit`) as totalExReverse FROM `expense_accounts` ";
		$expinfo = DB::select($expQuery);
		$totalExp = $expinfo[0]->totalExp;
		$totalExReverse = $expinfo[0]->totalExReverse;
		if ($totalExp == null) {
			$totalExp = 0;
		}
		if ($totalExReverse == null) {
			$totalExReverse = 0;
		}

		/*$purchaseVatQuery = "SELECT   SUM(debit - credit ) as TotalVatPaid  FROM purchase_vat_accounts ";
			$purchaseVatinfo = DB::select($purchaseVatQuery);

			$salesVatQuery = "SELECT   SUM(credit - debit ) as TotalVatReceived  FROM vat_accounts ";
		*/

		return view('report.income_statement', compact('salesInfo', 'cogsinfo', 'totalExp', 'totalExReverse'));
	}
	public function BalanceSheet(Request $request) {
		if (empty($request->all())) {
			$time = Carbon::today();
			$rDate = $time->toDateString();
		} else {
			if (!is_null($request->year)) {
				$rDate = $request->year . '-12-31';
			} else {
				return 'Something went to wrong';
			};
		}
		$supplierac = new \App\SupplierAccount();
		$customerrac = new \App\CustomerAccounts();
		$cashac = new \App\CashBook();
		$capitalac = new \App\CapitalAccount();
		$bankac = new \App\BankAccounts();
		$advancepac = new \App\AdvancePaidAccount();
		$advancerac = new \App\AdvanceReceiveAccount();
		$accountspayable = $supplierac->selectRaw('SUM(IFNULL(credit,0))-SUM(IFNULL(debit,0)) as sab')->where('transection_date', '<=', $rDate)->first();
		$accountsrecivale = $customerrac->selectRaw('SUM(IFNULL(debit,0))-SUM(IFNULL(credit,0)) as cab')->where('transection_date', '<=', $rDate)->first();
		$cash = DB::select('SELECT (SUM(cb.`debit`)-SUM(cb.`credit`)) as csab FROM `cash_books` as cb');
		$capital = $capitalac->selectRaw('SUM(IFNULL(credit,0))-SUM(IFNULL(debit,0)) as capab')->where('transection_date', '<=', $rDate)->first();
		$bank = $bankac->selectRaw('SUM(IFNULL(debit,0))-SUM(IFNULL(credit,0)) as bab')->where('transection_date', '<=', $rDate)->first();
		$advanced_paid = $advancepac->selectRaw('SUM(IFNULL(debit,0))-SUM(IFNULL(debit,0)) as apab')->where('transection_date', '<=', $rDate)->first();
		$advanced_received = $advancerac->selectRaw('SUM(IFNULL(credit,0))-SUM(IFNULL(debit,0)) as arb')->where('transection_date', '<=', $rDate)->first();
		$inventory = DB::select("SELECT SUM(ppl.cost_price*ppl.qty) as total_amount FROM `product_price_lists` as ppl");

		
		 $salesInfo = DB::select("SELECT  SUM(credit) as totalSales, SUM(debit) as TotalReturn  FROM sales_accounts ");
		 $salesDiscountInfo = DB::select("SELECT  SUM(debit - credit) as totalSalesDiscount  FROM sales_discount_accounts ");
		 $cogsinfo = DB::select("SELECT   SUM(debit - credit ) as cogsTotal  FROM costof_goods_sold_accounts ");
		$expinfo = DB::select("SELECT SUM(`debit`) as totalExp,SUM(`credit`) as totalExReverse FROM `expense_accounts` ");
		$totalExp = $expinfo[0]->totalExp;
		$totalExReverse = $expinfo[0]->totalExReverse;
		if ($totalExp == null) {
			$totalExp = 0;
		}
		if ($totalExReverse == null) {
			$totalExReverse = 0;
		}
		$total_sales = $salesInfo[0]->totalSales ?? 0;
		$cogsTotal = $cogsinfo[0]->cogsTotal ?? 0;
		$TotalReturn = $salesInfo[0]->TotalReturn ?? 0;
		$totalSalesDiscount = $salesDiscountInfo[0]->totalSalesDiscount ?? 0;
		$totalExp = $expinfo[0]->totalExp ?? 0;
		
		$net_income = ( $total_sales-($cogsTotal+$TotalReturn+$totalExp)+$totalExReverse );
		
		

		return view('report.balance_sheet', compact('accountspayable', 'accountsrecivale', 'cash', 'capital', 'bank', 'advanced_paid', 'advanced_received','inventory','net_income'));
	}

}
