<?php

namespace App\Http\Controllers;
use App\ProductProfile;
use App\SalesPrices;
use Illuminate\Http\Request;

//use App\CustomerCategory;
class ProductProfileController extends Controller {

	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_view')) {
			$crud = new \App\Library\Crud;
			$categories = $crud->Getvalue('ProductCategory');
			$measurments = $crud->Getvalue('ProductQuantityMeasurement');
			$info = ProductProfile::with('ProductCategory')->with('ProductQuantityMeasurement')->orderBy('id', 'DESC')->get();
			return view('product-profile.index', compact('info', 'categories', 'measurments'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_add')) {
			$request->validate([
				'name' => 'required',
				'Product_category_id' => 'required',
				'mesurement_id' => 'required',
			]);

			$crud = new \App\Library\Crud;
			$crud_result = $crud->InsertValue('ProductProfile', $request->all());

			$SalesPrices = new SalesPrices();
			$SalesPrices->product_id = $crud_result;
			$SalesPrices->save();

			if ($crud_result != null) {
				$collection = $library->add_element($request->all(), ['product_id' => $crud_result]);
				$crud->InsertValue('Inventory', $collection);
				$info = \App\ProductProfile::orderBy('id', 'DESC')->get();
				return view('product-profile.table', compact('info'));

			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_edit')) {
			$crud = new \App\Library\Crud;
			$categories = $crud->Getvalue('ProductCategory');
			$measurments = $crud->Getvalue('ProductQuantityMeasurement');
			$info = $crud->GetValueWhereSingle('ProductProfile', ['id', $id]);
			return view('product-profile.edit', compact('info', 'categories', 'measurments'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_edit')) {
			$request->validate([
				'name' => 'required',
				'Product_category_id' => 'required',
				'mesurement_id' => 'required',
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'ProductProfile', ['id', $request->id]);
			return redirect('product-profile')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('ProductProfile', ['id', $id]);
			return redirect('product-profile')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}
