<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ProductPricelistController extends Controller {
	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_delete')) {
			$product_price = new \App\ProductPriceList;
			$info = $product_price->GetPricelistedProduct();
			return view('product-price-list.index', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_edit')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('ProductPriceList', ['id', $id]);
			return view('product-price-list.edit', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_edit')) {
			$request->validate([
				'sales_price' => 'required',

			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'ProductPriceList', ['id', $request->id]);
			return redirect('product-price-list')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

}
