<?php

namespace App\Http\Controllers;

use App\CashBook;
use App\Inventory;
use App\ProductCategory;
use App\ProductPriceList;
use App\ProductQuantityMeasurement;
use App\PurchaseAccounts;
use App\PurchaseDetail;
use App\PurchaseDiscountAccount;
use App\PurchaseOrder;
use App\PurchaseReturnOrder;
use App\PurchaseTempTable;
use App\PurchaseVatAccount;
use App\SupplierAccount;
use App\SupplierCategory;
use App\SupplierProfile;
use App\TransactionTerm;
use Auth;
use Carbon\Carbon;
use DateTime;
use DateTimezone;
use DB;
use Illuminate\Http\Request;
use Session;
use App\SettingOption;
use App\AccountVoucherMaster;
use App\AccountLedger;
use App\AccountDetail;

class ProductOrderController extends Controller {

	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			$pre_order_no = PurchaseOrder::select('order_id')->where('order_type', '=', 'purchase')->orderBy('id', 'DESC')->first();
			//$supliers = SupplierProfile::get();
			$supliers = [];
			$payments = TransactionTerm::get();
			$product_category = ProductCategory::get();
			$supplier_category = SupplierCategory::get();
			$mesaurment = ProductQuantityMeasurement::get();
			$crud = new \App\Library\Crud;
			$info = PurchaseTempTable::where('status', 1)->where('employee_id', Auth::user()->id)->with('Product')->get();
			//$info = $crud->GetValueWhereSingle('PurchaseTempTable', ['employee_id', Auth::user()->id], true);
			return view('purchase-order.index', compact('supliers', 'payments', 'pre_order_no', 'info', 'product_category', 'mesaurment', 'supplier_category'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function supplier_for_purchase(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			//$SupplierProfile = new SupplierProfile();
			//$SupplierProfile = SupplierProfile::where('id', '!=', 0)->get();
			$SupplierProfile = DB::table('account_details')->select('id','name')->where('name', 'LIKE', "%$request->search_text%")->whereIn('ad_al2_id',[1,40])->take(10)->get();
			return json_encode($SupplierProfile);
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function purchasePreorder() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			$pre_order_no = PurchaseOrder::select('order_id')->where('order_type', '=', 'purchase')->orderBy('id', 'DESC')->first();
			$supliers = [];
			$payments = TransactionTerm::get();
			$supplier_category = SupplierCategory::get();
			$product_category = ProductCategory::get();
			$mesaurment = ProductQuantityMeasurement::get();
			$crud = new \App\Library\Crud;
			$info = PurchaseTempTable::where('status', 2)->where('employee_id', Auth::user()->id)->with('Product')->get();
			//$info = $crud->GetValueWhereSingle('PurchaseTempTable', ['employee_id', Auth::user()->id], true);
			return view('purchase-order.preoder', compact('supliers', 'payments', 'pre_order_no', 'info', 'product_category', 'mesaurment', 'supplier_category'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function opening_inventory() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {
			$pre_order_no = PurchaseOrder::select('order_id')->where('order_type', '=', 'purchase')->orderBy('id', 'DESC')->first();
			$productProfile = DB::table('product_profiles')->select('id', 'name')->get();
			$product_category = ProductCategory::get();
			$mesaurment = ProductQuantityMeasurement::get();
			$payments = TransactionTerm::get();
			$crud = new \App\Library\Crud;
			//$info = PurchaseTempTable::where('employee_id', Auth::user()->id)->with('ProductProfile')->first();
			$info = $crud->GetValueWhereSingle('PurchaseTempTable', ['employee_id', Auth::user()->id], true);
			return view('purchase-order.opening_inventory', compact('payments', 'pre_order_no', 'info', 'productProfile', 'product_category', 'mesaurment'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function search(Request $request) {
		$searchItem = $request->dataPass ?? '';
		$search_result = DB::table('product_profiles')->where('name', 'LIKE', "%$searchItem%")
			->get();
		return json_encode($search_result);
	}

	public function search_product_order(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			$search_result = DB::table('product_profiles')
				->get();
			return json_encode($search_result);
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function insert_into_temp(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {

			$crud = new \App\Library\Crud;
			if ($request->bq_id != null) {
				$check_ubk = $crud->GetValueWhereSingle('PurchaseTempTable', ['barcode', $request->bq_id]);
				$check_ubk2 = $crud->GetValueWhereSingle('ProductPriceList', ['barcode', $request->bq_id]);
			} else {
				$check_ubk = null;
				$check_ubk2 = null;
			}
			if (empty($check_ubk) && empty($check_ubk2)) {
				$collection = $library->remove_element($request, ['product_id_for_temp', 'bq_id', 'bq_qty', 'bq_price', 'bq_vat', 'bq_discount']);
				$collection = $library->add_element($collection, ['barcode' => $request->bq_id, 'product_id' => $request->product_id_for_temp, 'qty' => $request->bq_qty, 'employee_id' => Auth::user()->id, 'cost_price' => $request->bq_price, 'vat_rate' => $request->bq_vat, 'discount_rate' => $request->bq_discount, 'gross_amount' => $request->gross_total, 'gross_discount' => $request->discount_total, 'status' => $request->status]);
				$crud_result = $crud->InsertValue('PurchaseTempTable', $collection, true);

				if (!empty($crud_result)) {
					return json_encode($crud_result);
				} else {
					return 2;
				}
			} else {
				return 2;
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	//pre order invoice wise received
	public function preorder_receive(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {

			$payments = TransactionTerm::get();
			$crud = new \App\Library\Crud;
			$purchase_orders = DB::table('purchase_orders')
				->join('supplier_profiles', 'purchase_orders.supplier_Id', '=', 'supplier_profiles.id')
				->where('purchase_orders.id', $id)->where('purchase_orders.order_type', 'pre_order')->first();
			//dump($purchase_orders);die();

			$purchase_details = DB::table('purchase_details')
				->join('product_profiles', 'product_profiles.id', '=', 'purchase_details.product_id')
				->where('order_id', $id)->get();
			$product_category = ProductCategory::get();
			$mesaurment = ProductQuantityMeasurement::get();
			$supliers = SupplierProfile::where('id', $purchase_orders->supplier_Id)->first();
			//$info = $crud->GetValueWhereSingle('PurchaseTempTable', ['employee_id', Auth::user()->id], true);
			return view('purchase-order.preoder_receive', compact('payments', 'purchase_orders', 'supliers', 'purchase_details', 'id', 'product_category', 'mesaurment'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	//individual Proudct added in preorder table
	public function addSinglePreOrder(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {
			$PurchaseTempTable = new PurchaseTempTable();
			$PurchaseTempTable->product_id = $request->product_id;
			$PurchaseTempTable->qty = $request->qty;
			$PurchaseTempTable->cost_price = $request->price;
			$PurchaseTempTable->status = $request->status;
			$PurchaseTempTable->employee_id = Auth::user()->id;

			$PurchaseTempTable->save();
			Session::flash('message', 'Proudct Added To Order Table Successfully in Qty : ' . $request->qty . '  ! ');
			return redirect('reorder');
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function deleteTemp($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_delete')) {
			$crud = new \App\Library\Crud;
			$result = $crud->DeleteValueWhereSingle('PurchaseTempTable', ['id', $id]);
			return 'done';
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function deleteTempFromOpeningItem($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_delete')) {
			$crud = new \App\Library\Crud;
			$result = $crud->DeleteValueWhereSingle('PurchaseTempTable', ['id', $id]);
			return redirect()->back();
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function purchse_preorder(Request $request) {

		/*$price_info_array = array();
			$product_pricelist_id = array();
			$available_product = Inventory::where('id', $request->id)->first();
			if (!empty($available_product)) {
				if ($available_product->available >= $request->quantity) {
					$price_info = ProductPriceList::where('product_id', $request->id)->where('status', 1)->where('qty', '>', 0)->orderBy('order_id', 'ASC')->first();
					array_push($price_info_array, $price_info);
					$available_quantity = $price_info->qty;
					do {
						array_push($product_pricelist_id, $price_info->id);
						if ($available_quantity < $request->quantity) {
							$price_info_two = ProductPriceList::where('product_id', $request->id)->whereNotIn('id', $product_pricelist_id)->where('status', 1)->where('qty', '>', 0)->orderBy('order_id', 'ASC')->first();
							array_push($price_info_array, $price_info_two);
							array_push($product_pricelist_id, $price_info_two->id);
							$available_quantity = $available_quantity + $price_info_two->qty;
						}
					} while ($available_quantity < $request->quantity);

				}
			}
		*/

	}

	public function product_add(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {
			$product_id = $request->id;
			$search_result = DB::table('product_profiles')->where('id', $product_id)->first();
			echo json_encode($search_result);
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function preorder_receive_confirm(Request $request) {

		$request->payment_amount = floatval($request->payment_amount);
		$request->gross_amount = floatval($request->gross_amount);
		$request->gross_discount = floatval($request->gross_discount);
		$request->gross_vat_amount = floatval($request->gross_vat_amount);
		$request->net_amount = floatval($request->net_amount);
		$request->Due_amount = floatval($request->Due_amount);
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {
			DB::beginTransaction();
			try {

				if ($request->suplier == '' || $request->product_id == '') {
					return redirect()->back();
				}
				if ($request->suplier == '000') {
					$suplier = '000';
				} else {
					$suplier = $request->suplier;
				}

				$date = $request->purchase_date;
				$order = PurchaseOrder::firstOrCreate(['supplier_Id' => $suplier, 'gross_amount' => $request->gross_amount, 'ref_no' => $request->ref_no, 'order_date' => $date, 'net_amount' => $request->net_amount, 'payment_amount' => $request->payment_amount, 'gross_discount' => $request->gross_discount, 'transection_type' => $request->transection_term_id, 'order_type' => 'purchase', 'preorder_ref' => $request->preorder_ref, 'pre_order_status' => 'done', 'gross_vat_amount' => $request->gross_vat_amount, 'employee_id' => Auth::user()->id, 'initial_payment' => $request->payment_amount]);

				if (!empty($order)) {
					$order_id = $order->id;
				} else {
					return 'something went to wrong';
				}

				if ($request->product_id != '') {
					for ($i = 0; $i < count($request->product_id); $i++) {
						//$request->qty[$i] = floatval($request->qty[$i]);
						//$request->l_gross_cost_price[$i] = floatval($request->l_gross_cost_price[$i]);
						//$request->net_cost_price[$i] = floatval($request->net_cost_price[$i]);
						//$request->vat_rate[$i] = floatval($request->vat_rate[$i]);
						//$request->discount_rate[$i] = floatval($request->discount_rate[$i]);
						//$request->net_line_total[$i] = floatval($request->net_line_total[$i]);

						$PurchaseDetail = new PurchaseDetail();
						$PurchaseDetail->product_id = $request->product_id[$i];
						$PurchaseDetail->order_id = $order_id;
						$PurchaseDetail->qty = $request->qty[$i];
						$PurchaseDetail->l_gross_cost_price = $request->l_gross_cost_price[$i];
						$PurchaseDetail->price = $request->net_cost_price[$i];
						$PurchaseDetail->vat_rate = $request->vat_rate[$i];
						$PurchaseDetail->discount_rate = $request->discount_rate[$i];
						$PurchaseDetail->line_total = $request->net_line_total[$i];
						$PurchaseDetail->note = $request->note;
						$PurchaseDetail->save();
						$lastinsert_id = $PurchaseDetail->id;
						//data insert into purchase vat Accounts table
						$vatRate = $request->vat_rate[$i];
						if ($vatRate == null) {
							$vatRate = 0;
						}
						$disRate = $request->discount_rate[$i];
						if ($disRate == null) {
							$disRate = 0;
						}

						$qty = $request->qty[$i];
						$grossTotal = $request->cost_price[$i] * $qty;
						$lineDisTotal = ($grossTotal * $disRate) / 100;
						$vatChargeAbleAmount = $grossTotal - $lineDisTotal;
						$lineVatTotal = ($vatChargeAbleAmount * $vatRate) / 100;

						$PurchaseVatAccount = new PurchaseVatAccount();
						$PurchaseVatAccount->order_id = $order_id;
						$PurchaseVatAccount->account_no = $request->product_id[$i];
						$PurchaseVatAccount->transection_date = $date;
						$PurchaseVatAccount->debit = $lineVatTotal;
						$PurchaseVatAccount->created_by = Auth::user()->id;
						$PurchaseVatAccount->save();

						$PurchaseDiscountAccount = new PurchaseDiscountAccount();
						$PurchaseDiscountAccount->order_id = $order_id;
						$PurchaseDiscountAccount->account_no = $request->product_id[$i];
						$PurchaseDiscountAccount->transection_date = $date;
						$PurchaseDiscountAccount->credit = $lineDisTotal;
						$PurchaseDiscountAccount->created_by = Auth::user()->id;
						$PurchaseDiscountAccount->save();

						//product price list table

						if ($request->vat_rate[$i] == '') {
							$request->vat_rate[$i] = 0;
						}
						if ($request->discount_rate[$i] == '') {
							$request->discount_rate[$i] = 0;
						}
						$ProductPriceList = new \App\ProductPriceList();
						$ProductPriceList->order_id = $order_id;
						$ProductPriceList->product_id = $request->product_id[$i];
						$ProductPriceList->name = $request->name[$i];
						$ProductPriceList->barcode = $request->barcode[$i];
						$ProductPriceList->vat_rate = $request->vat_rate[$i];
						$ProductPriceList->discount_rate = $request->discount_rate[$i];
						$ProductPriceList->employee_id = Auth::user()->id;
						$ProductPriceList->cost_price = $request->net_cost_price[$i];
						$ProductPriceList->qty = $request->qty[$i];
						$ProductPriceList->sales_price = $request->sales_price[$i];
						$ProductPriceList->purchase_details_ref = $lastinsert_id;
						$ProductPriceList->save();

						$Inventory = new \App\Inventory();
						$Inventories = \App\Inventory::where('product_id', $request->product_id[$i])->first();
						if (empty($Inventories)) {
							$Inventory->product_id = $request->product_id[$i];
							$Inventory->received = $request->qty[$i];
							$Inventory->available = $request->qty[$i];
							$Inventory->save();
						} else {
							$received_amount = $Inventories->received;
							$available = $Inventories->available;
							DB::table('inventories')
								->where('product_id', $request->product_id[$i])
								->update(['received' => $received_amount + $request->qty[$i], 'available' => $available + $request->qty[$i]]);
						}

					}
					//insert data to purchase Account Table
					$PurchaseAccounts = new PurchaseAccounts();
					$PurchaseAccounts->order_id = $order_id;
					$PurchaseAccounts->account_no = $request->suplier;
					$PurchaseAccounts->transection_date = $date;
					$PurchaseAccounts->debit = $request->gross_amount;
					//$PurchaseAccounts->note = $request->common_notes;
					$PurchaseAccounts->created_by = Auth::user()->id;
					$PurchaseAccounts->save();
				}

				if ($order_id != '') {
					$SupplierAccount = new \App\SupplierAccount();
					$SupplierAccount->account_no = $suplier;
					$SupplierAccount->transection_no = $order_id;
					$SupplierAccount->transection_date = $date;
					$SupplierAccount->credit = $request->net_amount;

					if ($request->payment_amount > 0) {
						$SupplierAccount->debit = $request->payment_amount;
					}
					$SupplierAccount->created_by = Auth::user()->id;

					$SupplierAccount->save();

				}

				if ($request->payment_amount > 0) {
					$CashBook = new \App\CashBook();
					//$CashBook->account_no = $suplier;
					$CashBook->account_no = $request->cash_book ?? 1;
					$CashBook->own_account_no = $suplier;

					$CashBook->refeance_no = $order_id;
					$CashBook->transection_date = $date;
					$CashBook->credit = $request->payment_amount;
					$CashBook->description = $request->note;
					$CashBook->person_type = 'supplier';
					$CashBook->created_by = Auth::user()->id;
					$CashBook->save();

				}

				if ($request->preorder_ref != '') {
					DB::table('purchase_orders')
						->where('id', $request->preorder_ref)
						->update(['status' => 1]);
				}
				DB::commit();
				Session::flash('message', 'Product received confirm !');
				return redirect('preorder-invoice');
			} catch (Exception $e) {
				DB::rollBack();
				return $e->getMessage();
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function purchaseReturn() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			return view('purchase-order.return');
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function purchaseReturnInvoice(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			$id = $request->searchInvoice;
			if ($id != '') {
				$returnCheck = DB::table('purchase_orders')->where('return_ref', '=', $id)->first();
				if (!empty($returnCheck)) {
					Session::flash('errormessage', 'You Can not Return Product More Then One Time !');
					return redirect('purchase-return');

				} else {
					$purchaseorder = new PurchaseOrder();
					$porder = $purchaseorder->with('SupplierProfileLimit')->where('id', $id)->where('order_type', '=', 'purchase')->first();

				}

			}

			if ($porder != null) {
			 	$porder_details = DB::select(DB::raw("SELECT purchase_details.*,product_profiles.name as product_name,product_price_lists.barcode as bqcode,product_price_lists.qty as pqty from purchase_details
INNER JOIN purchase_orders on purchase_details.order_id=purchase_orders.id
INNER JOIN product_profiles  on purchase_details.product_id=product_profiles.id
INNER JOIN supplier_profiles on purchase_orders.supplier_Id=supplier_profiles.id
INNER JOIN product_price_lists on purchase_details.order_id=product_price_lists.order_id  where purchase_orders.order_type='purchase' AND purchase_orders.id=$id AND purchase_details.product_id=product_price_lists.product_id AND product_price_lists.purchase_details_ref=purchase_details.id AND purchase_details.price=product_price_lists.cost_price AND product_price_lists.qty>0"));
				if (count($porder_details) == 0) {
					return back()->with('errormessage', 'Unavailable quantity !');
				};
				return view('purchase-order.return_details', compact('porder', 'porder_details'));
			} else {
				Session::flash('message', 'Please Search with valid Invoice Number !');
				return redirect()->back();
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function purchaseReturnConfirm(Request $request) {

		//return $request->all();
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_edit')) {
			DB::beginTransaction();

			try {
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$Due_amount = floatval($request->Due_amount); // total due deduction
				$net_amount = floatval($request->net_amount); //net return amount
				$received_amount = floatval($request->received_amount); //net cash deduction amount
				$gross_amount = floatval($request->gross_amount); //gross deduct amount
				$gross_discount = floatval($request->gross_discount); //gross deducted discount amount
				$gross_vat_amount = floatval($request->gross_vat_amount); // gross deducted vat amount
				$initialdue = floatval($request->initialdue); //inital due
				$payment_net_amount = floatval($request->payment_net_amount); //same as total due deduction
				$userid = Auth::user()->id;
				$return_result = PurchaseReturnOrder::create([
					'return_order_id' => $request->order_id,
					'return_supplier_Id' => $request->supplier_id,
					'return_order_date' => $date,
					'return_gross_amount' => $gross_amount,
					'return_return_amount' => $net_amount,
					'return_gross_discount' => $gross_discount,
					'return_amount_received_supplier' => $received_amount,
					'return_return_ref' => $request->sup_ref_no,
					'return_transection_type' => $request->return_tansaction_type,
					'return_order_type' => 'purchase_return',
					'return_gross_vat_amount' => $gross_vat_amount,
					'return_employee_id' => $userid,
					'purchase_return_due' => ($net_amount - $received_amount),
					'return_note' => $request->note,
				]
				);

				//return $return_result;

				if (!empty($return_result)) {
					$return_order_id = $return_result->id;
					$purchaseOrder = new PurchaseOrder;
					$purOrder = $purchaseOrder->where('id', '=', $request->order_id)->first();
					if (!empty($purOrder)) {
						$purOrder->return_ref = $return_result->id;
						$purOrder->purchase_return = $request->net_amount;
						$purOrder->save();
					}

				} else {
					return 'something wrong';
				}

				// adjust to the purchase account table
				$PurchaseAccounts = new PurchaseAccounts();
				$PurchaseAccounts->order_id = $request->order_id;
				$PurchaseAccounts->account_no = $request->supplier_id;
				$PurchaseAccounts->transection_date = $date;
				$PurchaseAccounts->credit = $request->gross_amount;
				$PurchaseAccounts->note = $request->common_notes;
				$PurchaseAccounts->created_by = Auth::user()->id;
				$PurchaseAccounts->save();
				//adjust to the purchase return table

				$supplierAccounts = new SupplierAccount();
				$supplierAccounts->account_no = $request->supplier_id;
				$supplierAccounts->transection_no = $request->order_id;
				$supplierAccounts->transection_date = $date;
				$supplierAccounts->debit = $net_amount;
				if ($received_amount > 0) {
					$supplierAccounts->credit = $received_amount;
				}
				$supplierAccounts->description = $request->note;
				$supplierAccounts->created_by = $userid;
				$supplierAccounts->save();
				//insert all information to Sales Details Table
				if ($request->perchase_details_id != null) {
					for ($i = 0; $i < count($request->perchase_details_id); $i++) {
						$PurchaseDetail = new PurchaseDetail();
						$PurchaseDetail->order_id = $request->order_id;
						$PurchaseDetail->product_id = $request->product_id[$i];
						$PurchaseDetail->qty = $request->qty[$i];
						$PurchaseDetail->price = $request->unitgross_price[$i];
						$PurchaseDetail->vat_rate = $request->vat_rate[$i];
						$PurchaseDetail->discount_rate = $request->discount_rate[$i];
						$PurchaseDetail->line_total = $request->line_total[$i];
						$PurchaseDetail->l_gross_cost_price = ($request->unitgross_price[$i] * $request->qty[$i]);
						$PurchaseDetail->return_ref = $request->perchase_details_id[$i];
						$PurchaseDetail->return_order_id = $return_order_id;
						$PurchaseDetail->status = 0;
						$PurchaseDetail->save();
						//update Inventory table when add product in sales form
						$Inventory = new Inventory();
						$previous_allocated = $Inventory->where('product_id', '=', $request->product_id[$i])->first();
						if (!empty($previous_allocated)) {
							$previous_allocated->purchase_return = $previous_allocated->purchase_return + $request->qty[$i];
							$previous_allocated->available = $previous_allocated->available - $request->qty[$i];
							$previous_allocated->save();
						} else {
							return "Inventory table not updated";
						}

						$ProductPriceList = new ProductPriceList();
						$previous_list = $ProductPriceList->where('purchase_details_ref', $request->perchase_details_id[$i])->where('product_id', '=', $request->product_id[$i])->first();
						if (!empty($previous_list)) {
							$list_adjustment = $previous_list->qty - $request->qty[$i];
							$previous_list->qty = $list_adjustment;
							$previous_list->status = ($list_adjustment == 0) ? 0 : 1;
							$previous_list->save();
						}
						if ($request->discount_line_total[$i] > 0 && $request->discount_line_total[$i] != null) {
							$purchaseDiscountAccount = new PurchaseDiscountAccount();
							$purchaseDiscountAccount->order_id = $request->order_id;
							$purchaseDiscountAccount->account_no = $request->product_id[$i];
							$purchaseDiscountAccount->transection_date = $date;
							$purchaseDiscountAccount->debit = $request->discount_line_total[$i];
							$purchaseDiscountAccount->created_by = $userid;
							$purchaseDiscountAccount->save();
						}

						if ($request->vat_line_total[$i] > 0 && $request->vat_line_total[$i] != null) {
							$VatAccounts = new PurchaseVatAccount();
							$VatAccounts->order_id = $request->order_id;
							$VatAccounts->account_no = $request->product_id[$i];
							$VatAccounts->transection_date = $date;
							$VatAccounts->credit = $request->vat_line_total[$i];
							$VatAccounts->created_by = $userid;
							$VatAccounts->save();
						}

					}
				}
				$options = SettingOption::first();
				if($options->s_amount_receive_ledger ==0){
					$s_amount_receive_ledger = $options->s_default_cash_ledger ?? 2; //Defalut Cash Account
				}else{
					$s_amount_receive_ledger = $options->s_amount_receive_ledger ?? 2;  //Defalut Cash Account
				}
				
				$s_inventory_ledger = $options->s_inventory_ledger ?? 6; //default inventory accounts
				
				$p_default_discount_account = $options->p_default_discount_account ?? 9; //default discount accounts
				$s_default_vat_input_ledger = $options->s_default_vat_input_ledger ?? 14; //default inventory accounts
				$vat_expense_account = $options->vat_expense_account ?? 11; //default inventory accounts

				$suplier = $request->supplier_id;
				$order_id = $return_order_id;

				$voucher_number = AccountVoucherMaster::count();
		    	$voucher_number= ($voucher_number+1);
		    	if(strlen($voucher_number)==1){
		    		$voucher_number = "0".$voucher_number;
		    	}
		    	$vm_user = Auth::user()->name ?? '';
		    	$vm_no= date('Y')."-".$voucher_number;
		    	$AccountVoucherMaster = new AccountVoucherMaster();
		    	$AccountVoucherMaster->vm_no = $vm_no;
		    	$AccountVoucherMaster->vm_date =  $request->purchase_date ??  date('Y-m-d H:i:s');
		    	$AccountVoucherMaster->vm_type = 'JV' ;
		    	$AccountVoucherMaster->vm_naration = $request->note ?? '';
		    	$AccountVoucherMaster->vm_user = $vm_user;
		    	$AccountVoucherMaster->vm_post_flag = 1;
		    	$AccountVoucherMaster->vm_no_id = $order_id;
		    	$AccountVoucherMaster->vm_amount = $request->gross_amount ?? 0;
		    	$AccountVoucherMaster->status = $request->status ?? 1;
		    	$AccountVoucherMaster->save();

		    	//Inventory Account Debit Amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->note ?? '';
		    	$AccountLedger->lg_ad_id = $s_inventory_ledger ?? '';
		    	$AccountLedger->lg_dr_amt =  0;
		    	$AccountLedger->lg_cr_amt =$request->gross_amount ??  0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->note ?? '';
		    	$AccountLedger->save();

		    	//Supplier Account Credit Amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->note ?? '';
		    	$AccountLedger->lg_ad_id = $suplier ?? '';
		    	$AccountLedger->lg_dr_amt =$request->gross_amount ??  0;
		    	$AccountLedger->lg_cr_amt =  0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->note ?? '';
		    	$AccountLedger->save();

		    	//if paid cash for purchase
		    	if($request->cash_received > 0 ){
			    		//Supplier Account Debit with cash Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->note ?? '';
				    	$AccountLedger->lg_ad_id = $suplier ?? '';
				    	$AccountLedger->lg_dr_amt = 0;
				    	$AccountLedger->lg_cr_amt =$request->cash_received ??  0;
				    	$AccountLedger->lg_data_flag = 2;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->note ?? '';
				    	$AccountLedger->save();

				    	//Cash Account Credit with cash Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->note ?? '';
				    	$AccountLedger->lg_ad_id = $s_amount_receive_ledger ?? '';
				    	$AccountLedger->lg_dr_amt =$request->cash_received ?? 0;
				    	$AccountLedger->lg_cr_amt =  0;
				    	$AccountLedger->lg_data_flag = 2;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->note ?? '';
				    	$AccountLedger->save();


		    	}
 				//if discount for purchase
		    	if($request->gross_discount > 0 ){
			    		//Supplier Account Debit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->note ?? '';
				    	$AccountLedger->lg_ad_id = $suplier ?? '';
				    	$AccountLedger->lg_dr_amt = 0;
				    	$AccountLedger->lg_cr_amt = $request->gross_discount ?? 0;
				    	$AccountLedger->lg_data_flag = 3;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->note ?? '';
				    	$AccountLedger->save();

				    	//Discount Account Credit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->note ?? '';
				    	$AccountLedger->lg_ad_id = $p_default_discount_account ?? '';
				    	$AccountLedger->lg_dr_amt =$request->gross_discount ?? 0;
				    	$AccountLedger->lg_cr_amt =  0;
				    	$AccountLedger->lg_data_flag = 3;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->note ?? '';
				    	$AccountLedger->save();
		    	}

		    	//if discount for purchase
		    	if($request->gross_vat_amount > 0 ){
			    		//Supplier Account Debit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->note ?? '';
				    	$AccountLedger->lg_ad_id = $vat_expense_account ?? '';
				    	$AccountLedger->lg_dr_amt = 0;
				    	$AccountLedger->lg_cr_amt = $request->gross_vat_amount ?? 0;
				    	$AccountLedger->lg_data_flag = 4;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->note ?? '';
				    	$AccountLedger->save();

				    	//Discount Account Credit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->note ?? '';
				    	$AccountLedger->lg_ad_id = $s_default_vat_input_ledger ?? '';
				    	$AccountLedger->lg_dr_amt =$request->gross_vat_amount ?? 0;
				    	$AccountLedger->lg_cr_amt =  0;
				    	$AccountLedger->lg_data_flag = 4;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->note ?? '';
				    	$AccountLedger->save();
		    	}

				// if ($received_amount > 0) {
				// 	$CashBook = new CashBook();
				// //	$CashBook->account_no = $request->supplier_id;

				// 	$CashBook->account_no = $request->cash_book ?? 1;
				// 	$CashBook->own_account_no =  $request->supplier_id;

				// 	$CashBook->refeance_no = $request->order_id;
				// 	$CashBook->transection_date = $date;
				// 	$CashBook->debit = $received_amount;
				// 	$CashBook->description = $request->note;
				// 	$CashBook->person_type = 'supplier';
				// 	$CashBook->created_by = $userid;
				// 	$CashBook->save();
				// }
				DB::commit();
				Session::flash('message', 'Purchase return has been completed !');
				return redirect('purchase-return-list');
			} catch (Exception $e) {
				DB::rollBack();
				echo 'Caught exception: ', $e->getMessage(), "\n";
			}

		} else {
			return "Sorry you don't have access to this action";
		}

		///
	}

	public function PurchaseReturnList(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$start_strtotime = strtotime("$start_date 00:00:00");
			$end_strtotime = strtotime("$end_date 23:59:59");
			$start_time = date('Y-m-d H:i:s', $start_strtotime);
			$end_time = date('Y-m-d H:i:s', $end_strtotime);

			$info = PurchaseReturnOrder::whereBetween('created_at', [$start_time, $end_time])->with('Supplier')->orderBy('id', 'DESC')->get();
			return view('purchase-order.returnInvoiceList', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function returnInvoiceDetails($id, $ref = null) {

		$returnItem = DB::table('purchase_retrun_orders')->where('id', $id)->first();
		$order_id = $returnItem->return_order_id;
		$PurchaseReturnOrder = new PurchaseReturnOrder();
		$info = $PurchaseReturnOrder->GetReturnPurchaseDetails($id);
		$returnItem = PurchaseDetail::with('ProductProfile')->where('return_order_id', $id)->where('status', 0)->get();

		return view('purchase-order.return_invoice', compact('info', 'returnItem'));

	}

	public function process_order(Request $request) {
		//return dump($request->all());exit();
		//return $request->all();
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {

			for ($j = 0; $j < count($request->qty); $j++) {
				if ($request->qty[$j] == 0 || $request->qty[$j] == null) {
					Session::flash('error_message', 'You Can not Purchase  0 Qty Product !)');
					return redirect()->back();
				}
			}

			if ($request->suplier == '' || $request->product_id == '') {
				Session::flash('error_message', 'You Must Need Add Product !');
				return redirect()->back();
			}
			if ($request->suplier == '000') {
				$suplier = 0;
			} else {
				$suplier = $request->suplier;
			}


				$options = SettingOption::first();
				if($options->s_amount_receive_ledger ==0){
					$s_amount_receive_ledger = $options->s_default_cash_ledger ?? 2; //Defalut Cash Account
				}else{
					$s_amount_receive_ledger = $options->s_amount_receive_ledger ?? 2;  //Defalut Cash Account
				}
				
				$s_inventory_ledger = $options->s_inventory_ledger ?? 6; //default inventory accounts
				
				$p_default_discount_account = $options->p_default_discount_account ?? 9; //default discount accounts
				$s_default_vat_input_ledger = $options->s_default_vat_input_ledger ?? 14; //default inventory accounts
				$vat_expense_account = $options->vat_expense_account ?? 11; //default inventory accounts



			$date = $request->purchase_date;
			//order date  change  from date as per client  requirement
			$order = PurchaseOrder::firstOrCreate(['supplier_Id' => $suplier, 'gross_amount' => $request->gross_amount, 'ref_no' => $request->ref_no, 'order_date' => $date, 'net_amount' => $request->net_amount, 'payment_amount' => $request->payment_amount, 'gross_discount' => $request->gross_discount, 'transection_type' => $request->transection_term_id, 'order_type' => 'purchase', 'preorder_ref' => $request->preorder_ref, 'pre_order_status' => 'done', 'gross_vat_amount' => $request->gross_vat_amount, 'employee_id' => Auth::user()->id, 'initial_payment' => $request->payment_amount]);
			$order_id = $order->id;
			if (!empty($order)) {
				$order_id = $order->id;
			} else {
				return 'something went to wrong';
			}

			if ($request->product_id != '') {
				for ($i = 0; $i < count($request->product_id); $i++) {
					$PurchaseDetail = new PurchaseDetail();
					$PurchaseDetail->product_id = $request->product_id[$i];
					$PurchaseDetail->order_id = $order_id;
					$PurchaseDetail->qty = $request->qty[$i];
					$PurchaseDetail->l_gross_cost_price = $request->l_gross_cost_price[$i];
					$PurchaseDetail->price = $request->net_cost_price[$i];
					$PurchaseDetail->vat_rate = $request->vat_rate[$i];
					$PurchaseDetail->discount_rate = $request->discount_rate[$i];
					$PurchaseDetail->line_total = $request->net_line_total[$i];
					$PurchaseDetail->note = $request->note;
					$PurchaseDetail->save();
					$lastinsert_id = $PurchaseDetail->id;

					//data insert into purchase vat Accounts table
					$vatRate = $request->vat_rate[$i];
					if ($vatRate == null) {
						$vatRate = 0;
					}
					$disRate = $request->discount_rate[$i];
					if ($disRate == null) {
						$disRate = 0;
					}

					$qty = $request->qty[$i];
					$grossTotal = $request->cost_price[$i] * $qty;
					$lineDisTotal = ($grossTotal * $disRate) / 100;
					$vatChargeAbleAmount = $grossTotal - $lineDisTotal;
					$lineVatTotal = ($vatChargeAbleAmount * $vatRate) / 100;

					$PurchaseVatAccount = new PurchaseVatAccount();
					$PurchaseVatAccount->order_id = $order_id;
					$PurchaseVatAccount->account_no = $request->product_id[$i];
					$PurchaseVatAccount->transection_date = $date;
					$PurchaseVatAccount->debit = $lineVatTotal;
					$PurchaseVatAccount->created_by = Auth::user()->id;
					$PurchaseVatAccount->save();

					$PurchaseDiscountAccount = new PurchaseDiscountAccount();
					$PurchaseDiscountAccount->order_id = $order_id;
					$PurchaseDiscountAccount->account_no = $request->product_id[$i];
					$PurchaseDiscountAccount->transection_date = $date;
					$PurchaseDiscountAccount->credit = $lineDisTotal;
					$PurchaseDiscountAccount->created_by = Auth::user()->id;
					$PurchaseDiscountAccount->save();

					//product price list table

					$vat_rate = $request->vat_rate[$i];

					if ($vat_rate == '') {
						//return $request->vat_rate[$i];
						$vat_rate = 0;
					}
					$discount_rate = $request->discount_rate[$i];
					if ($discount_rate == '') {
						$discount_rate = 0;
					}
					$ProductPriceList = new \App\ProductPriceList();
					$ProductPriceList->order_id = $order_id;
					$ProductPriceList->product_id = $request->product_id[$i];
					$ProductPriceList->name = $request->name[$i];
					$ProductPriceList->barcode = $request->barcode[$i];
					$ProductPriceList->name = $request->name[$i];
					$ProductPriceList->vat_rate = $vat_rate;
					$ProductPriceList->discount_rate = $discount_rate;
					$ProductPriceList->employee_id = Auth::user()->id;
					$ProductPriceList->cost_price = $request->net_cost_price[$i];
					$ProductPriceList->qty = $request->qty[$i];
					$ProductPriceList->sales_price = $request->sales_price[$i];
					$ProductPriceList->purchase_details_ref = $lastinsert_id;
					$ProductPriceList->save();

					// inventory adjustment

					$Inventory = new \App\Inventory();
					$Inventories = \App\Inventory::where('product_id', $request->product_id[$i])->first();
					if (empty($Inventories)) {
						$Inventory->product_id = $request->product_id[$i];
						$Inventory->received = $request->qty[$i];
						$Inventory->available = $request->qty[$i];
						$Inventory->save();
					} else {
						$received_amount = $Inventories->received;
						$available = $Inventories->available;
						DB::table('inventories')
							->where('product_id', $request->product_id[$i])
							->update(['received' => $received_amount + $request->qty[$i], 'available' => $available + $request->qty[$i]]);
					}

				}

			}

			//insert data to purchase Account Table
			$PurchaseAccounts = new PurchaseAccounts();
			$PurchaseAccounts->order_id = $order_id;
			$PurchaseAccounts->account_no = $request->suplier;
			$PurchaseAccounts->transection_date = $date;
			$PurchaseAccounts->debit = $request->gross_amount;
			$PurchaseAccounts->note = $request->common_notes ?? '';
			$PurchaseAccounts->created_by = Auth::user()->id;
			$PurchaseAccounts->save();

			$voucher_number = AccountVoucherMaster::count();
		    	$voucher_number= ($voucher_number+1);
		    	if(strlen($voucher_number)==1){
		    		$voucher_number = "0".$voucher_number;
		    	}
		    	$vm_user = Auth::user()->name ?? '';
		    	$vm_no= date('Y')."-".$voucher_number;
		    	$AccountVoucherMaster = new AccountVoucherMaster();
		    	$AccountVoucherMaster->vm_no = $vm_no;
		    	$AccountVoucherMaster->vm_date =  $request->purchase_date ??  date('Y-m-d H:i:s');
		    	$AccountVoucherMaster->vm_type = 'JV' ;
		    	$AccountVoucherMaster->vm_naration = $request->common_notes ?? '';
		    	$AccountVoucherMaster->vm_user = $vm_user;
		    	$AccountVoucherMaster->vm_post_flag = 1;
		    	$AccountVoucherMaster->vm_no_id = $order_id;
		    	$AccountVoucherMaster->vm_amount = $request->gross_amount ?? 0;
		    	$AccountVoucherMaster->status = $request->status ?? 1;
		    	$AccountVoucherMaster->save();

		    	//Inventory Account Debit Amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
		    	$AccountLedger->lg_ad_id = $s_inventory_ledger ?? '';
		    	$AccountLedger->lg_dr_amt = $request->gross_amount ?? 0;
		    	$AccountLedger->lg_cr_amt =  0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->common_notes ?? '';
		    	$AccountLedger->save();

		    	//Supplier Account Credit Amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
		    	$AccountLedger->lg_ad_id = $suplier ?? '';
		    	$AccountLedger->lg_dr_amt = 0;
		    	$AccountLedger->lg_cr_amt = $request->gross_amount ??  0;
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $request->common_notes ?? '';
		    	$AccountLedger->save();

		    	//if paid cash for purchase
		    	if($request->payment_amount > 0 ){
			    		//Supplier Account Debit with cash Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
				    	$AccountLedger->lg_ad_id = $suplier ?? '';
				    	$AccountLedger->lg_dr_amt =$request->payment_amount ?? 0;
				    	$AccountLedger->lg_cr_amt =  0;
				    	$AccountLedger->lg_data_flag = 2;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->common_notes ?? '';
				    	$AccountLedger->save();

				    	//Cash Account Credit with cash Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
				    	$AccountLedger->lg_ad_id = $s_amount_receive_ledger ?? '';
				    	$AccountLedger->lg_dr_amt = 0;
				    	$AccountLedger->lg_cr_amt = $request->payment_amount ?? 0;
				    	$AccountLedger->lg_data_flag = 2;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->common_notes ?? '';
				    	$AccountLedger->save();


		    	}
 				//if discount for purchase
		    	if($request->gross_discount > 0 ){
			    		//Supplier Account Debit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
				    	$AccountLedger->lg_ad_id = $suplier ?? '';
				    	$AccountLedger->lg_dr_amt =$request->gross_discount ?? 0;
				    	$AccountLedger->lg_cr_amt =  0;
				    	$AccountLedger->lg_data_flag = 3;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->common_notes ?? '';
				    	$AccountLedger->save();

				    	//Discount Account Credit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
				    	$AccountLedger->lg_ad_id = $p_default_discount_account ?? '';
				    	$AccountLedger->lg_dr_amt = 0;
				    	$AccountLedger->lg_cr_amt = $request->gross_discount ?? 0;
				    	$AccountLedger->lg_data_flag = 3;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->common_notes ?? '';
				    	$AccountLedger->save();
		    	}

		    	//if discount for purchase
		    	if($request->gross_vat_amount > 0 ){
			    		//Supplier Account Debit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
				    	$AccountLedger->lg_ad_id = $vat_expense_account ?? '';
				    	$AccountLedger->lg_dr_amt =$request->gross_vat_amount ?? 0;
				    	$AccountLedger->lg_cr_amt =  0;
				    	$AccountLedger->lg_data_flag = 4;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->common_notes ?? '';
				    	$AccountLedger->save();

				    	//Discount Account Credit with discount Amount 
				    	$AccountLedger = new AccountLedger();
				    	$AccountLedger->lg_voucher_date = $request->purchase_date ??  date('Y-m-d H:i:s');
				    	$AccountLedger->lg_voucher_no = $vm_no;
				    	$AccountLedger->lg_particulars = $request->common_notes ?? '';
				    	$AccountLedger->lg_ad_id = $s_default_vat_input_ledger ?? '';
				    	$AccountLedger->lg_dr_amt = 0;
				    	$AccountLedger->lg_cr_amt = $request->gross_vat_amount ?? 0;
				    	$AccountLedger->lg_data_flag = 4;
				    	$AccountLedger->lg_voucher_type = 'JV' ;
				    	$AccountLedger->lg_usr = $vm_user;
				    	$AccountLedger->lg_vd_sm_id =$order_id;
				    	$AccountLedger->lg_naration = $request->common_notes ?? '';
				    	$AccountLedger->save();
		    	}



		    	

			// if ($order_id != '') {
			// 	$SupplierAccount = new \App\SupplierAccount();
			// 	$SupplierAccount->account_no = $suplier;
			// 	$SupplierAccount->transection_no = $order_id;
			// 	$SupplierAccount->transection_date = $date;
			// 	$SupplierAccount->credit = $request->net_amount;
			// 	$SupplierAccount->description = $request->common_notes ?? '';

			// 	if ($request->payment_amount > 0) {
			// 		$SupplierAccount->debit = $request->payment_amount;
			// 	}
			// 	$SupplierAccount->created_by = Auth::user()->id;

			// 	$SupplierAccount->save();

			// }

			// if ($request->payment_amount > 0) {
			// 	$CashBook = new \App\CashBook();
			// 	//$CashBook->account_no = $suplier;
			// 	$CashBook->account_no = $request->cash_book ?? 1;
			// 	$CashBook->own_account_no =  $suplier;

			// 	$CashBook->refeance_no = $order_id;
			// 	$CashBook->transection_date = $date;
			// 	$CashBook->credit = $request->payment_amount;
			// 	$CashBook->description = $request->common_notes ?? '';
			// 	$CashBook->person_type = 'supplier';
			// 	$CashBook->created_by = Auth::user()->id;
			// 	$CashBook->save();

			// }

			if ($request->preorder_ref != '') {
				DB::table('purchase_orders')
					->where('id', $request->preorder_ref)
					->update(['status' => 1]);
			}

			$empty_temp_table = DB::table('purchase_temp_tables')->where('employee_id', Auth::user()->id)->where('status', 1)->delete();
			Session::flash('message', 'Product purchase Successfully !');
			return redirect('purchase-order');
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function preorder_delete($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_delete')) {
			$empty_temp_table = DB::table('purchase_orders')
				->join('purchase_details', 'purchase_orders.id', '=', 'purchase_details.order_id')
				->where('purchase_orders.id', $id)->where('purchase_details.order_id', $id)->delete();
			return redirect()->back();
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function pre_order(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_add')) {

			if ($request->suplier == '' || $request->product_id == '') {
				return redirect()->back();
			}
			if ($request->suplier == '000') {
				$suplier = '000';
			} else {
				$suplier = $request->suplier;
			}

			if ($request->net_amount < $request->payment_amount) {
				$initial_payment = $request->net_amount;
			} else {
				$initial_payment = $request->payment_amount;
			}

			$date = $request->preorder_date;
			if ($request->has('barcode')) {

				$order = PurchaseOrder::firstOrCreate(['supplier_Id' => $suplier, 'gross_amount' => $request->gross_amount, 'ref_no' => $request->ref_no, 'order_date' => $date, 'net_amount' => $request->net_amount, 'payment_amount' => $request->payment_amount, 'gross_discount' => $request->gross_discount, 'transection_type' => $request->transection_term_id, 'order_type' => 'pre_order', 'pre_order_status' => 'pre', 'gross_vat_amount' => $request->gross_vat_amount, 'employee_id' => Auth::user()->id, 'initial_payment' => $initial_payment, 'expected_delivery_date' => $request->expected_delivery_date, 'status' => 0]);
				$order_id = $order->id;
				if (!empty($order)) {
					$order_id = $order->id;
				} else {
					return 'something went to wrong';
				}

				if ($request->barcode != '') {
					for ($i = 0; $i < count($request->barcode); $i++) {
						$PurchaseDetail = new PurchaseDetail();
						$PurchaseDetail->product_id = $request->product_id[$i];
						$PurchaseDetail->order_id = $order_id;
						$PurchaseDetail->qty = $request->qty[$i];
						$PurchaseDetail->l_gross_cost_price = $request->l_gross_cost_price[$i];
						$PurchaseDetail->price = $request->net_cost_price[$i];
						$PurchaseDetail->vat_rate = $request->vat_rate[$i];
						$PurchaseDetail->discount_rate = $request->discount_rate[$i];
						$PurchaseDetail->line_total = $request->net_line_total[$i];
						$PurchaseDetail->note = $request->note;
						$PurchaseDetail->status = 0;
						$PurchaseDetail->save();
						$empty_temp_table = PurchaseTempTable::where('status', 2)->where('employee_id', Auth::user()->id)->where('product_id', $request->product_id[$i])->delete();
					}
				}
				Session::flash('message', 'Order Added Successfully !');

			} else {
				Session::flash('message', 'Please Checked Item For Make Sure Order ');
			}
			Session::flash('message', 'Product preorder recorded Successfully !');
			return redirect('purchase-preorder');
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function PurchaseInvoice(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$purchase_order = new PurchaseOrder();
			$info = $purchase_order->GetAllinvoice($start_date, $end_date);
			return view('purchase-order.purchase_invoice', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function preorder_invoice(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$purchase_order = new PurchaseOrder();
			$info = $purchase_order->GetPreOrderInvoice($start_date, $end_date);
			return view('purchase-order.pre_order_invoice', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function PurchaseInvoiceDetails($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if ($id == 'opening') {
				Session::flash('message', 'There Was No Invoice History Because It Was Previous Transection !');
				return redirect()->back();
			} else {
				$purchase_order = new PurchaseOrder();
				$order_datails = $purchase_order->SinglePurchase_order($id);
				$purchase_orderdetails = new PurchaseDetail();
				$info = $purchase_orderdetails->GetInvoiceDetails($id);
				$PurchaseVatAccount = new PurchaseVatAccount();
				$purchaseDiscountAccount = new PurchaseDiscountAccount();
				$PurchaseAccounts = new PurchaseAccounts();
				$gross_vat = $PurchaseVatAccount->where('order_id', $id)->selectRaw('sum(debit)-sum(credit) as grossvat')->first();
				$gross_discount = $purchaseDiscountAccount->where('order_id', $id)->selectRaw('sum(credit)-sum(debit) as grossdiscount')->first();
				$purchase_gross = $PurchaseAccounts->where('order_id', $id)->selectRaw('sum(debit)-sum(credit) as grosspurchase')->first();
				$return_details = $purchase_orderdetails->GetInvoiceDetails($id, '0');
				$return_product_array = [];
				if (count($return_details) > 0) {
					foreach ($return_details as $pdetails) {
						$return_product_array[$pdetails->return_ref] = $pdetails;
					}
				}
				//return $return_product_array;
				$transaction_terms = TransactionTerm::get();
				return view('purchase-order.purchase_invoice_details', compact('info', 'order_datails', 'transaction_terms', 'return_product_array', 'gross_vat', 'gross_discount', 'purchase_gross'));
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function CashPurchaseInvoice(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$time = Carbon::today();
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
					$start_strtotime = strtotime("$start_date 00:00:00");
					$end_strtotime = strtotime("$end_date 23:59:59");
					$start_time = date('Y-m-d H:i:s', $start_strtotime);
					$end_time = date('Y-m-d H:i:s', $end_strtotime);
				} else {
					return 'Something went to wrong';
				};
			}

			$purchase_order = new PurchaseOrder();
			$info = $purchase_order->GetCashPurchaseOrderAll($start_time, $end_time);
			return view('purchase-order.purchase_cash_invoice', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function CreditPurchaseInvoice(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$time = Carbon::today();
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$purchase_order = new PurchaseOrder();
			$info = $purchase_order->GetCreditPurchaseOrderAll($start_date, $end_date);
			return view('purchase-order.purchase_credit_invoice', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function PurchaseDueInvoice(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}

			$purchase_order = new PurchaseOrder();
			$info = $purchase_order->GetCreditInvoiceall($start_date, $end_date);
			return view('purchase-order.purchase_due_invoice', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function UserbasePurchase(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}
			$purchase_order = new PurchaseOrder();
			$info = $purchase_order->UserwiePurchase($start_date, $end_date);
			return view('purchase-order.userwisepurchase', compact('info', 'request'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

}