<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

class ProductMeasurementController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_view')) {
			$crud = new \App\Library\Crud;
			$info = $crud->Getvalue('ProductQuantityMeasurement');
			return view('measurment.index', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_add')) {
			$crud = new \App\Library\Crud;
			if ($request->action == 'modal') {

				$crud_result = $crud->InsertValue('ProductQuantityMeasurement', $request->all(), true);
				return $crud_result;
			} else {
				$request->validate([
					'name' => 'required|unique:product_quantity_measurements',
				]);
				$crud = new \App\Library\Crud;
				$crud->InsertValue('ProductQuantityMeasurement', $request->all());
				$info = $crud->Getvalue('ProductQuantityMeasurement');
				return view('measurment.table', compact('info'));
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_edit')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('ProductQuantityMeasurement', ['id', $id]);
			return view('measurment.edit', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_edit')) {
			$request->validate([
				'name' => 'required|unique:product_quantity_measurements,id,' . $request->id,
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'ProductQuantityMeasurement', ['id', $request->id]);
			$info = $crud->Getvalue('ProductQuantityMeasurement');
			return redirect('measurment')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('product_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('ProductQuantityMeasurement', ['id', $id]);
			return redirect('measurment')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

}
