<?php

namespace App\Http\Controllers;
use App\OwnerProfile;
use Illuminate\Http\Request;

class OwnerProfileController extends Controller {
	public function index() {
		$info = \DB::select(" SELECT t1.*,SUM(IFNULL(t2.credit,0)-IFNULL(t2.debit,0)) as balance FROM owner_profiles AS t1
LEFT JOIN capital_accounts AS t2 ON t1.id = t2.account_no
GROUP BY t1.id ");
		return view('owner.index', compact('info'));
	}

	public function store(Request $request) {
		$request->validate([
			'name' => 'required',
			'phone' => 'required',

		]);

		/*Data insert to Customer Profile table*/
		$crud = new \App\Library\Crud;
		$crud_result = $crud->InsertValue('OwnerProfile', $request->all());
		$info = OwnerProfile::get();
		return view('owner.table', compact('info'));

	}

	public function edit($id) {
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('OwnerProfile', ['id', $id]);
		return view('owner.edit', compact('info'));
	}
	public function update(Request $request, $id) {
		$request->validate([
			'name' => 'required',
			'phone' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'OwnerProfile', ['id', $request->id]);
		return redirect('owner')->with('message', 'Updated Successfully');
	}

}
