<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

class ModuleController extends Controller {

	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library();
		$crud = new \App\Library\Crud;
		$info = $crud->Getvalue('Module');
		return view('module.index', compact('info'));

	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create(Request $request) {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$request->validate([
			'name' => 'required|unique:modules',
		]);
		$crud = new \App\Library\Crud;
		$crud_result = $crud->InsertValue('Module', $request->all());
		$info = $crud->Getvalue('Module');
		return view('module.table', compact('info'));
	}

	public function show($id) {
		//
	}

	public function edit($id) {
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('Module', ['id', $id]);
		return view('module.edit', compact('info'));

	}

	public function update(Request $request, $id) {
		$request->validate([
			'name' => 'required|unique:modules,id,' . $request->id,
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'Module', ['id', $request->id]);
		return redirect('module')->with('message', 'Updated Successfully');

	}

	public function destroy($id) {
		$crud = new \App\Library\Crud;
		$crud->DeleteValueWhereSingle('Module', ['id', $id]);
		return redirect('module')->with('message', 'Deleted Successfully');
	}

	//
}
