<?php

namespace App\Http\Controllers;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Session;

class InventoryManagementController extends Controller {

	public function ReorderReport(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_view')) {
			$inventory = new \App\Inventory();
			$info = $inventory->GetReorderProduct();
			return view('report.reorder', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function single_reorder(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_view')) {
			//return $id;
			$priceListInfo = DB::table('product_price_lists')
				->join('inventories', 'product_price_lists.product_id', '=', 'inventories.product_id')
				->where('product_price_lists.product_id', $id)->orderBy('product_price_lists.order_id', 'DESC')->first();
			//dump($priceListInfo);die();
			if($priceListInfo) {
				$profileInfo = DB::table('product_profiles')
					->join('inventories', 'product_profiles.id', '=', 'inventories.product_id')
					->where('product_profiles.id', $id)->first();
				//dump($profileInfo);die();
				return view('purchase-order.single_preOrder', compact('profileInfo'));
			} else {
				//return 1;
				//dump($priceListInfo);die();
				return view('purchase-order.single_preOrder', compact('priceListInfo'));
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function AvailableProduct() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_view')) {
			$inventory = new \App\Inventory();
			$info = $inventory->GetAvailableProduct();
			return view('report.available_items', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function SrinkageProduct() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_view')) {
			$inventory = new \App\Inventory();
			$info = $inventory->GetSrinkageProduct();
			return view('report.srinkage_items', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function InventoryFullProduct() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_view')) {
			$inventory = new \App\Inventory();
			$info = $inventory->GetAllProduct();
			return view('report.all_items_report', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	public function InventoryCost() {
		$inventoryCost = new \App\ProductPriceList();
		$info = $inventoryCost->GetstockValue();
		return $info;
	}

	public function reorderEdit(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_edit')) {
			$findProducts = DB::table('inventories')
				->join('product_profiles', 'product_profiles.id', '=', 'inventories.product_id')
				->select('inventories.*', 'product_profiles.name')
				->where('inventories.product_id', $id)
				->first();
			if (!empty($findProducts)) {
				return view('report.reorder_update', compact('findProducts'));
			} else {
				return "You Input Wrong product Id Number ! ";
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function reorderUpdate(Request $request, $id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('inventory_edit')) {
			if (!empty($request->all())) {
				DB::table('inventories')
					->where('product_id', $id)
					->update(['reorder_label' => $request->reorder_label, 'target_label' => $request->target_label, 'min_reorder_qty' => $request->min_reorder_qty]);
				Session::flash('message', 'Updated Successfully ! ');
				return redirect('reorder');
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

}
/*select sum(debit) as totalDebit, sum(credit) as totalcredit from customer_accounts group by account_no*/

// SELECT `account_no`,SUM(`debit` -`credit`)
//   FROM customer_accounts
//  GROUP BY `account_no`
// HAVING SUM(`debit` -`credit`)

// SELECT `account_no`,SUM(`debit` -`credit`) as balance,sum(`debit`) as total_debit,sum(`credit`) total_credit FROM customer_accounts GROUP BY `account_no` HAVING SUM(`debit` -`credit`)