<?php

namespace App\Http\Controllers;

use App\ExpenseProfile;
use App\User;
use Illuminate\Http\Request;
use Session;

class ExpenseController extends Controller {
	public function index() {
		$info = ExpenseProfile::get();
		return view('expense.index', compact('info'));
	}

	public function store(Request $request) {
		$request->validate([
			'name' => 'required',
		]);

		/*Data insert to Customer Profile table*/
		$crud = new \App\Library\Crud;
		$crud_result = $crud->InsertValue('ExpenseProfile', $request->all());
		$info = ExpenseProfile::get();
		return view('expense.table', compact('info'));

	}

	public function edit($id) {
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('ExpenseProfile', ['id', $id]);
		return view('expense.edit', compact('info'));
	}
	public function update(Request $request, $id) {
		$request->validate([
			'name' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'ExpenseProfile', ['id', $request->id]);
		return redirect('expense')->with('message', 'Updated Successfully');
	}

	public function cashExpense() {
		return view('cash.expense');
	}

	public function fetch_expense_account(Request $request) {

		if ($request->has('exp')) {
			$expenseAccounts = ExpenseProfile::get();
		}

		if ($request->has('emp')) {
			$expenseAccounts = User::get();
		}

		return json_encode($expenseAccounts);
	}

	public function reverseExpense() {
		return view('expense.reverse');
	}

	public function reverseItemFetch(Request $request) {
		if ($request->has('transectionId')) {
			$ExpenseAccount = \App\ExpenseAccount::where('id', '=', $request->transectionId)->first();
			if (!empty($ExpenseAccount)) {
				$expAccountNumber = $ExpenseAccount->account_no;
				$empAccountNumber = $ExpenseAccount->ref_no;
				if ($expAccountNumber != '') {
					$ExpenseProfile = ExpenseProfile::where('id', $expAccountNumber)->first();
				}
				if ($empAccountNumber != '') {
					$User = \App\User::where('id', $empAccountNumber)->first();
				}

				return view('expense.reverse_solve', compact('ExpenseAccount', 'ExpenseProfile', 'User'));
			} else {
				Session::flash('message', 'Input Valid Transection Number !');
				return back();
			}

		}
	}
}
