<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

class EmployeeProfileController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library();
		if ($library->check_user_access('employee_view')) {
			$crud = new \App\Library\Crud;
			$info = $crud->Getvalue('User');
			$employeePosition = $crud->Getvalue('Role');
			return view('employee.index', compact('info', 'employeePosition'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {

		//return view('employee.create', compact('employeePosition'));
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('employee_add')) {

			$request->validate([
				'name' => 'required',
				'status' => 'required',
				'email' => 'required|unique:employee_profiles',
				'address' => 'required',
				'phone' => 'required',
				'position' => 'required',
				'password' => 'required|confirmed',

			]);
			if ($request->hasFile('image')) {

				$uniqueImage = $library->unique_image($request, 'employee_image');

			} else {

				$uniqueImage = null;
			}

			$password = $library->EncriptionValue($request->password);
			$collection = $library->remove_element($request, ['image', 'password', 'position_id']);
			$collection = $library->add_element($collection, ['image' => $uniqueImage, 'password' => $password, 'position_id' => $request->position]);

			$crud = new \App\Library\Crud;
			$user = $crud->InsertValue('User', $collection, true);
			$user->roles()->attach($request->position);

			$info = $crud->Getvalue('EmployeeProfile');
			return back()->with('message', 'Inserted Successfully !');

			return view('employee.table', compact('info', 'employeePosition'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('employee_edit')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('User', ['id', $id]);
			$employeePosition = $crud->Getvalue('Role');
			return view('employee.edit', compact('info', 'employeePosition'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
	}

	public function updateProfile(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('employee_edit')) {

			$request->validate([
				'name' => 'required',
				'status' => 'required',
				'email' => 'required|unique:users,email,' . $request->id,
				'address' => 'required',
				'phone' => 'required',
				'position' => 'required',
				'password' => 'required|confirmed',

			]);
			$crud = new \App\Library\Crud;
			$fetchinfo = $crud->GetValueWhereSingle('User', ['id', $request->id]);
			if ($library->is_file($request)) {
				$uniqueImage = $library->unique_image($request, 'employee_image');
				if ($fetchinfo->image != null) {
					$somon = $library->unlink_file('employee_image', $fetchinfo->image);

				}

			} else {
				$uniqueImage = $fetchinfo->image ?? null;
			}
			$password = $library->EncriptionValue($request->password);
			$collection = $library->remove_element($request, ['image', 'password', 'position_id']);
			$collection = $library->add_element($collection, ['image' => $uniqueImage, 'password' => $password, 'position_id' => $request->position]);
			$crud->UpdateValeWhereSingle($collection, 'User', ['id', $request->id]);
			$fetchinfo->roles()->detach($fetchinfo->position_id);
			$fetchinfo->roles()->attach($request->position);

			return redirect('employee')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('employee_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('User', ['id', $id]);
			return redirect('employee')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}
}
