<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

class EmployeePossitionController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$crud = new \App\Library\Crud;
		$info = $crud->Getvalue('EmployeePosition');
		return view('employee-position.index', compact('info'));
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$request->validate([
			'name' => 'required|unique:employee_positions',
		]);
		$crud = new \App\Library\Crud;
		$crud->InsertValue('EmployeePosition', $request->all());
		$info = $crud->Getvalue('EmployeePosition');
		return view('employee-position.table', compact('info'));
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('EmployeePosition', ['id', $id]);
		return view('employee-position.edit', compact('info'));

	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$request->validate([
			'name' => 'required|unique:employee_positions,id,' . $request->id,
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'EmployeePosition', ['id', $request->id]);
		return redirect('employee-position')->with('message', 'Updated Successfully');
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$crud = new \App\Library\Crud;
		$crud->DeleteValueWhereSingle('EmployeePosition', ['id', $id]);
		return redirect('employee-position')->with('message', 'Deleted Successfully');
	}
}
