<?php

namespace App\Http\Controllers;
//use App\CashBook;
use App\CustomerAccounts;
use App\CustomerProfile;
use App\AccountLevelTwo;
use App\AccountDetail;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;

class CustomerProfileController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index(Request $request) {

		$account_heads = AccountLevelTwo::where('status',1)->where('id',1)->orderBy('code','ASC')->get();

		$limit = $request->limit ?? 20;
		$ad_name = $request->ad_name ?? '';
		$phone = $request->phone ?? '';
		$ad_address = $request->ad_address ?? '';
		$ad_al2_id = $request->ad_al2_id ?? '';
		if($request->has('limit')){
			if($request->limit == "All"){
				$limit = "All";
				
			}
		}
		
		$info = AccountDetail::where('status',1)->where('ad_al2_id',1);
		if($ad_name !="" ){
			$info = $info->where('ad_name', 'LIKE', "%{$ad_name}%");
		}
		if($phone !="" ){
			$info = $info->where('phone', 'LIKE', "%{$phone}%");
		}
		if($ad_address !="" ){
			$info = $info->where('ad_address', 'LIKE', "%{$ad_address}%");
		}
		if($ad_al2_id !="" ){
			$info = $info->where('ad_al2_id', $ad_al2_id);
		}
		if($limit !='' && $limit !="All"){
			$info = $info->take($limit);
		}
		$info = $info->with(['account_sub_category'])->orderBy('name','asc')->get();
		//return $request;
		return view('account-details.index',compact('info','account_heads','request'));

		// $library = new \App\Library\Library();
		// if ($library->check_user_access('customer_view')) {
		// 	$crud = new \App\Library\Crud;
		// 	$CustomerAccounts = $crud->Getvalue('CustomerAccounts');
		// 	$customer_category = $crud->Getvalue('CustomerCategory');
		// 	$TransactionTerm = $crud->Getvalue('TransactionTerm');
		// 	$info = CustomerProfile::with('CustomerCategory')->with('TransactionTerm')->with('CustomerAccounts')->orderBy('id', 'DESC')->get();

		// 	return view('customers.index', compact('info', 'customer_category', 'TransactionTerm', 'CustomerAccounts'));
		// } else {
		// 	return "Sorry you don't have access to this action";
		// }
	}

	/**
	 * find Category wise account number
	 *
	 *
	 */
	public function findAccountForReport(Request $request) {
		$category = $request->category;
		$html_output = null;
		if ($category == 'Cash') {
			$html_output = "<option value='cash_book'>Cash Book</option>";
		}
		/**
		 * For Find out Bank account Profiles
		 *
		 *
		 */
		if ($category == 'Bank') {
			$BankAccountProfile = new \App\BankAccountProfile();
			$all_bank_accounts = $BankAccountProfile::get();
			$html_output = view('account.bank', compact('all_bank_accounts'));
		}
		/**
		 * For Find out Mobile Bank account Profiles
		 *
		 *
		 */
		if ($category == 'Mobile_bank') {
			$MobileBankAccountsProfile = new \App\MobileBankAccountsProfile();
			$all_bank_accounts = $MobileBankAccountsProfile::get();
			$html_output = view('account.mobile_bank', compact('all_bank_accounts'));
		}

		return $html_output;
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create() {
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {

		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_add')) {

			$request->validate([
				'name' => 'required',
				'phone' => 'required',
				'category_id' => 'required',
				'transection_term_id' => 'required',
			]);
			$date = Carbon::today();

			/*Data insert to Customer Profile table*/
			$crud = new \App\Library\Crud;
			$crud_result = $crud->InsertValue('CustomerProfile', $request->all());

			if ($crud_result) {
				$library = new \App\Library\Library;
				if ($request->debit != 0 && $request->debit != '') {

					$collection = $library->add_element($request->all(), ['account_no' => $crud_result, 'transection_no' => 'opening', 'transection_date' => $date, 'created_by' => Auth::user()->id]);
					$crud->InsertValue('CustomerAccounts', $collection);
				}
				if ($request->action != 'modal') {
					$info = CustomerProfile::with('CustomerCategory')->with('TransactionTerm')->with('CustomerAccounts')->orderBy('id', 'DESC')->get();
					return view('customers.table', compact('info'));
				} else {
					return 1;
				}
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_edit')) {
			$crud = new \App\Library\Crud;
			$customer_category = $crud->Getvalue('CustomerCategory');
			$TransactionTerm = $crud->Getvalue('TransactionTerm');
			$info = $crud->GetValueWhereSingle('CustomerProfile', ['id', $id]);
			return view('customers.edit', compact('info',  'customer_category', 'TransactionTerm'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_edit')) {
			$request->validate([
				'name' => 'required',
				'phone' => 'required',
				'category_id' => 'required',
				'transection_term_id' => 'required',
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'CustomerProfile', ['id', $request->id]);
			return redirect('customer')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('CustomerProfile', ['id', $id]);
			return redirect('customer')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function CustomerReport() {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer-report_view')) {
			$profile = new \App\CustomerAccounts();
			$info = $profile->GetcustomerReport();
			return view('customer-report.customer-report', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function GetCustomerReportIndivisual($account_no) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer-report_view')) {
			$profile = new \App\CustomerAccounts();
			$CustomerProfile = new CustomerProfile();
			$info = $profile->GetIndivisualCustomerReport($account_no);
			$customer = $CustomerProfile->GetIndivisualcustomer($account_no);
			return view('customer-report.customer-report-indivisual', compact('info', 'customer'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function allAccount() {
		return view('customer-report.all_type_of_report');
	}

	//customer Transection History
	public function customer_history(Request $request) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer-report_view')) {
			if ($request->start_date != null && $request->end_date != null && $request->addCustomer != null) {
			//	dump($request->all());
				$start_strtotime = strtotime($request->start_date);
				$end_strtotime = strtotime($request->end_date);
				$start_date = date('Y-m-d', $start_strtotime);
				$end_date = date('Y-m-d', $end_strtotime);

				//$account_no = $request->account_no;
				$accountInfo = explode("<>", $request->addCustomer);
				$account_no = $accountInfo[0];

				$crud = new \App\Library\Crud;
				$info = $crud->GetValueWhereSingle('CustomerProfile', ['id', $account_no]);
				

				 $dateBeforeBalance = CustomerAccounts::selectRaw('account_no,transection_no,debit,credit,description,created_at')->where('account_no', $account_no)->where('created_at', '<', $start_date)->get();

				$setquery = DB::statement("SET@csum=0 ");
				$query = 'SELECT a.account_no, a.t_date, a.descriptions, a.debit, a.credit, (@csum:=@csum+a.balance) as cummulative
FROM (
    SELECT a.account_no, "' . $start_date . '" - INTERVAL 1 DAY AS t_date, "B/F" AS descriptions, Sum(a.debit) AS debit, Sum(a.credit) AS credit, Sum(IFNULL(a.debit,0)-IFNULL(a.credit,0)) AS balance  FROM customer_accounts a
    WHERE a.transection_date < "' . $start_date . '" AND a.account_no="' . $account_no . '" GROUP BY a.account_no
    UNION ALL
    SELECT a.account_no, date(a.transection_date) As t_date, a.description, a.debit, a.credit, (IFNULL(a.debit,0)- IFNULL(a.credit,0)) AS balance
    FROM customer_accounts a  WHERE date(a.transection_date) >="' . $start_date . '" AND date(a.transection_date)<="' . $end_date . '" AND a.account_no="' . $account_no . '") AS a
	ORDER BY a.t_date DESC';
				$customerHistory = DB::select($query);
				

				// echo "<pre>";
				// print_r($customerHistory);
				// die();
				//return redirect('customer-history')->with($customerHistory);
				return view('customer-report.customer_history', compact('customerHistory', 'info'));
			} else {
				return view('customer-report.customer_history');
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	//customer Transection History
	public function cusSupHistory(Request $request) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer-report_view')) {
			if ($request->start_date != null && $request->end_date != null && $request->addCustomer != null) {
			//	dump($request->all());
				$start_strtotime = strtotime("$request->start_date 00:00:00");
				$end_strtotime = strtotime("$request->end_date 23:59:59");
				$start_date = date('Y-m-d H:i:s', $start_strtotime);
				$end_date = date('Y-m-d H:i:s', $end_strtotime);

				

				//$account_no = $request->account_no;
				$accountInfo = explode("<>", $request->addCustomer);
				$account_no = $accountInfo[0];

				$crud = new \App\Library\Crud;
				 $info = $crud->GetValueWhereSingle('CustomerProfile', ['common_id', $account_no]);
				 $info2 = $crud->GetValueWhereSingle('SupplierProfile', ['common_id', $account_no]);
				 $suplier_id = $info2->id;
				 $customer_id = $info->id;
				

	
				$customerHistory = DB::select(" SELECT t2._type AS _type, t2.id AS id,t2.account_no AS account_no, t2.transection_no AS transection_no, t2.transection_date AS transection_date, t2.description AS description, t2.debit AS debit, t2.credit AS credit, t2.created_by AS created_by from(

					SELECT t1._type AS _type, t1.id AS id,t1.account_no AS account_no, t1.transection_no AS transection_no, t1.transection_date AS transection_date, t1.description AS description, SUM(t1.debit) AS debit, SUM(t1.credit) AS credit, t1.created_by AS created_by FROM (
SELECT _type AS _type, '' AS id,'' AS account_no, '' AS transection_no, '' AS transection_date, 'B/F' AS description, SUM(IFNULL(debit,0)) AS debit, SUM(IFNULL(credit,0)) AS credit, '' AS created_by  FROM `customer_supplier_both_accounts` WHERE transection_date < '".$start_date."' AND account_no ='".$customer_id."' AND _type='customer' GROUP BY account_no
UNION ALL 
SELECT _type AS _type, '' AS id,'' AS account_no, '' AS transection_no, '' AS transection_date, 'B/F' AS description, SUM(IFNULL(debit,0)) AS debit, SUM(IFNULL(credit,0)) AS credit, '' AS created_by  FROM `customer_supplier_both_accounts` WHERE transection_date < '".$start_date."' AND account_no ='".$suplier_id."' AND _type='supplier' GROUP BY account_no
) AS t1 GROUP BY t1.description
UNION ALL 
SELECT _type, id AS id,account_no AS account_no, transection_no AS transection_no, transection_date AS transection_date, description AS description, IFNULL(debit,0) AS debit, IFNULL(credit,0) AS credit, created_by AS created_by  FROM `customer_supplier_both_accounts` WHERE transection_date BETWEEN '".$start_date."' AND '".$end_date."' AND account_no ='".$customer_id."' AND _type='customer'
UNION ALL 
SELECT _type, id AS id,account_no AS account_no, transection_no AS transection_no, transection_date AS transection_date, description AS description, IFNULL(debit,0) AS debit, IFNULL(credit,0) AS credit, created_by AS created_by  FROM `customer_supplier_both_accounts` WHERE transection_date BETWEEN '".$start_date."' AND '".$end_date."' AND account_no ='".$suplier_id."' AND _type='supplier' ) AS t2 ORDER BY t2.transection_date ASC ");


				

				// echo "<pre>";
				// print_r($customerHistory);
				// die();
				//return redirect('customer-history')->with($customerHistory);
				return view('customer-report.cus_sup_history', compact('customerHistory', 'info'));
			} else {
				return view('customer-report.cus_sup_history');
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	//fetch customer which customer are overdue
	public function ageing_report() {
		$query = "SELECT a.`account_no`, p.name,p.address,p.phone,
						SUM(IFNULL(a.`debit`,0)) as totalDebit,
						SUM(IFNULL(a.`credit`,0)) as totalCredit ,
						(SUM(IFNULL(a.`debit`,0)) - SUM(IFNULL(a.`credit`,0))) as balance
				FROM `customer_accounts` as a
			 	JOIN customer_profiles as p
			 		ON a.`account_no`=p.id GROUP BY a.account_no
			 	HAVING totalDebit > totalCredit";
		$info = DB::select($query);
		return view('customer-report.ageing_report', compact('info'));
	}

}
