<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

class CustomerCategoryController extends Controller {
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_view')) {
			$crud = new \App\Library\Crud;
			$info = $crud->Getvalue('CustomerCategory');
			return view('customer-category.index', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create(Request $request) {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_add')) {
			$crud = new \App\Library\Crud;
			if ($request->action == 'modal') {

				$crud_result = $crud->InsertValue('CustomerCategory', $request->all(), true);
				return $crud_result;
			} else {
				$request->validate([
					'name' => 'required|unique:customer_categories',
				]);
				$crud_result = $crud->InsertValue('CustomerCategory', $request->all());
				$info = $crud->Getvalue('CustomerCategory');
				return view('customer-category.table', compact('info'));
			}
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function show($id) {
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function edit($id) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_edit')) {
			$crud = new \App\Library\Crud;
			$info = $crud->GetValueWhereSingle('CustomerCategory', ['id', $id]);
			return view('customer-category.edit', compact('info'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_edit')) {
			$request->validate([
				'name' => 'required|unique:customer_categories,id,' . $request->id,
			]);
			$crud = new \App\Library\Crud;
			$crud->UpdateValeWhereSingle($request->all(), 'CustomerCategory', ['id', $request->id]);
			return redirect('customer-category')->with('message', 'Updated Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id) {
		$library = new \App\Library\Library();
		if ($library->check_user_access('customer_delete')) {
			$crud = new \App\Library\Crud;
			$crud->DeleteValueWhereSingle('CustomerCategory', ['id', $id]);
			return redirect('customer-category')->with('message', 'Deleted Successfully');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

}
