<?php

namespace App\Http\Controllers;
use App\CapitalAccount;
use App\CashBook;
use App\CustomerAccounts;
use App\CustomerProfile;
use App\ExpenseAccount;
use App\OwnerProfile;
use App\PurchaseOrder;
use App\SalesOrder;
use App\SupplierAccount;
use App\SupplierProfile;
use Carbon\Carbon;
use DateTime;
use DateTimezone;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Session;

class CashManagementController extends Controller {

	public function cash_report(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_view')) {
			if (empty($request->all())) {
				$time = Carbon::today();
				$end_date = $time->toDateString();
				$start_date = $time->subDays(29)->toDateString();

			} else {
				if (!is_null($request->date_range)) {
					$time = explode(' ', $request->date_range);
					$start_date = $time[0];
					$end_date = $time[1];
				} else {
					return 'Something went to wrong';
				};
			}
			$query = "SELECT account_no, person_type,SUM(debit) as debitTotal , SUM(credit) as creditTotal FROM cash_books group by person_type";
			$info = DB::select($query);
			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal FROM cash_books ";
			$totalInfo = DB::select($query2);
			//return $info;
			return view('cash.report', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	//capital History
	public function capitalHistory(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('capital_view')) {
			$query = "SELECT cash_books.account_no as account_no, cash_books.person_type as person_type,owner_profiles.name as name, SUM(cash_books.debit) as debitTotal , SUM(cash_books.credit) as creditTotal
			FROM cash_books
			left join owner_profiles  on owner_profiles.id = cash_books.account_no
			WHERE cash_books.person_type='capital' GROUP BY cash_books.account_no ";

			$info = DB::select($query);
			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE person_type = 'capital' ";

			$totalInfo = DB::select($query2);

			return view('cash.capital_history', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	//Sales History
	public function salesHistory(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			$query = "SELECT cash_books.account_no as account_no, cash_books.person_type as person_type,customer_profiles.name as name, SUM(cash_books.debit) as debitTotal , SUM(cash_books.credit) as creditTotal
			FROM cash_books
			left join customer_profiles  on customer_profiles.id = cash_books.account_no
			WHERE cash_books.person_type='customer' GROUP BY cash_books.account_no ";

			$info = DB::select($query);
			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE person_type = 'customer' ";

			$totalInfo = DB::select($query2);

			return view('cash.sales_history', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	//Sales History
	public function purchaseHistory(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			$query = "SELECT cash_books.account_no as account_no, cash_books.person_type as person_type,supplier_profiles.name as name, SUM(cash_books.debit) as debitTotal , SUM(cash_books.credit) as creditTotal
			FROM cash_books
			left join supplier_profiles  on supplier_profiles.id = cash_books.account_no
			WHERE cash_books.person_type='supplier' GROUP BY cash_books.account_no ";

			$info = DB::select($query);
			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE person_type = 'supplier' ";

			$totalInfo = DB::select($query2);

			return view('cash.purchase_history', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	//Sales History
	public function expenseHistory(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('expense_view')) {
			$query = "SELECT cash_books.account_no as account_no, cash_books.person_type as person_type,expense_profiles.name as name, SUM(cash_books.debit) as debitTotal , SUM(cash_books.credit) as creditTotal
			FROM cash_books
			left join expense_profiles  on expense_profiles.id = cash_books.account_no
			WHERE cash_books.person_type='expense' GROUP BY cash_books.account_no ";

			$info = DB::select($query);
			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE person_type = 'expense' ";

			$totalInfo = DB::select($query2);

			return view('cash.expense_history', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function singleHistory($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('capital_view')) {
			$query = "SELECT *,owner_profiles.name as name
			FROM cash_books
			left join owner_profiles  on owner_profiles.id = cash_books.account_no
			WHERE account_no = " . $id . " AND person_type = 'capital' ";

			$info = DB::select($query);

			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE account_no = " . $id . "  AND person_type = 'capital' ";

			$totalInfo = DB::select($query2);
			return view('cash.singleCapitalHistory', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	//single Sales History
	public function singleSalesHistory($id) {

		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			$query = "SELECT *,customer_profiles.name as name
			FROM cash_books
			left join customer_profiles  on customer_profiles.id = cash_books.account_no

			WHERE account_no = " . $id . " AND person_type = 'customer' ";

			$info = DB::select($query);

			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE account_no = " . $id . "  AND person_type = 'customer' ";

			$totalInfo = DB::select($query2);
			/*$returnId = DB::table('sales_retrun_orders')->where('id', $id)->first();
			$returnLinkId = (!empty($returnId)) ? $returnId : 0;*/

			return view('cash.singleSalesHistory', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	//single Sales History
	public function singlePurchaseHistory($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('purchase_view')) {
			$query = "SELECT *,supplier_profiles.name as name
			FROM cash_books
			left join supplier_profiles  on supplier_profiles.id = cash_books.account_no
			WHERE account_no = " . $id . " AND person_type = 'supplier' ";

			$info = DB::select($query);

			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE account_no = " . $id . "  AND person_type = 'supplier' ";

			$totalInfo = DB::select($query2);
			return view('cash.singlePurchaseHistory', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}
	//single Sales History
	public function singleExpenseHistory($id) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('expense_view')) {
			/*$query = "SELECT *,expense_profiles.name as name
				FROM cash_books
				left join expense_profiles  on expense_profiles.id = cash_books.account_no
			*/

			$info = DB::table('cash_books')
				->join('expense_profiles', 'expense_profiles.id', '=', 'cash_books.account_no')
				->join('expense_accounts', 'expense_accounts.account_no', '=', 'cash_books.account_no')
				->where('cash_books.account_no', '=', $id)
				->where('cash_books.person_type', '=', 'expense')
				->groupBy('expense_accounts.id')->get();

			$query2 = "SELECT SUM(debit) as debTotal , SUM(credit) as creTotal
				   FROM cash_books
				   WHERE account_no = " . $id . "  AND person_type = 'expense' ";

			$totalInfo = DB::select($query2);
			return view('cash.singleExpenseHistory', compact('info', 'totalInfo'));
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function index() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_view')) {
			return view('cash.index');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function fetch_account_number(Request $request) {

		$customers = CustomerProfile::select('id', 'name')->get();
		$suppliers = SupplierProfile::select('id', 'name')->get();
		//$employees = EmployeeProfile::select('id', 'name')->get();

		echo json_encode(['suppliers' => $suppliers, 'customers' => $customers]);

	}

/*
 *This Method used for Customer and Supplier Wise All due invoice information fetch.
 */
	public function customerWiseDueInvoiceNumber(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('sales_view')) {
			if ($request->has('id')) {

				$returnCheck = DB::table('sales_retrun_orders')->where('return_customer_Id', $request->id)->get();

				if (count($returnCheck) > 0) {

					$dueInvoiceNumber = DB::table('sales_orders')
						->select('sales_orders.id as mainId', 'sales_orders.due_amount', 'sales_retrun_orders.return_gross_amount')
						->join('sales_retrun_orders', 'sales_retrun_orders.return_return_ref', '=', 'sales_orders.id')
						->where('sales_orders.due_amount', '>', 0)
						->where('sales_orders.customer_Id', $request->id)
						->where('sales_orders.order_type', '=', 'sales')->get();

					$rowQuery = "select sales_orders.* from sales_orders where sales_orders.id not in (select o.id from sales_orders o join sales_retrun_orders p on o.id = p.return_return_ref where o.due_amount > 0 AND o.customer_Id=" . $request->id . " AND o.order_type='sales') AND sales_orders.customer_Id=" . $request->id . " AND sales_orders.due_amount > 0 AND sales_orders.order_type='sales'";

					$dueInvoicereturn = DB::select($rowQuery);
				} else {
					$dueInvoiceNumber = DB::table('sales_orders')
						->select('sales_orders.id as mainId', 'sales_orders.due_amount')
						->where('sales_orders.due_amount', '>', 0)
						->where('sales_orders.customer_Id', $request->id)
						->where('sales_orders.order_type', '=', 'sales')->get();
					$dueInvoicereturn = '';

				}

				// select sales_orders.* from sales_orders where sales_orders.id not in  (select o.id from sales_orders o join sales_retrun_orders p on o.id = p.return_return_ref ) AND  sales_orders.customer_Id=2 AND sales_orders.due_amount > 0 AND sales_orders.order_type='sales'

				$opening = DB::table('customer_accounts')
					->select(DB::raw('SUM(debit) as total_debit,SUM(credit) as total_credit'))
					->where('account_no', $request->id)
					->where('transection_no', '=', 'opening')
					->get();
				return json_encode([$dueInvoiceNumber, $opening, $dueInvoicereturn]);
			}

			if ($request->has('sup')) {
				$query = "SELECT * FROM purchase_orders as p WHERE p.supplier_Id = " . $request->sup . " and p.order_type='purchase' and p.net_amount > p.payment_amount ";
				$dueInvoiceNumber = DB::select($query);
				$opening = DB::table('supplier_accounts')
					->select(DB::raw('SUM(debit) as total_debit,SUM(credit) as total_credit'))
					->where('account_no', $request->sup)
					->where('transection_no', '=', 'opening')
					->get();
				return json_encode([$dueInvoiceNumber, $opening]);

			}

		} else {
			return "Sorry you don't have access to this action";
		}
	}

	//Global Cash receive form
	public function auto_cash_receive_form() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {
			return view('cash.auto_cash_receive_form');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function auto_cash_receive(Request $request) {
		dump($request->all());die();

	}

	public function cash_received_done(Request $request) {
		//return dump($request->all());
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {
			$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
			$date = $dt->format('Y-m-d H:i:s');
			$receiveableAccount = $request->receiveableAccount;
			$account_number = $request->account_number;
			$refeance_no = $request->ref_no;
			$recevedAmount = $request->recevedAmount;
			$note = $request->note;
			$today = $date;
			$type = explode("-", $receiveableAccount);
			if ($type[0] == 'cus') {
				if ($request->recevedAmount != null && $request->recevedAmount > 0) {
					if ($request->ref_no != '') {
						if ($request->ref_no == 'opening') {
							$opening = DB::table('customer_accounts')
								->select(DB::raw('SUM(debit) as total_debit,SUM(credit) as total_credit'))
								->where('account_no', $request->account_number)
								->where('transection_no', '=', 'opening')
								->get();
							foreach ($opening as $key => $value) {
								$receivAbleAmount = $value->total_debit - $value->total_credit;
								if ($receivAbleAmount < $request->recevedAmount) {
									Session::flash('message', 'You Can not Receive Advanced Amount Form Customer. This Invoice Due Amount : Tk. ' . $receivAbleAmount . '  !');
									return redirect()->back();
								} else {
									$CustomerAccounts = new CustomerAccounts();
									$CustomerAccounts->account_no = $request->account_number;
									$CustomerAccounts->transection_no = $request->ref_no;
									$CustomerAccounts->transection_date = $today;
									$CustomerAccounts->credit = $request->recevedAmount;
									$CustomerAccounts->description = $request->note;
									$CustomerAccounts->created_by = Auth::user()->id;
									$CustomerAccounts->save();
									if ($request->recevedAmount != null && $request->recevedAmount > 0) {
										$CashBook = new CashBook();
										$CashBook->account_no = $request->cash_book ?? 1;
										$CashBook->own_account_no = $request->account_number;
										$CashBook->refeance_no = $request->ref_no;
										$CashBook->transection_date = $today;
										$CashBook->debit = $request->recevedAmount;
										$CashBook->description = $request->note;
										$CashBook->person_type = 'customer';
										$CashBook->created_by = Auth::user()->id;
										$CashBook->save();
									}
									Session::flash('message', 'Cash Received Successfully !');
									return redirect()->back();
								}
							}

						} else {
							//return dump($request->all());
							$SalesOrder = new SalesOrder();
							$update_sales_receipt = SalesOrder::where('id', '=', $request->ref_no)->where('customer_Id', $request->account_number)->first();
							if (!empty($update_sales_receipt)) {
								$receive_amount_from_custome = $update_sales_receipt->receive_amount_from_custome + $request->recevedAmount;
								$updateDueAmount = $update_sales_receipt->due_amount - $request->recevedAmount;
								if ($update_sales_receipt->due_amount < $request->recevedAmount) {
									Session::flash('message', 'You Can not Receive Advanced Amount Form Customer. This Invoice Due Amount : Tk. ' . $update_sales_receipt->due_amount . '  !');
									return redirect()->back();
								}

								$update_sales_receipt->receive_amount_from_custome = $receive_amount_from_custome;
								$update_sales_receipt->due_amount = $updateDueAmount;
								$update_sales_receipt->save();

								$CustomerAccounts = new CustomerAccounts();
								$CustomerAccounts->account_no = $request->account_number;
								$CustomerAccounts->transection_no = $request->ref_no;
								$CustomerAccounts->transection_date = $today;
								$CustomerAccounts->credit = $request->recevedAmount;
								$CustomerAccounts->description = $request->note;
								$CustomerAccounts->created_by = Auth::user()->id;
								$CustomerAccounts->save();

								if ($request->recevedAmount != null && $request->recevedAmount > 0) {

									$CashBook = new CashBook();
									$CashBook->account_no = $request->cash_book ?? 1;
									$CashBook->own_account_no = $request->account_number;
									$CashBook->refeance_no = $request->ref_no;
									$CashBook->transection_date = $today;
									$CashBook->debit = $request->recevedAmount;
									$CashBook->description = $request->note;
									$CashBook->person_type = 'customer';
									$CashBook->created_by = Auth::user()->id;
									$CashBook->save();
								}
								Session::flash('message', 'Cash Received Successfully !');
								return redirect()->back();

							} else {
								Session::flash('message', 'Input Valid Invoice Number !');
								return Redirect::back();
							}

						}

					}

				}

			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function cash_payment() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {

			return view('cash.payment');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function cash_payment_done(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {
			$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
			$date = $dt->format('Y-m-d H:i:s');
			$receiveableAccount = $request->receiveableAccount;
			$account_number = $request->account_number;
			$refeance_no = $request->ref_no;
			$recevedAmount = $request->recevedAmount;
			$note = $request->note;
			$today = $date;

			$type = explode("-", $receiveableAccount);

			if ($type[0] == 'sup') {

				if ($request->ref_no == 'opening') {
					$opening = DB::table('supplier_accounts')
						->select(DB::raw('SUM(debit) as total_debit,SUM(credit) as total_credit'))
						->where('account_no', $request->account_number)
						->where('transection_no', '=', 'opening')
						->get();
					foreach ($opening as $key => $value) {
						$receivAbleAmount = $value->total_credit - $value->total_debit;
						if ($receivAbleAmount < $request->recevedAmount) {
							Session::flash('error', 'You Can not Paid Advanced To Supplier. This Invoice Due Amount : Tk. ' . $receivAbleAmount . '  !');
							return redirect()->back();

						} else {
							$SupplierAccount = new SupplierAccount();
							$SupplierAccount->account_no = $request->account_number;
							$SupplierAccount->transection_no = $request->ref_no;
							$SupplierAccount->transection_date = $today;
							$SupplierAccount->debit = $request->recevedAmount;
							$SupplierAccount->description = $request->note;
							$SupplierAccount->created_by = Auth::user()->id;
							$SupplierAccount->save();
							if ($request->recevedAmount != null && $request->recevedAmount > 0) {
								$CashBook = new CashBook();
								$CashBook->account_no = $request->cash_book ?? 1;
								$CashBook->own_account_no = $request->account_number;
								$CashBook->refeance_no = $request->ref_no;
								$CashBook->transection_date = $today;
								$CashBook->credit = $request->recevedAmount;
								$CashBook->description = $request->note;
								$CashBook->person_type = 'supplier';
								$CashBook->created_by = Auth::user()->id;
								$CashBook->save();
								Session::flash('message', 'Cash Payment Successfully !');
								return back();

							}

						}
					}

				} else {
					if ($request->recevedAmount != null && $request->recevedAmount > 0) {
						$PurchaseOrder = new PurchaseOrder();
						$PurchaseOrder = PurchaseOrder::where('id', '=', $request->ref_no)->where('supplier_Id', $request->account_number)->first();
						if (!empty($PurchaseOrder)) {
							$updatePayment = $PurchaseOrder->payment_amount + $request->recevedAmount;
							if ($PurchaseOrder->net_amount < $updatePayment) {
								$payableAmount = ($PurchaseOrder->net_amount - $PurchaseOrder->payment_amount);
								Session::flash('message', 'You Can not Paid Advanced Amount To Supplier. This Invoice Payable  Amount : Tk. "' . $payableAmount . '" !');
								return redirect()->back();
							} else {
								$PurchaseOrder->payment_amount = $updatePayment;
								$PurchaseOrder->save();
							}
							$SupplierAccount = new SupplierAccount();
							$SupplierAccount->account_no = $request->account_number;
							$SupplierAccount->transection_no = $request->ref_no;
							$SupplierAccount->transection_date = $today;
							$SupplierAccount->debit = $request->recevedAmount;
							$SupplierAccount->description = $request->note;
							$SupplierAccount->created_by = Auth::user()->id;
							$SupplierAccount->save();
							if ($request->recevedAmount != null && $request->recevedAmount > 0) {
								$CashBook = new CashBook();
								$CashBook->account_no = $request->cash_book ?? 1;
								$CashBook->own_account_no = $request->account_number;
								$CashBook->refeance_no = $request->ref_no;
								$CashBook->transection_date = $today;
								$CashBook->credit = $request->recevedAmount;
								$CashBook->description = $request->note;
								$CashBook->person_type = 'supplier';
								$CashBook->created_by = Auth::user()->id;
								$CashBook->save();
								Session::flash('message', 'Cash Payment Successfully !');
								return back();

							}
						} else {
							Session::flash('message', 'Input Valid Invoice Number !');
							return back();
						}

					}

				}

			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

//Cash receive from Owner
	public function capitalReceive(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {
			if ($request->recevedAmount != null && $request->recevedAmount != '') {
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$today = $date;
				$CapitalAccount = new CapitalAccount();
				$CapitalAccount->account_no = $request->account_number;
				$CapitalAccount->description = $request->note;
				$CapitalAccount->transection_date = $today;
				$CapitalAccount->credit = $request->recevedAmount;
				$CapitalAccount->created_by = Auth::user()->id;
				$CapitalAccount->status = 1;
				$CapitalAccount->save();

				$CashBook = new CashBook();
				$CashBook->account_no = $request->cash_book ?? 1;
				$CashBook->own_account_no = $request->account_number;
				$CashBook->transection_date = $today;
				$CashBook->debit = $request->recevedAmount;
				$CashBook->description = $request->note;
				$CashBook->person_type = 'capital';
				$CashBook->created_by = Auth::user()->id;
				$CashBook->save();
				Session::flash('message', 'Capital Received Successfully !');

				return back();
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function expense_paid(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {
			if ($request->recevedAmount != null && $request->recevedAmount != '') {

				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$today = $date;
				$ExpenseAccount = new ExpenseAccount();
				$ExpenseAccount->account_no = $request->account_number;
				$ExpenseAccount->description = $request->note;
				$ExpenseAccount->transection_date = $today;
				$ExpenseAccount->ref_no = $request->ref_no;
				$ExpenseAccount->debit = $request->recevedAmount;
				$ExpenseAccount->status = 1;
				$ExpenseAccount->created_by = Auth::user()->id;
				$ExpenseAccount->save();

				$CashBook = new CashBook();
				$CashBook->account_no = $request->cash_book ?? 1;
				$CashBook->own_account_no = $request->account_number;
				$CashBook->transection_date = $today;
				$CashBook->credit = $request->recevedAmount;
				$CashBook->description = $request->note;
				$CashBook->person_type = 'expense';
				$CashBook->created_by = Auth::user()->id;
				$CashBook->save();
				Session::flash('message', 'Expense Record Successfully !');

				return back();
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function expenseTransectionReverse(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {
			if ($request->recevedAmount != null && $request->recevedAmount != '') {

				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$today = $date;
				$ExpenseAccount = new ExpenseAccount();
				$ExpenseAccount->account_no = $request->account_number;
				$ExpenseAccount->description = $request->note;
				$ExpenseAccount->transection_date = $today;
				$ExpenseAccount->ref_no = $request->ref_no;
				$ExpenseAccount->credit = $request->recevedAmount;
				$ExpenseAccount->status = 1;
				$ExpenseAccount->created_by = Auth::user()->id;
				$ExpenseAccount->save();

				$CashBook = new CashBook();
				$CashBook->account_no = $request->cash_book ?? 1;
				$CashBook->own_account_no = $request->account_number;
				$CashBook->transection_date = $today;
				$CashBook->debit = $request->recevedAmount;
				$CashBook->description = $request->note;
				$CashBook->person_type = 'expense';
				$CashBook->created_by = Auth::user()->id;
				$CashBook->save();
				Session::flash('message', 'Expense Transection Reverse Successfully !');

				return redirect('reverse-expense');
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function withdrow(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_add')) {
			if ($request->recevedAmount != null && $request->recevedAmount != '') {
				$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
				$date = $dt->format('Y-m-d H:i:s');
				$today = $date;
				$CapitalAccount = new CapitalAccount();
				$CapitalAccount->account_no = $request->account_number;
				$CapitalAccount->description = $request->note;
				$CapitalAccount->transection_date = $today;
				$CapitalAccount->debit = $request->recevedAmount;
				$CapitalAccount->status = 1;
				$CapitalAccount->created_by = Auth::user()->id;
				$CapitalAccount->save();

				$CashBook = new CashBook();
				$CashBook->account_no = $request->cash_book ?? 1;
				$CashBook->own_account_no = $request->account_number;
				$CashBook->transection_date = $today;
				$CashBook->credit = $request->recevedAmount;
				$CashBook->description = $request->note;
				$CashBook->person_type = 'capital';
				$CashBook->created_by = Auth::user()->id;
				$CashBook->save();
				Session::flash('message', 'Capital Withdrow Successfully !');

				return back();
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}

	public function fetch_owner() {
		$OwnerProfile = new OwnerProfile();
		$OwnerProfile = OwnerProfile::get();
		return json_encode($OwnerProfile);

	}
	public function cashReceiveFromCustomer() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('cash_view')) {
			return view('cash.owner_receive');
		} else {
			return "Sorry you don't have access to this action";
		}

	}
	public function withdrowByOwner() {
		$library = new \App\Library\Library;
		if ($library->check_user_access('capital_view')) {
			return view('cash.withdrow');
		} else {
			return "Sorry you don't have access to this action";
		}
	}

	public function ownerWiseHistory(Request $request) {
		$library = new \App\Library\Library;
		if ($library->check_user_access('capital_view')) {
			if ($request->has('own')) {
				$query = "SELECT SUM(`credit`) as capital,SUM(debit) as withdrow
			FROM capital_accounts
			WHERE account_no =" . $request->own . " ";
				$history = DB::select($query);

				foreach ($history as $value) {
					if ($value->capital == null && $value->withdrow == null) {
						$historyResult = "<tr><td colspan='2'>No Transection History Available</td></tr>";
						$balance = "No Balance ";
					} else {
						$historyResult = "<tr><td>" . number_format(($value->capital ?? 0), 2) . "</td><td>" . number_format(($value->withdrow ?? 0), 2) . "</td></tr>";
						$balance = number_format($value->capital - $value->withdrow);
					}

				}

				return json_encode(['capital' => $historyResult, 'balance' => $balance]);
			}
		} else {
			return "Sorry you don't have access to this action";
		}

	}
}
