<?php

namespace App\Http\Controllers;
use App\BankAccountProfile;
use App\BankAccounts;
use DB;
use Illuminate\Http\Request;
use Session;
use Carbon\Carbon;

class BankAccountProfiles extends Controller {
	public function index() {
		$info = DB::select(" SELECT t1.*,SUM(IFNULL(t2.debit,0)-IFNULL(t2.credit,0)) AS balance FROM bank_account_profiles AS t1
LEFT JOIN bank_accounts AS t2 ON t2.account_no=t1.id
GROUP BY t1.id ");

		return view('bank.index', compact('info'));
	}

	//function for bank account profile insert
	public function store(Request $request) {
		$request->validate([
			'bank_name' => 'required',
			'bank_account' => 'required|unique:bank_account_profiles,bank_account',
		]);
		$BankAccountProfile = new BankAccountProfile();
		$BankAccountProfile->bank_name = $request->bank_name;
		$BankAccountProfile->bank_account = $request->bank_account;
		$BankAccountProfile->address = $request->address;
		$BankAccountProfile->phone = $request->phone;
		$BankAccountProfile->description = $request->description;
		$BankAccountProfile->status = $request->status;
		$BankAccountProfile->save();

		$id = $BankAccountProfile->id;

		if($request->debit > 0 || $request->credit > 0){
			$date = Carbon::today();
			$BankAccounts  = new BankAccounts();
			$BankAccounts->account_no = $id;

			
			$BankAccounts->own_account_no =  "opening";

			$BankAccounts->transection_no = "opening";
			$BankAccounts->ref_no = "opening";
			$BankAccounts->description = "Opening Balance";
			$BankAccounts->transection_date = $date;
			$BankAccounts->debit = $request->debit ?? 0;
			$BankAccounts->credit = $request->credit ?? 0;
			$BankAccounts->credit = $request->credit ?? 0;
			$BankAccounts->status = $request->status ?? 1;
			$BankAccounts->save();

		}

		Session::flash('message', 'Bank Account Created Successfully !');
		return redirect()->back();
	}

	public function edit($id) {
		//$info = BankAccountProfile::find($id);
		$infos = DB::select(" SELECT t1.*,t2.debit, t2.credit FROM bank_account_profiles AS t1
				LEFT JOIN bank_accounts AS t2 ON t2.account_no=t1.id
				WHERE t1.id=$id AND t2.ref_no='opening' ");
		if(!$infos){
			$infos = DB::select(" SELECT t1.*,0 as debit, 0 as credit FROM bank_account_profiles AS t1 WHERE t1.id=$id  ");
		}

		return view('bank.edit', compact('infos'));
	}

	public function update(Request $request, $id) {
		$library = new \App\Library\Library;
		$request->validate([
			'bank_name' => 'required',
			'bank_account' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'BankAccountProfile', ['id', $request->id]);

		if($request->debit > 0 || $request->credit > 0){
			$date = Carbon::today();
			$BankAccounts  = BankAccounts::where('account_no',$request->id)->where('transection_no','opening')->where('ref_no','opening')->first();
			if(!$BankAccounts){
				$BankAccounts  = new BankAccounts();
			}
			$BankAccounts->account_no = $id;
			$BankAccounts->transection_no = "opening";
			$BankAccounts->ref_no = "opening";
			$BankAccounts->description = "Opening Balance";
			$BankAccounts->transection_date = $date;
			$BankAccounts->debit = $request->debit ?? 0;
			$BankAccounts->credit = $request->credit ?? 0;
			$BankAccounts->credit = $request->credit ?? 0;
			$BankAccounts->status = $request->status ?? 1;
			$BankAccounts->save();

		}
		Session::flash('message', 'Bank Account Updated Successfully !');
		return redirect('bank');

	}
}
