<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountLedger;
use App\AccountHead;
use App\AccountDetail;
use App\AccountVoucherMaster;
use App\SettingOption;
use Auth;

class AccountingLedgerController extends Controller
{

	public function chartAccounts(){
		  $info = AccountHead::with(['chart_detail'])->get();
         return view('account_report.chart_account',compact('info'));
	}

    public function salesSetting(){
        $info = SettingOption::first();
    }
    // cash, bank and cash equievelent account tk receive
    public function receiveJournalView(){
    	$cash = AccountDetail::where('status',1)->whereIn('ad_al2_id',[12,13,14])->get();
    	$others = AccountDetail::where('status',1)->get();
    	return view('journal.receive',compact('cash','others'));
    }

    public function receiveJournal(Request $request){
    	//return $request->all();
    	$voucher_number = AccountVoucherMaster::count();
    	$voucher_number= ($voucher_number+1);
    	if(strlen($voucher_number)==1){
    		$voucher_number = "0".$voucher_number;
    	}
    	$vm_user = Auth::user()->name ?? '';
    	$vm_no= date('Y')."-".$voucher_number;
    	$AccountVoucherMaster = new AccountVoucherMaster();
    	$AccountVoucherMaster->vm_no = $vm_no;
    	$AccountVoucherMaster->vm_date =  $request->vm_date ??  date('Y-m-d H:i:s');
    	$AccountVoucherMaster->vm_type = $request->lg_voucher_type ?? '' ;
    	$AccountVoucherMaster->vm_naration = $request->note ?? '';
    	$AccountVoucherMaster->vm_user = $vm_user;
    	$AccountVoucherMaster->vm_post_flag = $request->vm_post_flag ?? 1;
    	$AccountVoucherMaster->vm_amount = $request->amount ?? 0;
    	$AccountVoucherMaster->status = $request->status ?? 1;
    	$AccountVoucherMaster->save();

    	//Debit amount save
    	$AccountLedger = new AccountLedger();
    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
    	$AccountLedger->lg_voucher_no = $vm_no;
    	$AccountLedger->lg_particulars = $request->note ?? '';
    	$AccountLedger->lg_ad_id =$request->debit_id ?? '';
    	$AccountLedger->lg_dr_amt = $request->amount ?? 0;
    	$AccountLedger->lg_cr_amt =  0;
    	$AccountLedger->lg_data_flag = 1;
    	$AccountLedger->lg_voucher_type = $request->lg_voucher_type ?? '' ;
    	$AccountLedger->lg_usr = $vm_user;
    	$AccountLedger->lg_naration = $request->note ?? '';
    	$AccountLedger->save();

    	//Credit Amount save
    	$AccountLedger = new AccountLedger();
    	$AccountLedger->lg_voucher_date = $request->vm_date ??  date('Y-m-d H:i:s');
    	$AccountLedger->lg_voucher_no = $vm_no;
    	$AccountLedger->lg_particulars = $request->note ?? '';
    	$AccountLedger->lg_ad_id =$request->credit_id ?? '';
    	$AccountLedger->lg_dr_amt =  0;
    	$AccountLedger->lg_cr_amt = $request->amount ?? 0;
    	$AccountLedger->lg_data_flag = 1;
    	$AccountLedger->lg_voucher_type = $request->lg_voucher_type ?? '' ;
    	$AccountLedger->lg_usr = $vm_user;
    	$AccountLedger->lg_naration = $request->note ?? '';
    	$AccountLedger->save();

    	return redirect('voucher-list')->with('message', 'Insert Successfully');


    }

    public function paymentJournalView(){
    	$cash = AccountDetail::where('status',1)->whereIn('ad_al2_id',[12,13,14])->get();
    	$others = AccountDetail::where('status',1)->get();
    	return view('journal.paid',compact('cash','others'));
    }
    public function adjustmentJournalView(){
    	$cash=[];
    	$others = AccountDetail::where('status',1)->get();
    	return view('journal.adjustment',compact('cash','others'));
    }


    public function voucherList(Request $request){

    	$limit = $request->limit ?? 20;
		$date = $request->date ?? '';
		$vm_no = $request->vm_no ?? '';
		if($request->has('limit')){
			if($request->limit == "All"){
				$limit = "All";
				
			}
		}

    	$vm_types = AccountVoucherMaster::select('vm_type')->groupBy('vm_type')->get();

    	$info = AccountVoucherMaster::where('status',1);
    	if($request->has('vm_type')){
    		if($request->vm_type !=''){
    			$info = $info->where('vm_type',$request->vm_type);
    		}
    	}
    	if($date !="" ){
    		$$date = date('Y-m-d', $date);
			$info = $info->where('vm_date', 'LIKE', "%{$date}%");
		}
		if($vm_no !="" ){
			$info = $info->where('vm_no', 'LIKE', "%{$vm_no}%");
		}
		if($limit !='' && $limit !="All"){
			$info = $info->take($limit);
		}
		$info = $info->with(['voucher_details'])->orderBy('id','desc')->get();

		return view('journal.index',compact('vm_types','info','request'));


    }

    //Voucher Print
    public function voucherPrint($id){
          $info = \DB::table('account_voucher_masters')
                ->join('account_ledgers','account_ledgers.lg_voucher_no','account_voucher_masters.vm_no')
                ->join('account_details','account_details.id','account_ledgers.lg_ad_id')
                ->where('account_voucher_masters.id',$id)
                ->get();

    	  //$info = AccountVoucherMaster::with(['voucher_details'])->find($id);
    	return view('journal.voucher_print',compact('info'));
    }


}
