<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\AccountLevelOne;
use App\AccountLevelTwo;
use App\AccountHead;
use App\AccountLedger;
use App\AccountDetail;
use DB;

class AccountReportController extends Controller
{
    public function ledger(){
    	$account_heads = AccountDetail::where('status',1)->get();
    	return view('account_report.ledger.search',compact('account_heads'));
    }

    public function accountLevelTwoChange(Request $request){
    	$data = AccountLevelOne::where('ah_id',$request->id)->where('status',1)->get();
    	return response()->json($data);
    }

    public function accountLevelThreeChange(Request $request){
    	$data = AccountLevelTwo::where('al1_id',$request->id)->where('status',1)->get();
    	return response()->json($data);
    }
    public function accountLevelFourChange(Request $request){
    	$data = AccountDetail::where('ad_al2_id',$request->id)->where('status',1)->get();
    	return response()->json($data);
    }

    public function getLedgerReport(Request $request){
    	$request->validate([
			'ad_al4_id' => 'required',
			'start_date' => 'required',
			'end_date' => 'required',
		]);
		$start_date = $request->start_date;
		$end_date = $request->end_date;
    	$ledgers = DB::table('account_ledgers')->where('account_ledgers.lg_ad_id','=',$request->ad_al4_id)->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])->select('account_ledgers.*')->get();
    	$balance = DB::table('account_ledgers')->where('account_ledgers.lg_ad_id','=',$request->ad_al4_id)->where('account_ledgers.lg_voucher_date','<' ,$start_date)->select(DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'), DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'))->first();
    	$acc_name = AccountDetail::find($request->ad_al4_id);
    	return view('account_report.ledger.index',compact('ledgers','balance','acc_name','start_date','end_date'));
    }

    public function trialBalance(){
    	return view('account_report.trial-balance.search');
    }

    public function getTrialBalanceReport(Request $request){
    	$request->validate([
			'start_date' => 'required',
			'end_date' => 'required',
		]);
		$start_date = $request->start_date;
		$end_date = $request->end_date;
    	$trials = DB::table('account_ledgers')->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])->leftjoin('account_details','account_ledgers.lg_ad_id','=','account_details.id')->select('account_details.name',DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->groupBy('account_details.name')->get();
    	return view('account_report.trial-balance.index',compact('trials','start_date','end_date'));
    }

    public function lossAndProfit(){
    	return view('account_report.loss-profit.search');
    }

    public function lossAndProfitreport(Request $request){
    	$request->validate([
			'start_date' => 'required',
			'end_date' => 'required',
		]);
		$start_date = $request->start_date;
		$end_date = $request->end_date;
    	$incomes = DB::table('account_heads')->where('account_heads.ah_id',3)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])
    	 		->select('account_details.name','account_ledgers.lg_ad_id',DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->groupBy('account_ledgers.lg_ad_id')->get();
    	$t_incomes = DB::table('account_heads')->where('account_heads.ah_id',3)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])
    			->sum('account_ledgers.lg_cr_amt');
    	$expanses = DB::table('account_heads')->where('account_heads.ah_id',4)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])
    			->select('account_details.name','account_ledgers.lg_ad_id',DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->groupBy('account_ledgers.lg_ad_id')->get();
    	$t_expanses = DB::table('account_heads')->where('account_heads.ah_id',4)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])
    			->sum('account_ledgers.lg_dr_amt');
    	return view('account_report.loss-profit.index',compact('incomes','t_incomes','expanses','t_expanses','start_date','end_date'));
    }

    public function balanceSheet(){
    	return view('account_report.balance-sheet.search');
    }

    public function balanceSheetReport(Request $request){
    	$request->validate([
			'start_date' => 'required',
			'end_date' => 'required',
		]);
		$start_date = $request->start_date;
		$end_date = $request->end_date;
    	$ass_balance = DB::table('account_heads')->where('account_heads.ah_id',1)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->where('account_ledgers.lg_voucher_date','<' ,$start_date)
    	 		->select(DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->first();
    	
    	$lib_balance = DB::table('account_heads')->where('account_heads.ah_id',2)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->where('account_ledgers.lg_voucher_date','<' ,$start_date)
    	 		->select(DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->first();
    	$cap_balance = DB::table('account_heads')->where('account_heads.ah_id',5)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->where('account_ledgers.lg_voucher_date','<' ,$start_date)
    	 		->select(DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->first();
    	$t_incomes = DB::table('account_heads')->where('account_heads.ah_id',3)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])
    			->sum('account_ledgers.lg_cr_amt');
    	$t_expanses = DB::table('account_heads')->where('account_heads.ah_id',4)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->whereBetween('account_ledgers.lg_voucher_date', [$start_date, $end_date])
    			->sum('account_ledgers.lg_dr_amt');
    	$assets = DB::table('account_heads')->where('account_heads.ah_id',1)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->where('account_ledgers.lg_voucher_date','<' ,$start_date)
    	 		->select('account_details.name','account_ledgers.lg_ad_id',DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->groupBy('account_ledgers.lg_ad_id')->get();
    	$libilities = DB::table('account_heads')->where('account_heads.ah_id',2)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->where('account_ledgers.lg_voucher_date','<' ,$start_date)
    	 		->select('account_details.name','account_ledgers.lg_ad_id',DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->groupBy('account_ledgers.lg_ad_id')->get();
    	$capitals = DB::table('account_heads')->where('account_heads.ah_id',5)
    			->leftjoin('account_level_ones','account_heads.ah_id','=','account_level_ones.ah_id')
    			->leftjoin('account_level_twos','account_level_ones.id','=','account_level_twos.al1_id')
    			->leftjoin('account_details','account_level_twos.id','=','account_details.ad_al2_id')
    			->leftjoin('account_ledgers','account_details.id','=','account_ledgers.lg_ad_id')
    			->where('account_ledgers.lg_voucher_date','<' ,$start_date)
    	 		->select('account_details.name','account_ledgers.lg_ad_id',DB::raw('sum(account_ledgers.lg_cr_amt) as total_credit'),DB::raw('sum(account_ledgers.lg_dr_amt) as total_debit'))->groupBy('account_ledgers.lg_ad_id')->get();

    	return view('account_report.balance-sheet.index',compact('ass_balance','lib_balance','cap_balance','t_incomes','assets','capitals','libilities','t_expanses','start_date','end_date'));
    }
}
