<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountLevelOne;
use App\AccountLevelTwo;
use App\AccountHead;
use App\AccountLedger;

class AccountLeadgerController extends Controller
{
    public function index(Request $request) {
		
		
		$account_heads = AccountLevelOne::where('status',1)->get();

		$limit = $request->limit ?? 20;
		$name = $request->name ?? '';
		$code = $request->code ?? '';
		$al1_id = $request->al1_id ?? '';
		if($request->has('limit')){
			if($request->limit == "All"){
				$limit = "All";
				
			}
		}
		

		$info = AccountLedger::where('status',1);
		if($name !="" ){
			$info = $info->where('name', 'LIKE', "%{$name}%");
		}
		if($code !="" ){
			$info = $info->where('code', 'LIKE', "%{$code}%");
		}
		if($al1_id !="" ){
			$info = $info->where('al1_id', $al1_id);
		}
		if($limit !='' && $limit !="All"){
			$info = $info->take($limit);
		}
		$info = $info->with(['account_sub_category'])->get();
		//return $request;
		return view('account-two.index',compact('info','account_heads','request'));

	}
}
