<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\AccountLevelOne;
use App\AccountLevelTwo;
use App\AccountHead;

class AccountLavelTwoController extends Controller
{
    /**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index(Request $request) {
		

		$account_heads = AccountLevelOne::where('status',1)->get();

		$limit = $request->limit ?? 20;
		$name = $request->name ?? '';
		$code = $request->code ?? '';
		$al1_id = $request->al1_id ?? '';
		if($request->has('limit')){
			if($request->limit == "All"){
				$limit = "All";
				
			}
		}
		

		$info = AccountLevelTwo::where('status',1);
		if($name !="" ){
			$info = $info->where('name', 'LIKE', "%{$name}%");
		}
		if($code !="" ){
			$info = $info->where('code', 'LIKE', "%{$code}%");
		}
		if($al1_id !="" ){
			$info = $info->where('al1_id', $al1_id);
		}
		if($limit !='' && $limit !="All"){
			$info = $info->take($limit);
		}
		$info = $info->with(['account_category'])->orderBy('id','desc')->get();
		//return $request;
		return view('account-two.index',compact('info','account_heads','request'));

	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create(Request $request) {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$request->validate([
			'name' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud_result = $crud->InsertValue('AccountLevelTwo', $request->all());
		//$info = $crud->Getvalue('AccountLevelOne');
		$request=[];
		return redirect('account-level-two')->with('message', 'Insert Successfully');
	}

	public function show($id) {
		//
	}

	public function edit($id) {
		$account_heads = AccountLevelOne::where('status',1)->get();
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('AccountLevelTwo', ['id', $id]);
		return view('account-two.edit', compact('info','account_heads'));

	}

	public function update(Request $request) {
		$request->validate([
			'name' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'AccountLevelTwo', ['id', $request->id]);
		return redirect('account-level-two')->with('message', 'Updated Successfully');

	}

	public function delete($id) {
		$AccountLevelTwo = AccountLevelTwo::find($id);
		$AccountLevelTwo->status=0;
		$AccountLevelTwo->save();
		return redirect('account-level-two')->with('message', 'Deleted Successfully');
	}
}
