<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\AccountLevelOne;
use App\AccountHead;

class AccountLavelOneController extends Controller
{
    /**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index(Request $request) {
		$account_heads = AccountHead::where('status',1)->get();

		$limit = $request->limit ?? 20;
		$name = $request->name ?? '';
		$code = $request->code ?? '';
		$ah_id = $request->ah_id ?? '';
		if($request->has('limit')){
			if($request->limit == "All"){
				$limit = "All";
				
			}
		}
		

		$info = AccountLevelOne::where('status',1);
		if($name !="" ){
			$info = $info->where('name', 'LIKE', "%{$name}%");
		}
		if($code !="" ){
			$info = $info->where('code', 'LIKE', "%{$code}%");
		}
		if($ah_id !="" ){
			$info = $info->where('ah_id', $ah_id);
		}
		if($limit !='' && $limit !="All"){
			$info = $info->take($limit);
		}
		 $info = $info->with(['account_head'])->get();
		//return $request;
		return view('account-one.index',compact('info','account_heads','request'));

	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create(Request $request) {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$request->validate([
			'name' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud_result = $crud->InsertValue('AccountLevelOne', $request->all());
		//$info = $crud->Getvalue('AccountLevelOne');
		$request=[];
		return redirect('account-level-one')->with('message', 'Insert Successfully');
	}

	public function show($id) {
		//
	}

	public function edit($id) {
		$account_heads = AccountHead::get();
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('AccountLevelOne', ['id', $id]);
		return view('account-one.edit', compact('info','account_heads'));

	}

	public function update(Request $request) {
		$request->validate([
			'name' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'AccountLevelOne', ['id', $request->id]);
		return redirect('account-level-one')->with('message', 'Updated Successfully');

	}

	public function delete($id) {
		$AccountLevelOne = AccountLevelOne::find($id);
		$AccountLevelOne->status=0;
		$AccountLevelOne->save();
		return redirect('account-level-one')->with('message', 'Deleted Successfully');
	}
}
