<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountHead;
use DB;
use Session;
use Carbon\Carbon;

class AccountHeadController extends Controller
{
   /**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index() {
		$library = new \App\Library\Library();
		$crud = new \App\Library\Crud;
		$info = $crud->Getvalue('AccountHead');
		return view('account-head.index', compact('info'));

	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create(Request $request) {

	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request) {
		$request->validate([
			'ah_name' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud_result = $crud->InsertValue('AccountHead', $request->all());
		$info = $crud->Getvalue('account-head');
		return view('account-head.table', compact('info'));
	}

	public function show($id) {
		//
	}

	public function edit($id) {
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('AccountHead', ['id', $id]);
		return view('account-head.edit', compact('info'));

	}

	public function update(Request $request) {
		$request->validate([
			'ah_name' => 'required',
		]);
		$crud = new \App\Library\Crud;
		$crud->UpdateValeWhereSingle($request->all(), 'AccountHead', ['id', $request->id]);
		return redirect('account-head')->with('message', 'Updated Successfully');

	}

	public function destroy($id) {
		$crud = new \App\Library\Crud;
		$crud->DeleteValueWhereSingle('AccountHead', ['id', $id]);
		return redirect('account-head')->with('message', 'Deleted Successfully');
	}
}
