<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountLevelOne;
use App\AccountLevelTwo;
use App\AccountHead;
use App\AccountDetail;

use Auth;
use Carbon\Carbon;
use DateTime;
use DateTimezone;
use DB;
use Session;
use App\SettingOption;
use App\AccountVoucherMaster;
use App\AccountLedger;


class AccountDetailController extends Controller
{
    public function index(Request $request) {
		
		
		$account_heads = AccountLevelTwo::where('status',1)->orderBy('code','ASC')->get();

		$limit = $request->limit ?? 20;
		$ad_name = $request->ad_name ?? '';
		$phone = $request->phone ?? '';
		$ad_address = $request->ad_address ?? '';
		$ad_al2_id = $request->ad_al2_id ?? '';
		if($request->has('limit')){
			if($request->limit == "All"){
				$limit = "All";
				
			}
		}
		
		$info = AccountDetail::where('status',1);
		if($ad_name !="" ){
			$info = $info->where('ad_name', 'LIKE', "%{$ad_name}%");
		}
		if($phone !="" ){
			$info = $info->where('phone', 'LIKE', "%{$phone}%");
		}
		if($ad_address !="" ){
			$info = $info->where('ad_address', 'LIKE', "%{$ad_address}%");
		}
		if($ad_al2_id !="" ){
			$info = $info->where('ad_al2_id', $ad_al2_id);
		}
		if($limit !='' && $limit !="All"){
			$info = $info->take($limit);
		}
		$info = $info->with(['account_sub_category'])->orderBy('name','asc')->get();
		//return $request;
		return view('account-details.index',compact('info','account_heads','request'));

	}

	//account details information save
	public function store(Request $request){
		//return $request->all();

		$request->validate([
			'name' => 'required',
			'ad_al2_id' => 'required',
		]);

		$AccountDetail = new AccountDetail();
		$AccountDetail->ad_name = $request->name ?? '';
		$AccountDetail->ad_code = $request->code ?? '';
		$AccountDetail->name = $request->name ?? '';
		$AccountDetail->ad_address = $request->address ?? '';
		$AccountDetail->address = $request->address ?? '';
		$AccountDetail->phone = $request->phone ?? '';
		$AccountDetail->ad_al2_id = $request->ad_al2_id ?? '';
		$AccountDetail->status = 1;
		$AccountDetail->save();

		$order_id = "";
		$options = SettingOption::first();
		$ad_id = $AccountDetail->id;
		$ad_name = $AccountDetail->name;

		if(floatval($request->dr_amount)  > 0){
			$gross_amount = $request->dr_amount;
		}

		if(floatval($request->cr_amount) > 0 ){
			$gross_amount = $request->cr_amount;
		}

		$opening_adjustment_ledger = $options->opening_adjustment_ledger ?? 11; //default inventory accounts
		$naration = $ad_name."  Opening balance ";

		if(floatval($request->dr_amount) > 0 || floatval($request->cr_amount) > 0 ){
			$voucher_number = AccountVoucherMaster::count();
	    	$voucher_number= ($voucher_number+1);
	    	if(strlen($voucher_number)==1){
	    		$voucher_number = "0".$voucher_number;
	    	}
	    	$vm_user = Auth::user()->name ?? '';
	    	$vm_no= date('Y')."-".$voucher_number;
	    	$AccountVoucherMaster = new AccountVoucherMaster();
	    	$AccountVoucherMaster->vm_no = $vm_no;
	    	$AccountVoucherMaster->vm_date =   date('Y-m-d');
	    	$AccountVoucherMaster->vm_type = 'JV' ;
	    	$AccountVoucherMaster->vm_naration = $naration;
	    	$AccountVoucherMaster->vm_user = $vm_user;
	    	$AccountVoucherMaster->vm_post_flag = 1;
	    	$AccountVoucherMaster->vm_no_id = $order_id;
	    	$AccountVoucherMaster->vm_amount = $gross_amount ?? 0;
	    	$AccountVoucherMaster->status = $request->status ?? 1;
	    	$AccountVoucherMaster->save();

	    		//Inventory Account Debit Amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars = $naration;
		    	$AccountLedger->lg_ad_id = $opening_adjustment_ledger ?? '';
		    	if(floatval($request->dr_amount) > 0){
		    		$AccountLedger->lg_cr_amt = floatval($request->dr_amount);
		    		
		    	}

		    	if(floatval($request->lg_cr_amt) > 0){
		    		$AccountLedger->dr_amount = floatval($request->lg_cr_amt);
		    	}
		    	
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $naration;
		    	$AccountLedger->save();

		    	//Supplier Account Credit Amount 
		    	$AccountLedger = new AccountLedger();
		    	$AccountLedger->lg_voucher_date = date('Y-m-d H:i:s');
		    	$AccountLedger->lg_voucher_no = $vm_no;
		    	$AccountLedger->lg_particulars =$naration;
		    	$AccountLedger->lg_ad_id = $ad_id ?? '';
		    	if(floatval($request->dr_amount) > 0){
		    		$AccountLedger->lg_dr_amt = floatval($request->dr_amount);
		    	}

		    	if(floatval($request->lg_cr_amt) > 0){
		    		$AccountLedger->lg_cr_amt = floatval($request->lg_cr_amt);
		    	}
		    	$AccountLedger->lg_data_flag = 1;
		    	$AccountLedger->lg_voucher_type = 'JV' ;
		    	$AccountLedger->lg_usr = $vm_user;
		    	$AccountLedger->lg_vd_sm_id =$order_id;
		    	$AccountLedger->lg_naration = $naration;
		    	$AccountLedger->save();
		}
		


		$request=[];
		return redirect('account-details')->with('message', 'Insert Successfully');
	}

	public function edit($id) {
		$account_heads = AccountLevelTwo::with(['account_category'])->where('status',1)->get();
		$crud = new \App\Library\Crud;
		$info = $crud->GetValueWhereSingle('AccountDetail', ['id', $id]);
		return view('account-details.edit', compact('info','account_heads'));

	}

	public function update(Request $request) {
		$request->validate([
			'name' => 'required',
			'ad_al2_id' => 'required',
		]);
		$AccountDetail = AccountDetail::find($request->id);
		$AccountDetail->ad_name = $request->name ?? '';
		$AccountDetail->ad_code = $request->code ?? '';
		$AccountDetail->name = $request->name ?? '';
		$AccountDetail->ad_address = $request->address ?? '';
		$AccountDetail->address = $request->address ?? '';
		$AccountDetail->phone = $request->phone ?? '';
		$AccountDetail->ad_al2_id = $request->ad_al2_id ?? '';
		$AccountDetail->status = 1;
		$AccountDetail->save();
		return redirect('account-details')->with('message', 'Updated Successfully');

	}

	public function delete($id) {
		$AccountDetail = AccountDetail::find($id);
		$AccountDetail->status=0;
		$AccountDetail->save();
		return redirect('account-details')->with('message', 'Deleted Successfully');
	}
}

